<div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.6); z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg modal-content-enhanced">
            <div class="modal-header bg-white border-0">
                <h5 class="modal-title fw-bold text-dark">
                    <i class="ri-arrow-down-circle-line me-2 text-warning"></i>Salida de Dinero
                </h5>
                <button type="button" class="btn-close" wire:click="cerrarModalSalidaDinero"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label fw-bold">Tipo de Salida</label>
                    <select class="form-select" wire:model.live="tipoSalida">
                        <option value="vuelto">Vuelto</option>
                        <option value="compra">Compra</option>
                        <option value="retiro">Retiro</option>
                        <option value="otro">Otro</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Monto</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-text">{{ get_current_currency_symbol() }}</span>
                        <input type="number" class="form-control" wire:model.live="montoSalida" step="0.01" min="0.01">
                    </div>
                    @error('montoSalida') <div class="text-danger small">{{ $message }}</div> @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Motivo</label>
                    <textarea class="form-control" wire:model.live="motivoSalida" rows="3"></textarea>
                    @error('motivoSalida') <div class="text-danger small">{{ $message }}</div> @enderror
                </div>
                <div class="alert alert-info small">
                    <i class="ri-information-line me-1"></i>
                    Esta salida se registrará en el movimiento de caja
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="cerrarModalSalidaDinero">Cancelar</button>
                <button type="button" class="btn btn-warning" wire:click="registrarSalidaDinero">Registrar Salida</button>
            </div>
        </div>
    </div>
</div>
