<div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.6); z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow-lg modal-content-enhanced">
            <div class="modal-header bg-white border-0">
                <h5 class="modal-title fw-bold text-dark">
                    <i class="ri-shopping-cart-2-line me-2 text-success"></i>Procesar Venta
                </h5>
                <button type="button" class="btn-close" wire:click="closePaymentModal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-7">
                        <h6 class="fw-bold mb-3">Datos de la Venta</h6>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cliente (Opcional)</label>
                            <select class="form-select" wire:model.live="cliente_id">
                                <option value="">Cliente General</option>
                                @foreach($clientes as $cliente)
                                    <option value="{{ $cliente->id }}">{{ $cliente->nombre_completo }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Tipo de Documento</label>
                                <select class="form-select" wire:model.live="tipoDocumento">
                                    <option value="boleta">Boleta</option>
                                    <option value="factura">Factura</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Serie</label>
                                <select class="form-select" wire:model.live="serie_id">
                                    @foreach($series as $serie)
                                        <option value="{{ $serie->id }}">{{ $serie->serie }}</option>
                                    @endforeach
                                </select>
                                @error('serie_id') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Método de Pago</label>
                            <select class="form-select form-select-lg" wire:model.live="metodoPago">
                                <option value="efectivo">Efectivo</option>
                                <option value="transferencia">Transferencia</option>
                                <option value="tarjeta">Tarjeta</option>
                                <option value="pago_movil">Pago Móvil</option>
                                <option value="punto_de_venta">Punto de Venta</option>
                            </select>
                            @error('metodoPago') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>

                        @if($metodoPago === 'efectivo')
                            <div class="mb-3">
                                <label class="form-label fw-bold">Monto Recibido</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text">{{ get_current_currency_symbol() }}</span>
                                    <input type="number" class="form-control" wire:model.live="montoPagado" step="0.01" min="{{ $this->getTotal() }}">
                                </div>
                                @error('montoPagado') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>

                            <div class="alert alert-info">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="fw-bold">Cambio:</span>
                                    <span class="h4 mb-0 fw-bold">{{ format_money($montoCambio) }}</span>
                                </div>
                            </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label fw-bold">Observaciones</label>
                            <textarea class="form-control" wire:model.live="observacionesVenta" rows="2"></textarea>
                        </div>
                    </div>

                    <div class="col-md-5">
                        <div class="bg-light rounded p-3">
                            <h6 class="fw-bold mb-3">Resumen de Venta</h6>
                            
                            <div class="mb-3" style="max-height: 200px; overflow-y: auto;">
                                @foreach($cart as $item)
                                    <div class="d-flex justify-content-between mb-2 small">
                                        <span>{{ $item['cantidad'] }}x {{ $item['nombre'] }}</span>
                                        <span class="fw-bold">{{ format_money($item['subtotal']) }}</span>
                                    </div>
                                @endforeach
                            </div>

                            <hr>

                            <div class="d-flex justify-content-between mb-2">
                                <span>Subtotal:</span>
                                <span class="fw-bold">{{ format_money($this->getTotal()) }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>IVA (0%):</span>
                                <span class="fw-bold">{{ format_money(0) }}</span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between mb-3">
                                <span class="h5 mb-0 fw-bold">Total:</span>
                                <span class="h4 mb-0 fw-bold text-success">{{ format_money($this->getTotal()) }}</span>
                            </div>

                            <div class="alert alert-warning small mb-0">
                                <i class="ri-information-line me-1"></i>
                                Verifique los datos antes de procesar
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="closePaymentModal">Cancelar</button>
                <button type="button" class="btn btn-success btn-lg" wire:click="procesarVenta">
                    <i class="ri-check-line me-2"></i>Confirmar Venta
                </button>
            </div>
        </div>
    </div>
</div>
