<div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.6); z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content border-0 shadow-lg modal-content-enhanced">
            <div class="modal-header bg-white border-0">
                <h5 class="modal-title fw-bold text-dark">
                    <i class="ri-safe-line me-2 text-info"></i>Detalle de Caja
                </h5>
                <button type="button" class="btn-close" wire:click="cerrarModalDetalleCaja"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="fw-bold mb-3">Información General</h6>
                                <div class="mb-2">
                                    <small class="text-muted">Fecha Apertura:</small>
                                    <div class="fw-bold">{{ $cajaAbierta->fecha_apertura->format('d/m/Y H:i') }}</div>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">Monto Inicial:</small>
                                    <div class="fw-bold text-success">{{ format_money($cajaAbierta->monto_inicial) }}</div>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">Total Ingresos:</small>
                                    <div class="fw-bold text-primary">{{ format_money($cajaAbierta->total_ingresos ?? 0) }}</div>
                                </div>
                                <div class="mb-2">
                                    <small class="text-muted">Monto Final:</small>
                                    <div class="fw-bold text-success fs-5">{{ format_money($cajaAbierta->monto_final ?? 0) }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-8 mb-3">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="fw-bold mb-3">Métodos de Pago</h6>
                                <div class="row">
                                    <div class="col-md-4 mb-2">
                                        <div class="p-3 bg-light rounded">
                                            <small class="text-muted">Efectivo</small>
                                            <div class="fw-bold text-success">{{ format_money($cajaAbierta->total_efectivo ?? 0) }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-2">
                                        <div class="p-3 bg-light rounded">
                                            <small class="text-muted">Transferencias</small>
                                            <div class="fw-bold text-primary">{{ format_money($cajaAbierta->total_transferencias ?? 0) }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-2">
                                        <div class="p-3 bg-light rounded">
                                            <small class="text-muted">Tarjetas</small>
                                            <div class="fw-bold text-info">{{ format_money($cajaAbierta->total_tarjetas ?? 0) }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if(count($salidasDinero) > 0)
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="fw-bold mb-3">Movimientos</h6>
                                    <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Tipo</th>
                                                    <th>Monto</th>
                                                    <th>Motivo</th>
                                                    <th>Fecha</th>
                                                    <th>Usuario</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($salidasDinero as $mov)
                                                    <tr>
                                                        <td>
                                                            <span class="badge bg-{{ $mov['tipo'] === 'ingreso' ? 'success' : 'warning' }}">
                                                                {{ ucfirst($mov['tipo']) }}
                                                            </span>
                                                        </td>
                                                        <td class="fw-bold">{{ format_money($mov['monto']) }}</td>
                                                        <td>{{ $mov['motivo'] }}</td>
                                                        <td>{{ $mov['fecha'] }}</td>
                                                        <td>{{ $mov['usuario'] }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
