<!-- Modal Registro de Cliente -->
@if($showCustomerModal)
<div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
    <div class="modal-dialog modal-lg">
        <div class="modal-content modal-content-enhanced border-0 shadow-lg">
            <div class="modal-header bg-white border-0 pb-0">
                <div class="d-flex align-items-center">
                    <div class="avatar avatar-sm me-3">
                        <div class="avatar-initial bg-primary rounded">
                            <i class="ri-user-add-line text-white"></i>
                        </div>
                    </div>
                    <div>
                        <h5 class="modal-title mb-0 fw-bold">Registrar Nuevo Cliente</h5>
                        <small class="text-muted">F9 - Agregar cliente para la venta</small>
                    </div>
                </div>
                <button type="button" class="btn-close" wire:click="closeCustomerModal"></button>
            </div>
            
            <form wire:submit="saveCustomer">
                <div class="modal-body">
                    <div class="row g-3">
                        <!-- Nombre completo -->
                        <div class="col-12">
                            <label class="form-label fw-medium">
                                <i class="ri-user-line me-1 text-primary"></i>
                                Nombre Completo <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control form-control-lg" 
                                   wire:model="newCustomer.name" 
                                   placeholder="Ingrese el nombre completo del cliente"
                                   required>
                            @error('newCustomer.name') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <label class="form-label fw-medium">
                                <i class="ri-mail-line me-1 text-info"></i>
                                Correo Electrónico
                            </label>
                            <input type="email" class="form-control" 
                                   wire:model="newCustomer.email" 
                                   placeholder="cliente@ejemplo.com">
                            @error('newCustomer.email') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>

                        <!-- Teléfono -->
                        <div class="col-md-6">
                            <label class="form-label fw-medium">
                                <i class="ri-phone-line me-1 text-success"></i>
                                Teléfono
                            </label>
                            <input type="text" class="form-control" 
                                   wire:model="newCustomer.telefono" 
                                   placeholder="+58 412 123 4567">
                            @error('newCustomer.telefono') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>

                        <!-- Dirección -->
                        <div class="col-12">
                            <label class="form-label fw-medium">
                                <i class="ri-map-pin-line me-1 text-warning"></i>
                                Dirección
                            </label>
                            <textarea class="form-control" rows="3" 
                                      wire:model="newCustomer.direccion" 
                                      placeholder="Dirección completa del cliente"></textarea>
                            @error('newCustomer.direccion') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>
                    </div>

                    <!-- Info adicional -->
                    <div class="alert alert-info border-0 mt-3">
                        <div class="d-flex align-items-center">
                            <i class="ri-information-line me-2"></i>
                            <div>
                                <strong>Información:</strong> El cliente será registrado automáticamente y seleccionado para esta venta.
                                <br><small>Se asignará una contraseña temporal: <code>123456</code></small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-secondary" wire:click="closeCustomerModal">
                        <i class="ri-close-line me-1"></i>Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:target="saveCustomer">
                        <span wire:loading.remove wire:target="saveCustomer">
                            <i class="ri-user-add-line me-1"></i>Registrar Cliente
                        </span>
                        <span wire:loading wire:target="saveCustomer" class="d-flex align-items-center">
                            <div class="spinner-border spinner-border-sm me-2" role="status">
                                <span class="visually-hidden">Cargando...</span>
                            </div>
                            Registrando cliente...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif