<div>
    @if (session()->has('message'))
        <script>
            window.addEventListener('DOMContentLoaded', function() {
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        type: 'success',
                        message: '{{ session('message') }}',
                        timeout: 5000
                    }
                }));
            });
        </script>
    @endif

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-1">Pedido {{ $pedido->codigo }}</h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-style">
                            <li class="breadcrumb-item"><a href="{{ route('admin.pedidos.index') }}">Pedidos</a></li>
                            <li class="breadcrumb-item active">{{ $pedido->codigo }}</li>
                        </ol>
                    </nav>
                </div>
                <div class="d-flex gap-2">
                    @if($pedido->estado === 'pendiente')
                        <button class="btn btn-success" wire:click="confirmarPago"
                                wire:confirm="¿Confirmar el pago de este pedido?">
                            <i class="ri-check-line"></i> Confirmar Pago
                        </button>
                    @endif

                    @if(in_array($pedido->estado, ['pagado', 'asignado']))
                        <button class="btn btn-info" wire:click="abrirModalAsignar">
                            <i class="ri-user-add-line"></i> Asignar Empleado
                        </button>
                    @endif

                    @if($pedido->estado === 'asignado')
                        <button class="btn btn-primary" wire:click="finalizarEntrega"
                                wire:confirm="¿Marcar como entregado?">
                            <i class="ri-check-double-line"></i> Finalizar Entrega
                        </button>
                    @endif

                    @if(!in_array($pedido->estado, ['entregado', 'cancelado']))
                        <button class="btn btn-danger" wire:click="abrirModalCancelar">
                            <i class="ri-close-line"></i> Cancelar
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Información del Pedido -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Información del Pedido</h5>
                    @php
                        $badgeClass = match($pedido->estado) {
                            'pendiente' => 'bg-warning',
                            'pagado' => 'bg-success',
                            'asignado' => 'bg-info',
                            'entregado' => 'bg-primary',
                            'cancelado' => 'bg-danger',
                            default => 'bg-secondary'
                        };

                            // Obtener la tasa de cambio del día del pago
                        $tasaDelDia = \App\Models\ExchangeRate::whereDate('date', $pedido->created_at->toDateString())
                            ->orderBy('fetch_time', 'desc')
                            ->value('usd_rate') ?? 1;
                        $montoUsdEquivalente = $pedido->total_usd * $tasaDelDia;
                              
                   @endphp
                    <span class="badge {{ $badgeClass }} fs-6">
                        <i class="{{ $this->getStatusIcon($pedido->estado) }} me-1"></i>
                        {{ ucfirst($pedido->estado) }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Código:</strong></td>
                                    <td>{{ $pedido->codigo }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Fecha:</strong></td>
                                    <td>{{ $pedido->created_at->format('d/m/Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Método de Pago:</strong></td>
                                    <td>
                                        <span class="badge bg-label-info">
                                            <i class="{{ $this->getPaymentMethodIcon($pedido->metodo_pago) }} me-1"></i>
                                            {{ ucfirst($pedido->metodo_pago) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Total {{ auth()->user()->empresa->pais->moneda_principal }}:</strong></td>
                                    <td><strong class="text-success">{{ format_money($pedido->total_usd, 2) }}</strong></td>
                                </tr>
                                @if($pedido->total_bs && auth()->user()->empresa->pais_id == 20)
                                <tr>
                                    <td><strong>Total Bs:</strong></td>
                                    <td><strong class="text-info">Bs {{ number_format($montoUsdEquivalente, 2) }}</strong></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        <div class="col-md-6">
                            @if($pedido->ubicacion)
                            <div class="mb-3">
                                <strong>Ubicación:</strong>
                                <p class="mb-1">{{ $pedido->ubicacion }}</p>
                                @if($pedido->latitud && $pedido->longitud)
                                    <a href="https://maps.google.com/?q={{ $pedido->latitud }},{{ $pedido->longitud }}"
                                       target="_blank" class="btn btn-sm btn-outline-primary">
                                        <i class="ri-map-pin-line"></i> Ver en Mapa
                                    </a>
                                @endif
                            </div>
                            @endif

                            @if($pedido->nota)
                            <div class="mb-3">
                                <strong>Nota:</strong>
                                <p class="mb-0">{{ $pedido->nota }}</p>
                            </div>
                            @endif

                            @if($pedido->fecha_entrega)
                            <div class="mb-3">
                                <strong>Fecha Estimada de Entrega:</strong>
                                <p class="mb-0">{{ $pedido->fecha_entrega->format('d/m/Y') }}</p>
                            </div>
                            @endif

                            @if($pedido->direccion_entrega)
                            <div class="mb-3">
                                <strong>Dirección de Entrega:</strong>
                                <p class="mb-0">{{ $pedido->direccion_entrega }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Timeline de Estado del Pedido -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="ri-route-line me-2"></i>Seguimiento del Pedido
                    </h5>
                </div>
                <div class="card-body">
                    <div class="order-progress-timeline">
                        @php
                            $timelineSteps = $this->getTimelineSteps();
                            $currentStatus = strtolower($pedido->estado);
                            $statusOrder = ['pendiente', 'pagado', 'asignado', 'entregado', 'cancelado'];
                            $currentIndex = array_search($currentStatus, $statusOrder);
                        @endphp
                        
                        @foreach($statusOrder as $index => $status)
                            @if(isset($timelineSteps[$status]))
                                @php
                                    $step = $timelineSteps[$status];
                                    $isCompleted = $currentIndex !== false && $index <= $currentIndex && $currentStatus !== 'cancelado';
                                    $isActive = $currentIndex !== false && $index === $currentIndex;
                                    $isCancelled = $currentStatus === 'cancelado' && $index === $currentIndex;
                                @endphp
                                
                                <div class="timeline-step {{ $isCompleted ? 'completed' : '' }} {{ $isActive ? 'active' : '' }} {{ $isCancelled ? 'cancelled' : '' }}">
                                    <div class="step-icon" data-bs-toggle="tooltip" title="{{ $step['description'] }}">
                                        <i class="{{ $step['icon'] }}"></i>
                                    </div>
                                    <div class="step-content">
                                        <h6 class="step-title">{{ $step['label'] }}</h6>
                                        <small class="step-description text-muted">{{ $step['description'] }}</small>
                                    </div>
                                </div>
                                
                                @if(!$loop->last)
                                    <div class="timeline-connector {{ $isCompleted ? 'completed' : '' }}"></div>
                                @endif
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Historial de Pagos -->
            @if($pedido->pagos->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="ri-secure-payment-line me-2"></i>Historial de Pagos
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Fecha</th>
                                    <th>Método</th>
                                    <th>Referencia</th>
                                    <th>Monto</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($pedido->pagos as $pago)
                                <tr>
                                    <td>{{ $pago->created_at->format('d/m/Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-label-secondary">
                                            <i class="{{ $this->getPaymentMethodIcon($pago->metodo_pago) }} me-1"></i>
                                            {{ ucfirst($pago->metodo_pago) }}
                                        </span>
                                    </td>
                                    <td>{{ $pago->referencia ?? 'N/A' }}</td>
                                    <td>
                                        @if($pago->moneda === 'USD')
                                            ${{ format_money($pago->total_usd, 2) }}
                                        @else
                                            @php
                                                // Obtener la tasa de cambio del día del pago
                                                $tasaDelDia = \App\Models\ExchangeRate::whereDate('date', $pago->created_at->toDateString())
                                                    ->orderBy('fetch_time', 'desc')
                                                    ->value('usd_rate') ?? 1;
                                                $montoUsdEquivalente = $pago->total_usd * $tasaDelDia;
                                            @endphp
                                            <div>{{ format_money($pago->total_usd, 2) }}</div>
                                            <small class="text-muted">≈ Bs{{ number_format($montoUsdEquivalente, 2) }} (tasa: {{ number_format($tasaDelDia, 4) }})</small>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $estadoClass = match($pago->estado) {
                                                'completado' => 'bg-success',
                                                'pendiente' => 'bg-warning',
                                                'rechazado' => 'bg-danger',
                                                default => 'bg-secondary'
                                            };
                                        @endphp
                                        <span class="badge {{ $estadoClass }}">{{ ucfirst($pago->estado) }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <th colspan="3">Total Pagado</th>
                                    <th>
                                        @php
                                            $totalUsd = $pedido->pagos->where('moneda', 'USD')->where('estado', 'completado')->sum('total_usd');
                                            $totalBs = $pedido->pagos->where('moneda', 'BS')->where('estado', 'completado')->sum('total_usd');
                                        @endphp
                                        @if($totalUsd > 0)
                                            <div class="text-success">{{ format_money($totalUsd, 2) }}</div>
                                        @endif
                                        @if($totalBs > 0)
                                            @php
                                                // Obtener la tasa de cambio del día del pedido
                                                $tasaDelDia = \App\Models\ExchangeRate::whereDate('date', $pedido->created_at->toDateString())
                                                    ->orderBy('fetch_time', 'desc')
                                                    ->value('usd_rate') ?? 1;
                                                $totalUsdEquivalente = $totalBs * $tasaDelDia;
                                            @endphp
                                            <div class="text-info">{{ format_money($totalBs, 2) }}</div>
                                            <small class="text-muted">≈ ${{ format_money($totalUsdEquivalente, 2) }} (tasa: {{ number_format($tasaDelDia, 4) }})</small>
                                        @endif
                                    </th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            @endif

            <!-- Productos del Pedido -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Productos ({{ $pedido->detalles->count() }} items)</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Producto</th>
                                    <th>Cantidad</th>
                                    <th>Precio Unit.</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($pedido->detalles as $detalle)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($detalle->producto && $detalle->producto->imagen)
                                                <img src="{{ $detalle->producto->imagen }}" alt="{{ $detalle->producto->name }}"
                                                     class="rounded me-3" width="50" height="50">
                                            @endif
                                            <div>
                                                <h6 class="mb-0">{{ $detalle->producto->name ?? 'Producto no encontrado' }}</h6>
                                                @if($detalle->producto && $detalle->producto->code)
                                                    <small class="text-muted">Código: {{ $detalle->producto->code }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $detalle->quantity }}</td>
                                    <td>{{ format_money($detalle->price, 2) }}</td>
                                    <td><strong>{{ format_money($detalle->quantity * $detalle->price, 2) }}</strong></td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center py-4">
                                        <i class="ri-inbox-line text-muted mb-2 fs-3"></i>
                                        <p class="text-muted mb-0">No hay productos en este pedido</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <th colspan="3">Total</th>
                                    <th><strong class="text-success">{{ format_money($pedido->total_usd, 2) }}</strong></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Historial de Estado -->
            @if($pedido->historial->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Historial de Cambios</h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        @foreach($pedido->historial->sortByDesc('created_at') as $historial)
                        <div class="timeline-item timeline-item-transparent">
                            <span class="timeline-point timeline-point-{{ $loop->first ? 'primary' : 'secondary' }}"></span>
                            <div class="timeline-event">
                                <div class="timeline-header mb-1">
                                    <h6 class="mb-0">{{ ucfirst($historial->accion) }}</h6>
                                    <small class="text-muted">{{ $historial->created_at->format('d/m/Y H:i') }}</small>
                                </div>
                                <p class="text-muted mb-2">
                                    Estado: <span class="badge bg-label-{{ $historial->estado_anterior === 'pendiente' ? 'warning' : ($historial->estado_anterior === 'pagado' ? 'success' : ($historial->estado_anterior === 'asignado' ? 'info' : ($historial->estado_anterior === 'entregado' ? 'primary' : 'secondary'))) }}">{{ ucfirst($historial->estado_anterior) }}</span>
                                    → 
                                    <span class="badge bg-{{ $historial->estado_nuevo === 'pendiente' ? 'warning' : ($historial->estado_nuevo === 'pagado' ? 'success' : ($historial->estado_nuevo === 'asignado' ? 'info' : ($historial->estado_nuevo === 'entregado' ? 'primary' : 'danger'))) }}">{{ ucfirst($historial->estado_nuevo) }}</span>
                                </p>
                                @if($historial->notas)
                                <p class="mb-0 text-muted">
                                    <small>{{ $historial->notas }}</small>
                                </p>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Información del Cliente -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Cliente</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar avatar-lg me-3">
                            <span class="avatar-initial rounded-circle bg-label-primary">
                                {{ substr($pedido->user->name, 0, 2) }}
                            </span>
                        </div>
                        <div>
                            <h6 class="mb-0">{{ $pedido->user->name }}</h6>
                            <small class="text-muted">{{ $pedido->user->email }}</small>
                        </div>
                    </div>

                    @if($pedido->user->telefono)
                    <div class="mb-2">
                        <i class="ri-phone-line me-2"></i>
                        <a href="tel:{{ $pedido->user->telefono }}">{{ $pedido->user->telefono }}</a>
                    </div>
                    @endif

                    <div class="mb-2">
                        <i class="ri-mail-line me-2"></i>
                        <a href="mailto:{{ $pedido->user->email }}">{{ $pedido->user->email }}</a>
                    </div>

                    @if($pedido->user->direccion)
                    <div class="mb-2">
                        <i class="ri-map-pin-line me-2"></i>
                        <small class="text-muted">{{ $pedido->user->direccion }}</small>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Empleado Asignado -->
            @if($pedido->empleados->count() > 0)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Empleado Asignado</h5>
                </div>
                <div class="card-body">
                    @foreach($pedido->empleados as $empleado)
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar avatar-lg me-3">
                            <span class="avatar-initial rounded-circle bg-label-success">
                                {{ substr($empleado->nombres, 0, 1) }}{{ substr($empleado->apellidos, 0, 1) }}
                            </span>
                        </div>
                        <div>
                            <h6 class="mb-0">{{ $empleado->nombre_completo }}</h6>
                            <small class="text-muted">{{ $empleado->cargo }}</small>
                        </div>
                    </div>

                    @if($empleado->telefono)
                    <div class="mb-2">
                        <i class="ri-phone-line me-2"></i>
                        <a href="tel:{{ $empleado->telefono }}">{{ $empleado->telefono }}</a>
                    </div>
                    @endif

                    @if($empleado->email)
                    <div class="mb-2">
                        <i class="ri-mail-line me-2"></i>
                        <a href="mailto:{{ $empleado->email }}">{{ $empleado->email }}</a>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Referencias Bancarias -->
            @if($pedido->referenciaBancaria)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Referencias de Pago</h5>
                </div>
                <div class="card-body">
                    @php $referencia = $pedido->referenciaBancaria; @endphp
                    <div class="mb-3 p-3 border rounded">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <strong>{{ $referencia->banco }}</strong>
                            <span class="badge bg-label-info">{{ $referencia->tipo_pago }}</span>
                        </div>
                        <p class="mb-1"><strong>Referencia:</strong> {{ $referencia->referencia }}</p>
                        <p class="mb-1"><strong>Monto:</strong> {{ $referencia->moneda }} {{ number_format($referencia->monto, 2) }}</p>
                        <p class="mb-0"><small class="text-muted">{{ $referencia->created_at->format('d/m/Y H:i') }}</small></p>
                    </div>
                </div>
            </div>
            @endif

            <!-- Acciones Rápidas -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Acciones Rápidas</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button class="btn btn-outline-primary" onclick="window.open('https://wa.me/{{ str_replace(['+', ' ', '-'], '', $pedido->user->telefono) }}?text=Hola {{ $pedido->user->name }}, sobre tu pedido {{ $pedido->codigo }}...', '_blank')">
                            <i class="ri-whatsapp-line"></i> Contactar Cliente
                        </button>
                        
                        @if($pedido->empleados->count() > 0)
                            @foreach($pedido->empleados as $empleado)
                                @if($empleado->telefono)
                                <button class="btn btn-outline-info" onclick="window.open('https://wa.me/{{ str_replace(['+', ' ', '-'], '', $empleado->telefono) }}?text=Hola {{ $empleado->nombre_completo }}, sobre el pedido {{ $pedido->codigo }}...', '_blank')">
                                    <i class="ri-whatsapp-line"></i> Contactar {{ $empleado->nombres }}
                                </button>
                                @endif
                            @endforeach
                        @endif
                        
                        <button class="btn btn-outline-secondary" onclick="window.print()">
                            <i class="ri-printer-line"></i> Imprimir Pedido
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Asignar Empleado -->
    @if($showAsignarModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Asignar Empleado</h5>
                        <button type="button" class="btn-close" wire:click="$set('showAsignarModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Seleccionar Empleado</label>
                            <select class="form-select" wire:model="empleadoSeleccionado">
                                <option value="">Seleccionar empleado...</option>
                                @foreach($empleados as $empleado)
                                    <option value="{{ $empleado->id }}">{{ $empleado->nombre_completo }} - {{ $empleado->cargo }}</option>
                                @endforeach
                            </select>
                            @error('empleadoSeleccionado') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showAsignarModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-primary" wire:click="asignarEmpleado">Asignar</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Modal Cancelar Pedido -->
    @if($showCancelarModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Cancelar Pedido</h5>
                        <button type="button" class="btn-close" wire:click="$set('showCancelarModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Motivo de Cancelación</label>
                            <textarea class="form-control" rows="3" wire:model="motivoCancelacion"
                                placeholder="Describe el motivo de la cancelación..."></textarea>
                            @error('motivoCancelacion') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showCancelarModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-danger" wire:click="cancelarPedido">Confirmar Cancelación</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>

@push('styles')
<style>
.order-progress-timeline {
    display: flex;
    align-items: center;
    justify-content: space-between;
    position: relative;
    padding: 20px 0;
}

.timeline-step {
    display: flex;
    flex-direction: column;
    align-items: center;
    position: relative;
    z-index: 2;
}

.step-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: #e9ecef;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 10px;
    transition: all 0.3s ease;
    cursor: pointer;
}

.step-icon i {
    font-size: 20px;
    color: #6c757d;
    transition: all 0.3s ease;
}

.step-content {
    text-align: center;
    max-width: 120px;
}

.step-title {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 4px;
    color: #6c757d;
}

.step-description {
    font-size: 12px;
    line-height: 1.4;
}

.timeline-step.completed .step-icon {
    background: #28a745;
    box-shadow: 0 0 0 4px rgba(40, 167, 69, 0.2);
}

.timeline-step.completed .step-icon i {
    color: white;
}

.timeline-step.completed .step-title {
    color: #28a745;
}

.timeline-step.active .step-icon {
    background: #007bff;
    box-shadow: 0 0 0 4px rgba(0, 123, 255, 0.2);
    transform: scale(1.1);
}

.timeline-step.active .step-icon i {
    color: white;
}

.timeline-step.active .step-title {
    color: #007bff;
    font-weight: 700;
}

.timeline-step.cancelled .step-icon {
    background: #dc3545;
    box-shadow: 0 0 0 4px rgba(220, 53, 69, 0.2);
}

.timeline-step.cancelled .step-icon i {
    color: white;
}

.timeline-step.cancelled .step-title {
    color: #dc3545;
}

.timeline-connector {
    flex: 1;
    height: 3px;
    background: #e9ecef;
    margin: 0 10px;
    position: relative;
    top: -35px;
    z-index: 1;
}

.timeline-connector.completed {
    background: #28a745;
}

@media (max-width: 768px) {
    .order-progress-timeline {
        flex-direction: column;
        gap: 20px;
    }
    
    .timeline-connector {
        display: none;
    }
    
    .step-content {
        max-width: 200px;
    }
}
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize tooltips for timeline icons
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Add click animation to timeline steps
    const timelineSteps = document.querySelectorAll('.timeline-step');
    timelineSteps.forEach(step => {
        step.addEventListener('click', function() {
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = '';
            }, 150);
        });
    });
});
</script>
@endpush