<div>
    @section('title', 'Mis Pedidos')

    @if(!$empleado)
        <div class="alert alert-warning">
            <i class="ri-alert-line me-2"></i>
            No se encontró tu perfil de empleado. Contacta al administrador.
        </div>
    @else
        <!-- Estadísticas Rápidas -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="text-white mb-1">Mis Pedidos</h4>
                                <p class="mb-0 opacity-75">{{ $empleado->nombre_completo ?? 'Empleado' }} • Período: {{ \Carbon\Carbon::parse($fechaDesde)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($fechaHasta)->format('d/m/Y') }}</p>
                            </div>
                            <div class="col-md-4 text-end">
                                <a href="{{ route('admin.empleados.dashboard') }}" class="btn btn-outline-light">
                                    <i class="ri-arrow-left-line me-1"></i> Volver al Dashboard
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="row g-4 mb-4">
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-primary rounded">
                                <i class="ri-file-list-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-primary">{{ $stats['total'] ?? 0 }}</h4>
                        <small class="text-muted">Total Pedidos</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class="ri-time-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-warning">{{ $stats['pendientes'] ?? 0 }}</h4>
                        <small class="text-muted">Pendientes</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-info rounded">
                                <i class="ri-loader-4-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-info">{{ $stats['procesando'] ?? 0 }}</h4>
                        <small class="text-muted">Procesando</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-check-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-success">{{ $stats['entregados'] ?? 0 }}</h4>
                        <small class="text-muted">Entregados</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-8">
                <div class="card text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-money-dollar-circle-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-success">{{ format_money($stats['total_ingresos'] ?? 0) }}</h4>
                        <small class="text-muted">Ingresos Generados</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros y Tabla -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Lista de Pedidos</h5>
                        <div class="d-flex gap-2">
                            <button class="btn btn-outline-secondary btn-sm" wire:click="clearFilters">
                                <i class="ri-refresh-line me-1"></i> Limpiar Filtros
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Filtros Mejorados -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ri-search-line"></i></span>
                                    <input type="text" class="form-control" wire:model.live.debounce.300ms="search" placeholder="Buscar por código o cliente...">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" wire:model.live="estado">
                                    <option value="">Todos los estados</option>
                                    <option value="Pendiente">Pendiente</option>
                                    <option value="Procesando">Procesando</option>
                                    <option value="entregado">Entregado</option>
                                    <option value="cancelado">Cancelado</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" class="form-control" wire:model.live="fechaDesde" placeholder="Fecha desde">
                            </div>
                            <div class="col-md-2">
                                <input type="date" class="form-control" wire:model.live="fechaHasta" placeholder="Fecha hasta">
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" wire:model.live="perPage">
                                    <option value="10">10 por página</option>
                                    <option value="15">15 por página</option>
                                    <option value="25">25 por página</option>
                                    <option value="50">50 por página</option>
                                </select>
                            </div>
                        </div>

                        <!-- Tabla Mejorada -->
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th wire:click="sortBy('codigo')" style="cursor: pointer;">
                                            Código 
                                            @if($sortBy === 'codigo')
                                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                                            @endif
                                        </th>
                                        <th>Cliente</th>
                                        <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                            Fecha 
                                            @if($sortBy === 'created_at')
                                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                                            @endif
                                        </th>
                                        <th>Estado</th>
                                        <th wire:click="sortBy('total_usd')" style="cursor: pointer;">
                                            Total 
                                            @if($sortBy === 'total_usd')
                                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                                            @endif
                                        </th>
                                        <th class="text-center">Productos</th>
                                        <th class="text-center">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($pedidos as $pedido)
                                        <tr class="order-row" style="cursor: pointer;" onclick="window.open('{{ route('admin.empleados.pedido.detalle', $pedido->codigo) }}', '_blank')">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <div class="avatar-initial bg-label-{{ $pedido->estado == 'Pendiente' ? 'warning' : ($pedido->estado == 'entregado' ? 'success' : 'info') }} rounded">
                                                            @if($pedido->estado == 'Pendiente')
                                                                <i class="ri-time-line"></i>
                                                            @elseif($pedido->estado == 'Procesando')
                                                                <i class="ri-loader-4-line"></i>
                                                            @elseif($pedido->estado == 'entregado')
                                                                <i class="ri-check-line"></i>
                                                            @else
                                                                <i class="ri-file-list-line"></i>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <span class="fw-bold">#{{ $pedido->codigo }}</span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <span class="avatar-initial rounded-circle bg-label-primary">
                                                            {{ strtoupper(substr($pedido->user->name ?? 'C', 0, 1)) }}
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0">{{ $pedido->user->name ?? 'Cliente' }}</h6>
                                                        @if($pedido->user->telefono)
                                                            <small class="text-muted">{{ $pedido->user->telefono }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <span class="fw-medium">{{ $pedido->created_at->format('d/m/Y') }}</span>
                                                    <br>
                                                    <small class="text-muted">{{ $pedido->created_at->format('H:i') }} • {{ $pedido->created_at->diffForHumans() }}</small>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge bg-{{ $pedido->estado == 'Pendiente' ? 'warning' : ($pedido->estado == 'Procesando' ? 'info' : ($pedido->estado == 'entregado' ? 'success' : 'secondary')) }} rounded-pill">
                                                    {{ $pedido->estado }}
                                                </span>
                                            </td>
                                            <td>
                                                <div>
                                                    <span class="fw-bold text-primary">{{ format_money($pedido->total_usd) }}</span>
                                                    @if(is_venezuela_company())
                                                        <br>
                                                        <small class="text-muted">{{ format_money($pedido->total_bs) }} Bs</small>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-label-secondary rounded-pill">
                                                    {{ $pedido->detalles->count() }}
                                                </span>
                                            </td>
                                            <td class="text-center" onclick="event.stopPropagation();">
                                                <div class="d-flex gap-1 justify-content-center">
                                                    @if($pedido->estado == 'Pendiente')
                                                        <button class="btn btn-sm btn-success" wire:click="updateOrderStatus({{ $pedido->id }}, 'Procesando')" title="Procesar">
                                                            <i class="ri-play-line"></i>
                                                        </button>
                                                    @elseif($pedido->estado == 'Procesando')
                                                        <button class="btn btn-sm btn-primary" wire:click="updateOrderStatus({{ $pedido->id }}, 'entregado')" title="Entregar">
                                                            <i class="ri-check-line"></i>
                                                        </button>
                                                    @endif
                                                    
                                                    @if($pedido->user->telefono)
                                                        <a href="tel:{{ $pedido->user->telefono }}" class="btn btn-sm btn-outline-success" title="Llamar">
                                                            <i class="ri-phone-line"></i>
                                                        </a>
                                                    @endif
                                                    
                                                    @if($pedido->latitud && $pedido->longitud)
                                                        <a href="https://www.google.com/maps/dir//{{ $pedido->latitud }},{{ $pedido->longitud }}" target="_blank" class="btn btn-sm btn-outline-info" title="Navegar">
                                                            <i class="ri-navigation-line"></i>
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center py-5">
                                                <div class="avatar avatar-xl mx-auto mb-3">
                                                    <div class="avatar-initial bg-label-secondary rounded">
                                                        <i class="ri-search-line" style="font-size: 2rem;"></i>
                                                    </div>
                                                </div>
                                                <h6 class="text-muted mb-2">No se encontraron pedidos</h6>
                                                <p class="text-muted mb-3">Intenta ajustar los filtros de búsqueda o el rango de fechas</p>
                                                <button class="btn btn-outline-primary btn-sm" wire:click="clearFilters">
                                                    <i class="ri-refresh-line me-1"></i> Limpiar Filtros
                                                </button>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <!-- Paginación y Resumen -->
                        @if($pedidos->hasPages())
                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <div class="text-muted">
                                    Mostrando {{ $pedidos->firstItem() }} - {{ $pedidos->lastItem() }} de {{ $pedidos->total() }} pedidos
                                </div>
                                {{ $pedidos->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
.order-row:hover {
    background-color: #f8f9fa;
    transform: translateX(2px);
    transition: all 0.2s ease;
}
.table th[wire\:click] {
    user-select: none;
}
.table th[wire\:click]:hover {
    background-color: #e9ecef;
}
</style>
@endpush