<div>
    <div class="container-fluid">
        <!-- Mensajes de notificación -->
        @if(session()->has('message'))
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-{{ session('message_type') === 'error' ? 'danger' : 'success' }} alert-dismissible fade show" role="alert">
                        <i class="ri-{{ session('message_type') === 'error' ? 'error-warning-line' : 'check-circle-line' }} me-2"></i>
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        @endif

        <!-- Encabezado con título y breadcrumb -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Editar Pedido #{{ $pedido->codigo }}</h4>
                    <div class="page-title-right">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-style m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.dashboard') }}">
                                        <i class="ri-home-line"></i>
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.pedidos.index') }}">Pedidos</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Editar</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Información del Cliente (Solo lectura) -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="ri-user-line me-2"></i>
                            Información del Cliente
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <div class="d-flex align-items-center p-3 bg-light rounded">
                                    <div class="avatar avatar-lg me-3">
                                        <span class="avatar-initial rounded bg-label-primary">
                                            {{ substr($pedido->user->name, 0, 1) }}
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-bold">{{ $pedido->user->name }}</h6>
                                        <p class="text-muted mb-1">{{ $pedido->user->email }}</p>
                                        @if($pedido->user->telefono)
                                            <p class="text-muted mb-0">
                                                <i class="ri-phone-line me-1"></i>
                                                {{ $pedido->user->telefono }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Información del pedido -->
                        <div class="mt-4">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Código del Pedido</label>
                                    <div class="fw-bold">{{ $pedido->codigo }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Estado</label>
                                    <div>
                                        <span class="badge bg-label-{{ $pedido->estado === 'pendiente' ? 'warning' : ($pedido->estado === 'completado' ? 'success' : 'info') }}">
                                            {{ ucfirst($pedido->estado) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Fecha del Pedido</label>
                                    <div class="fw-bold">{{ $pedido->created_at->format('d/m/Y H:i') }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Método de Pago</label>
                                    <div class="fw-bold">{{ ucfirst($pedido->metodo_pago) }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detalles del Pedido (Editables) -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="ri-edit-line me-2"></i>
                            Detalles Editables
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label" for="fecha_entrega">
                                    Fecha de Entrega
                                </label>
                                <input wire:model="fecha_entrega" type="date" class="form-control @error('fecha_entrega') is-invalid @enderror" id="fecha_entrega">
                                @error('fecha_entrega')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label" for="notas">
                                    Notas del Pedido
                                </label>
                                <textarea wire:model="notas" class="form-control @error('notas') is-invalid @enderror" id="notas" rows="4" placeholder="Instrucciones especiales, preferencias, detalles adicionales..."></textarea>
                                @error('notas')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Resumen de pago -->
                        <div class="bg-light rounded-3 p-3 mt-4">
                            <h6 class="fw-semibold text-muted mb-3">
                                <i class="ri-money-dollar-circle-line me-1"></i>
                                Resumen Actualizado
                            </h6>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Subtotal:</span>
                                <span class="fw-medium">$ {{ number_format($this->total, 2) }}</span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">IVA (16%):</span>
                                <span class="fw-medium">$ {{ number_format($this->total * 0.16, 2) }}</span>
                            </div>
                            <hr class="my-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold text-primary">Total:</span>
                                <span class="fw-bold text-primary ">$ {{ number_format($this->total * 1.16, 2) }}</span>
                            </div>

                            @if($this->total != $pedido->total_usd)
                                <div class="mt-2 p-2 bg-warning bg-opacity-10 rounded">
                                    <small class="text-warning">
                                        <i class="ri-information-line me-1"></i>
                                        Total original: $ {{ number_format($pedido->total_usd, 2) }}
                                    </small>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección de Productos -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="ri-shopping-cart-line me-2"></i>
                            Productos del Pedido
                        </h5>
                        <div class="badge bg-label-primary">
                            {{ count($cart) }} productos
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Búsqueda de productos para agregar -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="card border-dashed border-primary">
                                    <div class="card-header bg-primary bg-opacity-10">
                                        <h6 class="mb-0 text-primary">
                                            <i class="ri-add-circle-line me-2"></i>
                                            Agregar Nuevos Productos
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-8">
                                                <label class="form-label" for="searchTerm">
                                                    Buscar Productos
                                                </label>
                                                <div class="position-relative">
                                                    <div class="input-group input-group-merge">
                                                        <span class="input-group-text">
                                                            <i class="ri-search-line"></i>
                                                        </span>
                                                        <input
                                                            wire:model.live.debounce.300ms="searchTerm"
                                                            type="text"
                                                            class="form-control"
                                                            id="searchTerm"
                                                            placeholder="Escriba el código, nombre o descripción del producto..."
                                                            autocomplete="off"
                                                        >
                                                        <span class="input-group-text">
                                                            <div wire:loading wire:target="searchTerm" class="spinner-border spinner-border-sm text-primary" role="status">
                                                                <span class="visually-hidden">Cargando...</span>
                                                            </div>
                                                            <div wire:loading.remove wire:target="searchTerm">
                                                                <i class="ri-search-line"></i>
                                                            </div>
                                                        </span>
                                                    </div>

                                                    <!-- Resultados de búsqueda -->
                                                    @if($showSearchResults && is_array($searchResults) && count($searchResults) > 0)
                                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                                            <div class="card shadow-lg">
                                                                <div class="card-header py-2">
                                                                    <small class="text-muted">
                                                                        <i class="ri-search-2-line me-1"></i>
                                                                        {{ count($searchResults) }} productos encontrados
                                                                    </small>
                                                                </div>
                                                                <div class="card-body p-0 max-h-300px overflow-y-auto">
                                                                    @foreach($searchResults as $producto)
                                                                        <div
                                                                            class="d-flex align-items-center p-3 border-bottom cursor-pointer"
                                                                            wire:click="selectProduct({{ $producto['id'] }})"
                                                                        >
                                                                            <div class="me-3">
                                                                                @if(isset($producto['image_path']) && $producto['image_path'])
                                                                                    <img src="/media/producto/{{ $producto['image_path'] }}"
                                                                                         alt="{{ $producto['name'] ?? 'Producto' }}"
                                                                                         class="rounded"
                                                                                         width="50"
                                                                                         height="50"
                                                                                         style="object-fit: cover;">
                                                                                @else
                                                                                    <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                                     style="width: 50px; height: 50px;">
                                                                                        <i class="ri-image-line text-muted"></i>
                                                                                    </div>
                                                                                @endif
                                                                            </div>
                                                                            <div class="flex-grow-1">
                                                                                <h6 class="mb-1 fw-semibold">{{ $producto['name'] ?? 'Producto sin nombre' }}</h6>
                                                                                <p class="text-muted mb-1 small">{{ $producto['code'] ?? '' }}</p>
                                                                                <div class="d-flex align-items-center">
                                                                                    @if(isset($producto['categoria_name']) && $producto['categoria_name'])
                                                                                        <span class="badge bg-label-primary me-2">
                                                                                            <i class="ri-price-tag-3-line me-1"></i>
                                                                                            {{ $producto['categoria_name'] }}
                                                                                        </span>
                                                                                    @endif
                                                                                    <span class="badge bg-label-{{ (isset($producto['quantity']) && $producto['quantity'] > 0) ? 'success' : 'danger' }}">
                                                                                        <i class="ri-stock-line me-1"></i>
                                                                                        Stock: {{ $producto['quantity'] ?? 0 }}
                                                                                    </span>
                                                                                </div>
                                                                            </div>
                                                                            <div class="text-end">
                                                                                <h5 class="text-primary mb-1">$ {{ isset($producto['price']) ? number_format($producto['price'], 2) : '0.00' }}</h5>
                                                                                <small class="text-muted">C/U</small>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @elseif($showSearchResults && strlen($searchTerm) >= 2)
                                                        <div class="position-absolute w-100 mt-1" style="z-index: 1050;">
                                                            <div class="card shadow-lg">
                                                                <div class="card-body text-center py-4">
                                                                    <i class="ri-search-line ri-3x text-muted mb-3"></i>
                                                                    <h6 class="text-muted">No se encontraron productos</h6>
                                                                    <p class="text-muted small mb-0">Intenta con otro término de búsqueda</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <label class="form-label" for="quantity">
                                                    Cantidad
                                                </label>
                                                <div class="d-flex justify-content-center">
                                                    <div class="btn-group" role="group" style="width: 140px;">
                                                        <button
                                                            class="btn btn-outline-primary"
                                                            type="button"
                                                            wire:click="$set('quantity', Math.max(1, quantity - 1))"
                                                            {{ $quantity <= 1 ? 'disabled' : '' }}
                                                            style="width: 35px;"
                                                        >
                                                            <i class="ri-subtract-line"></i>
                                                        </button>
                                                        <input
                                                            wire:model="quantity"
                                                            type="number"
                                                            min="1"
                                                            class="form-control text-center fw-bold border-primary"
                                                            id="quantity"
                                                            style="width: 70px; border-left: 0; border-right: 0;"
                                                        >
                                                        <button
                                                            class="btn btn-outline-primary"
                                                            type="button"
                                                            wire:click="$set('quantity', quantity + 1)"
                                                            style="width: 35px;"
                                                        >
                                                            <i class="ri-add-line"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Botón para agregar producto -->
                                        <div class="text-center mt-3">
                                            <button
                                                wire:click="addProductToCart"
                                                type="button"
                                                class="btn btn-primary"
                                                {{ !$selectedProduct ? 'disabled' : '' }}
                                            >
                                                <i class="ri-shopping-cart-2-line me-2"></i>
                                                Agregar Producto
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Lista de productos en el carrito -->
                        @if(count($cart) > 0)
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Producto</th>
                                            <th class="text-center">Cantidad</th>
                                            <th class="text-end">Precio Unit.</th>
                                            <th class="text-end">Subtotal</th>
                                            <th class="text-center">Estado</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($cart as $index => $item)
                                            <tr class="border-bottom {{ $item['is_existing'] ? '' : 'table-warning' }}">
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="me-3">
                                                            @php
                                                                $producto = \App\Models\Producto::find($item['producto_id']);
                                                            @endphp
                                                            @if($producto && $producto->featuredImage)
                                                                <img src="/media/producto/{{ $producto->featuredImage->path }}"
                                                                     alt="{{ $item['nombre'] }}"
                                                                     class="rounded"
                                                                     width="40"
                                                                     height="40"
                                                                     style="object-fit: cover;">
                                                            @else
                                                                <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                                     style="width: 40px; height: 40px;">
                                                                    <i class="ri-image-line text-muted"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 fw-semibold">{{ $item['nombre'] }}</h6>
                                                            @if($producto && $producto->categoria)
                                                                <small class="text-muted">{{ $producto->categoria->name }}</small>
                                                            @endif
                                                            <small class="text-muted d-block">{{ $item['codigo'] }}</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center">
                                                        <div class="btn-group" role="group" style="width: 140px;">
                                                            <button
                                                                class="btn btn-outline-primary btn-sm"
                                                                type="button"
                                                                wire:click="updateQuantity({{ $index }}, {{ $item['cantidad'] - 1 }})"
                                                                {{ $item['cantidad'] <= 1 ? 'disabled' : '' }}
                                                                style="width: 35px;"
                                                            >
                                                                <i class="ri-subtract-line"></i>
                                                            </button>
                                                            <input
                                                                type="number"
                                                                class="form-control form-control-sm text-center fw-bold border-primary"
                                                                value="{{ $item['cantidad'] }}"
                                                                wire:change="updateQuantity({{ $index }}, $event.target.value)"
                                                                min="1"
                                                                style="width: 70px; border-left: 0; border-right: 0;"
                                                            >
                                                            <button
                                                                class="btn btn-outline-primary btn-sm"
                                                                type="button"
                                                                wire:click="updateQuantity({{ $index }}, {{ $item['cantidad'] + 1 }})"
                                                                style="width: 35px;"
                                                            >
                                                                <i class="ri-add-line"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-end fw-medium">
                                                    $ {{ number_format($item['precio_unitario'], 2) }}
                                                </td>
                                                <td class="text-end fw-bold text-primary">
                                                    $ {{ number_format($item['subtotal'], 2) }}
                                                </td>
                                                <td class="text-center">
                                                    @if($item['is_existing'])
                                                        <span class="badge bg-label-info">
                                                            <i class="ri-check-line me-1"></i>
                                                            Original
                                                        </span>
                                                    @else
                                                        <span class="badge bg-label-warning">
                                                            <i class="ri-add-line me-1"></i>
                                                            Nuevo
                                                        </span>
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    <button
                                                        wire:click="removeFromCart({{ $index }})"
                                                        type="button"
                                                        class="btn btn-sm btn-outline-danger rounded-circle"
                                                        data-bs-toggle="tooltip"
                                                        data-bs-placement="top"
                                                        title="Eliminar producto"
                                                    >
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr class="table-active">
                                            <th colspan="3" class="text-end text-uppercase">Total del Pedido:</th>
                                            <th class="text-end">
                                                <span class=" fw-bold text-primary">
                                                    $ {{ number_format($this->total, 2) }}
                                                </span>
                                            </th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <div class="mb-4">
                                    <i class="ri-shopping-cart-line ri-3x text-muted"></i>
                                </div>
                                <h5 class="text-muted mb-2">No hay productos en el pedido</h5>
                                <p class="text-muted mb-4">Agrega productos usando la búsqueda de arriba</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Botones de acción -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <div class="bg-label-success rounded-circle p-3 me-3">
                                        <i class="ri-edit-2-line ri-24px"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">¿Listo para actualizar el pedido?</h6>
                                        <small class="text-muted">Los cambios se aplicarán inmediatamente</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex justify-content-end gap-3">
                                    <a href="{{ route('admin.pedidos.show', $pedido) }}" class="btn btn-outline-secondary">
                                        <i class="ri-arrow-left-line me-2"></i>
                                        Cancelar
                                    </a>
                                    <button
                                        wire:click="save"
                                        type="button"
                                        class="btn btn-success"
                                        {{ count($cart) == 0 ? 'disabled' : '' }}
                                    >
                                        <i class="ri-save-line me-2"></i>
                                        Actualizar Pedido
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript para mejorar la experiencia -->
    <script>
        // Cerrar resultados de búsqueda al hacer clic fuera
        document.addEventListener('click', function(e) {
            const searchContainer = document.querySelector('.position-relative');
            if (searchContainer && !searchContainer.contains(e.target)) {
                @this.call('hideSearchResults');
            }
        });

        // Mejorar la experiencia de búsqueda
        document.addEventListener('livewire:init', () => {
            Livewire.on('product-added', (event) => {
                if (typeof toastr !== 'undefined') {
                    toastr.success('Producto agregado al pedido');
                }
            });

            Livewire.on('product-removed', (event) => {
                if (typeof toastr !== 'undefined') {
                    toastr.info('Producto eliminado del pedido');
                }
            });

            Livewire.on('show-toast', (event) => {
                if (typeof toastr !== 'undefined') {
                    const data = event[0] || event;
                    switch(data.type) {
                        case 'success':
                            toastr.success(data.message);
                            break;
                        case 'error':
                            toastr.error(data.message);
                            break;
                        case 'info':
                            toastr.info(data.message);
                            break;
                        case 'warning':
                            toastr.warning(data.message);
                            break;
                    }
                }
            });
        });

        // Mejorar accesibilidad con teclado
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                @this.call('hideSearchResults');
            }
        });
    </script>

    <style>
        .cursor-pointer {
            cursor: pointer;
        }

        .cursor-pointer:hover {
            background-color: #f8f9fa;
        }

        .max-h-300px {
            max-height: 300px;
        }

        .overflow-y-auto {
            overflow-y: auto;
        }

        .table-warning {
            --bs-table-bg: #fff3cd;
        }

        .border-dashed {
            border-style: dashed !important;
        }

        .badge {
            font-size: 0.75em;
        }

        .card {
            transition: all 0.3s ease;
        }

        .btn {
            transition: all 0.2s ease;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .spinner-border-sm {
            width: 1rem;
            height: 1rem;
        }
    </style>
</div>
