@if ($paginator->hasPages())
  <nav class="d-flex justify-content-between align-items-center flex-wrap gap-3">
    <style>
      .pagination-modern .page-link {
        border-radius: 8px;
        margin: 0 2px;
        border: 1px solid #e9ecef;
        transition: all 0.2s ease;
        min-width: 36px;
        text-align: center;
      }

      .pagination-modern .page-link:hover {
        background-color: #f8f9fa;
        border-color: #0d6efd;
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(13, 110, 253, 0.15);
      }

      .pagination-modern .page-item.active .page-link {
        background: linear-gradient(135deg, #0d6efd, #0056b3);
        border-color: #0d6efd;
        box-shadow: 0 2px 6px rgba(13, 110, 253, 0.25);
      }

      .pagination-modern .page-item.disabled .page-link {
        opacity: 0.6;
        cursor: not-allowed;
        transform: none;
        box-shadow: none;
      }

      .pagination-info {
        font-size: 0.875rem;
        color: #6c757d;
        font-weight: 500;
      }

      @media (max-width: 576px) {
        .pagination-modern .page-link {
          min-width: 32px;
          padding: 0.375rem 0.5rem;
          font-size: 0.875rem;
        }

        .pagination-info {
          font-size: 0.8rem;
        }
      }
    </style>
    <div class="d-flex align-items-center gap-2">
      <span class="pagination-info">
        Mostrando {{ $paginator->firstItem() }} - {{ $paginator->lastItem() }} de {{ $paginator->total() }} resultados
      </span>
    </div>

    <div>
      <ul class="pagination pagination-modern mb-0">
        {{-- First Page Link --}}
        @if ($paginator->onFirstPage())
          <li class="page-item disabled">
            <span class="page-link" aria-label="Primera página" title="Primera página">
              <i class="ri-skip-back-line"></i>
            </span>
          </li>
        @else
          <li class="page-item">
            <a class="page-link" href="{{ $paginator->url(1) }}" rel="first" aria-label="Primera página" title="Primera página">
              <i class="ri-skip-back-line"></i>
            </a>
          </li>
        @endif

        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
          <li class="page-item disabled">
            <span class="page-link" aria-label="Página anterior" title="Página anterior">
              <i class="ri-arrow-left-s-line"></i>
            </span>
          </li>
        @else
          <li class="page-item">
            <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="Página anterior" title="Página anterior">
              <i class="ri-arrow-left-s-line"></i>
            </a>
          </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
          {{-- "Three Dots" Separator --}}
          @if (is_string($element))
            <li class="page-item disabled">
              <span class="page-link px-2">{{ $element }}</span>
            </li>
          @endif

          {{-- Array Of Links --}}
          @if (is_array($element))
            @foreach ($element as $page => $url)
              @if ($page == $paginator->currentPage())
                <li class="page-item active">
                  <span class="page-link px-3" aria-current="page" aria-label="Página {{ $page }}">
                    <strong>{{ $page }}</strong>
                  </span>
                </li>
              @else
                <li class="page-item">
                  <a class="page-link px-3" href="{{ $url }}" aria-label="Ir a página {{ $page }}" title="Ir a página {{ $page }}">{{ $page }}</a>
                </li>
              @endif
            @endforeach
          @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
          <li class="page-item">
            <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="Página siguiente" title="Página siguiente">
              <i class="ri-arrow-right-s-line"></i>
            </a>
          </li>
        @else
          <li class="page-item disabled">
            <span class="page-link" aria-label="Página siguiente" title="Página siguiente">
              <i class="ri-arrow-right-s-line"></i>
            </span>
          </li>
        @endif

        {{-- Last Page Link --}}
        @if ($paginator->hasMorePages())
          <li class="page-item">
            <a class="page-link" href="{{ $paginator->url($paginator->lastPage()) }}" rel="last" aria-label="Última página" title="Última página">
              <i class="ri-skip-forward-line"></i>
            </a>
          </li>
        @else
          <li class="page-item disabled">
            <span class="page-link" aria-label="Última página" title="Última página">
              <i class="ri-skip-forward-line"></i>
            </span>
          </li>
        @endif
      </ul>
    </div>
  </nav>
@endif
