<div>
    @if($notaVenta->venta_id)
        <div class="alert alert-success">
            <i class="ri-check-circle-line me-2"></i>
            Esta nota de venta ya ha sido convertida a venta.
            <a href="{{ route('admin.ventas.show', $notaVenta->venta_id) }}" class="alert-link">Ver venta</a>
        </div>
    @else
        @if($notaVenta->estado !== 'aprobada')
            <div class="alert alert-warning">
                <i class="ri-alert-line me-2"></i>
                Solo se pueden convertir notas de venta aprobadas a ventas.
            </div>
        @else
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">
                        <i class="ri-exchange-line me-2"></i>Convertir Nota de Venta a Venta
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Información de la nota de venta -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">Nota de Venta</label>
                                <div class="fw-semibold">{{ $notaVenta->numeroCompleto }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">Cliente</label>
                                <div>{{ $notaVenta->cliente->nombre_completo ?? 'Cliente general' }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">Fecha de Emisión</label>
                                <div>{{ $notaVenta->fecha_emision->format('d/m/Y') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">Total</label>
                                <div class="fw-bold text-success">{{ format_money($notaVenta->total) }}</div>
                            </div>
                        </div>
                    </div>

                    @if(!$confirmingConversion)
                        <button wire:click="confirmarConversion" class="btn btn-primary">
                            <i class="ri-exchange-line me-2"></i>Iniciar Conversión
                        </button>
                    @else
                        <!-- Formulario de conversión -->
                        <form wire:submit.prevent="convertirAVenta">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Caja</label>
                                        <select wire:model="caja_id" class="form-select" required>
                                            <option value="">Seleccionar caja</option>
                                            @foreach($cajas as $caja)
                                                <option value="{{ $caja->id }}">
                                                    {{ $caja->nombre }} - {{ $caja->estado }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('caja_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Serie de Venta</label>
                                        <select wire:model="serie_id" class="form-select" required>
                                            <option value="">Seleccionar serie</option>
                                            @foreach($series as $serie)
                                                <option value="{{ $serie->id }}">
                                                    {{ $serie->serie }} - {{ $serie->descripcion }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('serie_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Método de Pago</label>
                                        <select wire:model="metodo_pago" class="form-select" required>
                                            <option value="efectivo">Efectivo</option>
                                            <option value="transferencia">Transferencia</option>
                                            <option value="tarjeta">Tarjeta</option>
                                            <option value="pago_movil">Pago Móvil</option>
                                            <option value="punto_de_venta">Punto de Venta</option>
                                        </select>
                                        @error('metodo_pago') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-success">
                                    <i class="ri-check-line me-2"></i>Confirmar Conversión
                                </button>
                                <button type="button" wire:click="$set('confirmingConversion', false)" class="btn btn-secondary">
                                    Cancelar
                                </button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        @endif
    @endif
</div>