<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Nota de Crédito {{ $notaCredito->numero_completo }}</h1>
            <p class="mb-0 text-muted">Detalle completo de la nota de crédito</p>
        </div>
        <div>
            <a href="{{ route('admin.notas-credito.index') }}" class="btn btn-outline-secondary">
                <i class="ri-arrow-left-line me-1"></i>Volver al Listado
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Información Principal -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Información de la Nota</h5>
                        @switch($notaCredito->estado)
                            @case('procesada')
                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-3 py-2">
                                    <i class="ri-check-line me-1"></i>Procesada
                                </span>
                                @break
                            @case('pendiente')
                                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-3 py-2">
                                    <i class="ri-time-line me-1"></i>Pendiente
                                </span>
                                @break
                            @case('anulada')
                                <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-3 py-2">
                                    <i class="ri-close-line me-1"></i>Anulada
                                </span>
                                @break
                        @endswitch
                    </div>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-file-text-line text-primary"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Número de Nota</h6>
                                    <p class="mb-0 text-muted">{{ $notaCredito->numero_completo }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-info bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-calendar-line text-info"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Fecha de Emisión</h6>
                                    <p class="mb-0 text-muted">{{ $notaCredito->fecha_emision->format('d/m/Y') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-warning bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-bookmark-line text-warning"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Tipo de Nota</h6>
                                    <p class="mb-0 text-muted">{{ $tiposNotaCredito[$notaCredito->tipo_nota_credito] ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-success bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-user-line text-success"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Creado por</h6>
                                    <p class="mb-0 text-muted">{{ $notaCredito->user->name ?? 'Sistema' }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex align-items-start">
                                <div class="bg-secondary bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-message-2-line text-secondary"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">Motivo</h6>
                                    <p class="mb-0 text-muted">{{ $notaCredito->motivo }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detalles de la Nota -->
            @if($notaCredito->detalles->count() > 0)
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Detalles de la Nota de Crédito</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="border-0 ps-4">#</th>
                                        <th class="border-0">Descripción</th>
                                        <th class="border-0 text-center">Cantidad</th>
                                        <th class="border-0 text-end">Precio Unit.</th>
                                        <th class="border-0 text-end pe-4">Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($notaCredito->detalles as $index => $detalle)
                                        <tr>
                                            <td class="ps-4">{{ $index + 1 }}</td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="bg-primary bg-opacity-10 rounded-2 p-1 me-2">
                                                        <i class="ri-product-hunt-line text-primary small"></i>
                                                    </div>
                                                    <span>{{ $detalle->descripcion }}</span>
                                                </div>
                                            </td>
                                            <td class="text-center">{{ number_format($detalle->cantidad, 2) }}</td>
                                            <td class="text-end">{{ format_money($detalle->precio_unitario) }}</td>
                                            <td class="text-end pe-4">{{ format_money($detalle->subtotal) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Panel Lateral -->
        <div class="col-lg-4">
            <!-- Cliente -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Cliente</h5>
                </div>
                <div class="card-body">
                    @if($notaCredito->cliente)
                        <div class="d-flex align-items-center">
                            <div class="bg-info bg-opacity-10 rounded-circle p-3 me-3">
                                <i class="ri-user-line text-info fs-5"></i>
                            </div>
                            <div>
                                <h6 class="mb-1">{{ $notaCredito->cliente->nombre_completo }}</h6>
                                <p class="mb-0 text-muted small">{{ $notaCredito->cliente->email ?? 'Sin email' }}</p>
                                <p class="mb-0 text-muted small">{{ $notaCredito->cliente->telefono ?? 'Sin teléfono' }}</p>
                            </div>
                        </div>
                    @else
                        <div class="text-center text-muted py-3">
                            <i class="ri-user-line fs-2 mb-2"></i>
                            <p class="mb-0">Cliente General</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Venta Origen -->
            @if($notaCredito->venta)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Venta Origen</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="bg-success bg-opacity-10 rounded-circle p-3 me-3">
                                <i class="ri-receipt-line text-success fs-5"></i>
                            </div>
                            <div>
                                <h6 class="mb-1">{{ $notaCredito->venta->codigo }}</h6>
                                <p class="mb-0 text-muted small">{{ $notaCredito->venta->created_at->format('d/m/Y H:i') }}</p>
                                <p class="mb-0 text-muted small">Total: {{ format_money($notaCredito->venta->total) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Totales -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Resumen</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Subtotal:</span>
                        <span class="fw-medium">{{ format_money($notaCredito->subtotal) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Impuestos:</span>
                        <span class="fw-medium">{{ format_money($notaCredito->impuestos) }}</span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span class="fw-bold">Total Crédito:</span>
                        <span class="fw-bold text-danger fs-5">{{ format_money($notaCredito->total) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>