<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Nueva Nota de Crédito</h5>
                    @if($venta)
                        <p class="text-muted mb-0">Anulando venta: {{ $venta->codigo }}</p>
                    @endif
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="save">
                        <div class="row">
                            <div class="col-md-3">
                                <label class="form-label">Serie</label>
                                <input type="text" wire:model="serie" class="form-control" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Número</label>
                                <input type="text" wire:model="numero" class="form-control" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Fecha Emisión</label>
                                <input type="date" wire:model="fecha_emision" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Cliente</label>
                                <select wire:model="cliente_id" class="form-select {{ $errors->has('cliente_id') ? 'is-invalid' : '' }}" {{ $venta ? 'disabled' : '' }}>
                                    <option value="">Cliente general</option>
                                    @foreach($clientes as $cliente)
                                        <option value="{{ $cliente->id }}">{{ $cliente->nombre_completo }}</option>
                                    @endforeach
                                </select>
                                @error('cliente_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <label class="form-label">Tipo de Nota de Crédito</label>
                                <select wire:model="tipo_nota_credito" class="form-select">
                                    @foreach($tiposNotaCredito as $key => $tipo)
                                        <option value="{{ $key }}">{{ $tipo }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Motivo</label>
                                <textarea wire:model="motivo" class="form-control {{ $errors->has('motivo') ? 'is-invalid' : '' }}" rows="3" required></textarea>
                                @error('motivo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        @if($venta && !empty($detalles))
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6>Detalles de la Venta a Anular</h6>
                                    <p class="text-muted">Venta ID: {{ $venta_id }} | Detalles encontrados: {{ count($detalles) }}</p>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Descripción</th>
                                                    <th class="text-center">Cantidad</th>
                                                    <th class="text-end">Precio Unit.</th>
                                                    <th class="text-end">Subtotal</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($detalles as $detalle)
                                                    <tr>
                                                        <td>{{ $detalle['descripcion'] }}</td>
                                                        <td class="text-center">{{ $detalle['cantidad'] }}</td>
                                                        <td class="text-end">{{ format_money($detalle['precio_unitario']) }}</td>
                                                        <td class="text-end">{{ format_money($detalle['subtotal']) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="3" class="text-end">Total:</th>
                                                    <th class="text-end">{{ format_money($total) }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @elseif($venta_id)
                            <div class="row mt-4">
                                <div class="col-12">
                                    <div class="alert alert-warning">
                                        <strong>Debug Info:</strong><br>
                                        Venta ID: {{ $venta_id }}<br>
                                        Venta encontrada: {{ $venta ? 'Sí' : 'No' }}<br>
                                        Detalles count: {{ count($detalles) }}<br>
                                        @if($venta)
                                            Venta total: {{ $venta->total }}<br>
                                            Detalles en venta: {{ $venta->detalles->count() }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="row mt-3">
                            <div class="col-12">
                                <a href="{{ route('admin.notas-credito.index') }}" class="btn btn-secondary">Cancelar</a>
                                <button type="button" wire:click="testSave" class="btn btn-warning me-2">Test</button>
                                <button type="button" wire:click="save" class="btn btn-primary" wire:loading.attr="disabled">
                                    <span wire:loading.remove>Crear Nota de Crédito</span>
                                    <span wire:loading>
                                        <span class="spinner-border spinner-border-sm me-2" role="status"></span>
                                        Creando...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:init', function () {
            Livewire.on('show-message', function (data) {
                if (data[0].type === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: data[0].message,
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = '{{ route("admin.notas-credito.index") }}';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data[0].message
                    });
                }
            });
        });
    </script>
</div>