<div>
    <div>
    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h4 class="fw-bold py-3 mb-2">
                        <i class="ri-upload-cloud-2-line me-2 text-success"></i>
                        Importar Base de Datos
                    </h4>
                    <p class="text-muted mb-0">Importa archivos SQL con filtros de fecha personalizados</p>
                </div>
                <div class="badge bg-label-success fs-6">
                    <i class="ri-shield-check-line me-1"></i>
                    Importación Segura
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Panel de Configuración -->
        <div class="col-xl-4 col-lg-5 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center">
                    <div class="card-title mb-0">
                        <h5 class="m-0 me-2">
                            <i class="ri-file-upload-line me-2 text-success"></i>
                            Configuración
                        </h5>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Subir Archivo -->
                    <div class="mb-4">
                        <label class="form-label fw-medium">
                            <i class="ri-file-text-line me-1"></i>
                            Archivo SQL
                        </label>
                        <input type="file"
                               class="form-control"
                               wire:model="sqlFile"
                               accept=".sql"
                               wire:loading.attr="disabled">
                        <div class="form-text">
                            <i class="ri-information-line me-1"></i>
                            Máximo 50MB, solo archivos .sql
                        </div>
                        @if($sqlFile)
                        <div class="mt-2 p-2 bg-success bg-opacity-10 rounded">
                            <small class="text-success">
                                <i class="ri-check-line me-1"></i>
                                {{ $sqlFile->getClientOriginalName() }}
                            </small>
                        </div>
                        @endif
                    </div>

                    <!-- Configuraciones -->
                    @if(!empty($availableTables))
                    <div class="mb-4">
                        <!-- Filtro de Datos -->
                        <div class="card border border-success mb-3">
                            <div class="card-body p-3">
                                <div class="form-check form-switch mb-3">
                                    <input class="form-check-input" type="checkbox" wire:model.live="useDataFilter" id="useDataFilter">
                                    <label class="form-check-label fw-medium" for="useDataFilter">
                                        <i class="ri-filter-3-line me-1"></i>
                                        Filtrar por fecha
                                    </label>
                                </div>
                                @if($useDataFilter)
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label text-muted small">Desde</label>
                                        <input type="date" class="form-control form-control-sm" wire:model="filterFromDate">
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label text-muted small">Hasta</label>
                                        <input type="date" class="form-control form-control-sm" wire:model="filterToDate">
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>

                        <!-- Manejo de Conflictos ID -->
                        <div class="card border border-warning">
                            <div class="card-body p-3">
                                <div class="form-check form-switch mb-3">
                                    <input class="form-check-input" type="checkbox" wire:model.live="handleIdConflicts" id="handleIdConflicts">
                                    <label class="form-check-label fw-medium" for="handleIdConflicts">
                                        <i class="ri-shield-check-line me-1"></i>
                                        Manejar conflictos de ID
                                    </label>
                                </div>
                                @if($handleIdConflicts)
                                <div class="mt-2">
                                    <label class="form-label text-muted small">Resolución de conflictos:</label>
                                    <select class="form-select form-select-sm" wire:model="conflictResolution">
                                        <option value="update">Actualizar existentes (Recomendado)</option>
                                        <option value="auto_increment">Auto-incrementar</option>
                                        <option value="skip">Omitir registros duplicados</option>
                                        <option value="replace">Reemplazar existentes</option>
                                    </select>
                                    <div class="form-text small">
                                        @if($conflictResolution === 'update')
                                            <i class="ri-refresh-line me-1 text-primary"></i>
                                            Se actualizarán los registros existentes con nuevos datos
                                        @elseif($conflictResolution === 'auto_increment')
                                            <i class="ri-information-line me-1 text-success"></i>
                                            Los productos nuevos obtendrán IDs automáticos
                                        @elseif($conflictResolution === 'skip')
                                            <i class="ri-skip-forward-line me-1 text-warning"></i>
                                            Se omitirán productos con IDs existentes
                                        @else
                                            <i class="ri-alert-line me-1 text-danger"></i>
                                            Se reemplazarán los productos existentes
                                        @endif
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Estadísticas -->
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                            <div class="text-center">
                                <div class="fw-bold text-success h4 mb-0">{{ count($selectedTables) }}</div>
                                <small class="text-muted">Seleccionadas</small>
                            </div>
                            <div class="text-center">
                                <div class="fw-bold text-info h4 mb-0">{{ count($availableTables) }}</div>
                                <small class="text-muted">Disponibles</small>
                            </div>
                        </div>
                    </div>

                    <!-- Acciones de Selección -->
                    <div class="mb-4">
                        <div class="btn-group w-100" role="group">
                            <button type="button" class="btn btn-outline-success" wire:click="selectAllTables">
                                <i class="ri-checkbox-multiple-line me-1"></i>
                                Todas
                            </button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="deselectAllTables">
                                <i class="ri-checkbox-blank-line me-1"></i>
                                Ninguna
                            </button>
                        </div>
                    </div>

                    <!-- Botones Principales -->
                    <div class="d-grid gap-2">
                        <button type="button"
                                class="btn btn-warning"
                                wire:click="previewImport"
                                wire:loading.attr="disabled"
                                {{ empty($selectedTables) || !$sqlFile ? 'disabled' : '' }}>
                            <span wire:loading.remove wire:target="previewImport">
                                <i class="ri-eye-line me-2"></i>
                                Previsualizar Cambios
                            </span>
                            <span wire:loading wire:target="previewImport">
                                <span class="spinner-border spinner-border-sm me-2"></span>
                                Analizando...
                            </span>
                        </button>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Panel de Tablas -->
        <div class="col-xl-8 col-lg-7 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="m-0 me-2">
                            <i class="ri-table-line me-2 text-warning"></i>
                            Tablas Disponibles
                        </h5>
                    </div>
                    @if(!empty($availableTables))
                    <div class="badge bg-label-warning">
                        {{ count($selectedTables) }}/{{ count($availableTables) }} seleccionadas
                    </div>
                    @endif
                </div>
                <div class="card-body">
                    @if(empty($availableTables))
                    <div class="text-center py-5">
                        <i class="ri-file-upload-line display-4 text-muted mb-3"></i>
                        <h6 class="text-muted">Sube un archivo SQL para ver las tablas disponibles</h6>
                        <p class="text-muted small mb-0">El archivo será analizado automáticamente</p>
                    </div>
                    @else
                    <div class="table-responsive" style="max-height: 500px;">
                        <table class="table table-hover">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th width="50"></th>
                                    <th>Tabla</th>
                                    <th class="text-end">Inserts</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($availableTables as $table)
                                <tr class="cursor-pointer" wire:click="toggleTable('{{ $table['name'] }}')">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="table_{{ $table['name'] }}"
                                                   {{ in_array($table['name'], $selectedTables) ? 'checked' : '' }}>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-database-line me-2 text-muted"></i>
                                            <span class="fw-medium">{{ $table['name'] }}</span>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <span class="badge bg-label-warning">{{ number_format($table['insert_count']) }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Panel de Información -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-success mb-3">
                                <i class="ri-information-line me-2"></i>
                                Información de Importación
                            </h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">
                                    <i class="ri-file-text-line me-2 text-muted"></i>
                                    <strong>Formato:</strong> Archivos .sql estándar
                                </li>
                                <li class="mb-2">
                                    <i class="ri-shield-check-line me-2 text-muted"></i>
                                    <strong>Seguridad:</strong> Análisis previo del archivo
                                </li>
                                <li class="mb-2">
                                    <i class="ri-database-2-line me-2 text-muted"></i>
                                    <strong>Compatibilidad:</strong> MySQL/MariaDB
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-warning mb-3">
                                <i class="ri-alert-line me-2"></i>
                                Precauciones
                            </h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">
                                    <i class="ri-time-line me-2 text-muted"></i>
                                    Filtro por fechas en registros
                                </li>
                                <li class="mb-2">
                                    <i class="ri-checkbox-circle-line me-2 text-muted"></i>
                                    Solo tablas seleccionadas
                                </li>
                                <li class="mb-2">
                                    <i class="ri-backup-restore-line me-2 text-muted"></i>
                                    Crear respaldo antes de importar
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Previsualización -->
    @if($showPreview)
    <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="ri-eye-line me-2 text-primary"></i>
                        Previsualización de Importación
                    </h5>
                    <button type="button" class="btn-close" wire:click="cancelPreview"></button>
                </div>
                <div class="modal-body">
                    <!-- Resumen de Estadísticas -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <div class="avatar avatar-md mx-auto mb-3">
                                        <span class="avatar-initial rounded bg-label-success">
                                            <i class="ri-add-circle-line ri-24px"></i>
                                        </span>
                                    </div>
                                    <h4 class="mb-1">{{ collect($conflictData)->where('status', 'new')->count() }}</h4>
                                    <p class="mb-0">Tablas Nuevas</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <div class="avatar avatar-md mx-auto mb-3">
                                        <span class="avatar-initial rounded bg-label-info">
                                            <i class="ri-shield-check-line ri-24px"></i>
                                        </span>
                                    </div>
                                    <h4 class="mb-1">{{ collect($conflictData)->where('status', 'id_conflict')->count() }}</h4>
                                    <p class="mb-0">Conflictos ID</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <div class="avatar avatar-md mx-auto mb-3">
                                        <span class="avatar-initial rounded bg-label-warning">
                                            <i class="ri-refresh-line ri-24px"></i>
                                        </span>
                                    </div>
                                    <h4 class="mb-1">{{ collect($conflictData)->where('status', 'replace')->count() }}</h4>
                                    <p class="mb-0">Se Reemplazarán</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <div class="avatar avatar-md mx-auto mb-3">
                                        <span class="avatar-initial rounded bg-label-primary">
                                            <i class="ri-database-line ri-24px"></i>
                                        </span>
                                    </div>
                                    <h4 class="mb-1">{{ number_format(collect($conflictData)->sum('import_count')) }}</h4>
                                    <p class="mb-0">Total Registros</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Lista de Tablas -->
                    <div class="card">
                        <h5 class="card-header">
                            <i class="ri-table-line me-2"></i>
                            Análisis por Tabla
                        </h5>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Tabla</th>
                                        <th>Estado</th>
                                        <th class="text-center">Actuales</th>
                                        <th class="text-center">Importar</th>
                                        <th>Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($conflictData as $tableName => $data)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if($data['status'] === 'new')
                                                    <div class="avatar avatar-xs me-2">
                                                        <span class="avatar-initial rounded-circle bg-success">
                                                            <i class="ri-add-line"></i>
                                                        </span>
                                                    </div>
                                                @elseif($data['status'] === 'id_conflict')
                                                    <div class="avatar avatar-xs me-2">
                                                        <span class="avatar-initial rounded-circle bg-info">
                                                            <i class="ri-shield-check-line"></i>
                                                        </span>
                                                    </div>
                                                @else
                                                    <div class="avatar avatar-xs me-2">
                                                        <span class="avatar-initial rounded-circle bg-warning">
                                                            <i class="ri-refresh-line"></i>
                                                        </span>
                                                    </div>
                                                @endif
                                                <span class="fw-medium">{{ $tableName }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            @if($data['status'] === 'new')
                                                <span class="badge bg-success">Nueva</span>
                                            @elseif($data['status'] === 'id_conflict')
                                                <span class="badge bg-info">{{ count($data['id_conflicts']) }} Conflictos</span>
                                            @else
                                                <span class="badge bg-warning">Reemplazar</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-label-secondary">{{ number_format($data['current_count']) }}</span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-label-primary">{{ number_format($data['import_count']) }}</span>
                                        </td>
                                        <td>
                                            @if($data['status'] === 'replace' && !empty($data['current_sample']))
                                                <button class="btn btn-sm btn-outline-primary" 
                                                        type="button" 
                                                        data-bs-toggle="collapse" 
                                                        data-bs-target="#preview-{{ $loop->index }}">
                                                    <i class="ri-eye-line me-1"></i>
                                                    Ver Datos
                                                </button>
                                            @else
                                                <span class="text-muted small">Sin conflictos</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @if($data['status'] === 'replace' && !empty($data['current_sample']))
                                    <tr class="collapse" id="preview-{{ $loop->index }}">
                                        <td colspan="5">
                                            <div class="row g-3 p-3">
                                                <div class="col-md-6">
                                                    <div class="card border-danger">
                                                        <div class="card-header bg-danger text-white">
                                                            <h6 class="mb-0">
                                                                <i class="ri-delete-bin-line me-1"></i>
                                                                Datos Actuales (se perderán)
                                                            </h6>
                                                        </div>
                                                        <div class="card-body p-2">
                                                            @if(!empty($data['current_sample']))
                                                            <div class="table-responsive">
                                                                <table class="table table-sm mb-0">
                                                                    @foreach(array_slice($data['current_sample'], 0, 2) as $row)
                                                                    <tr>
                                                                        @foreach(array_slice((array)$row, 0, 3) as $value)
                                                                        <td class="small">{{ Str::limit($value, 15) }}</td>
                                                                        @endforeach
                                                                    </tr>
                                                                    @endforeach
                                                                </table>
                                                            </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="card border-success">
                                                        <div class="card-header bg-success text-white">
                                                            <h6 class="mb-0">
                                                                <i class="ri-add-line me-1"></i>
                                                                Datos Nuevos
                                                            </h6>
                                                        </div>
                                                        <div class="card-body p-2">
                                                            @if(!empty($data['import_sample']))
                                                            <div class="table-responsive">
                                                                <table class="table table-sm mb-0">
                                                                    @foreach(array_slice($data['import_sample'], 0, 2) as $row)
                                                                    <tr>
                                                                        @foreach(array_slice($row, 0, 3) as $value)
                                                                        <td class="small">{{ Str::limit($value, 15) }}</td>
                                                                        @endforeach
                                                                    </tr>
                                                                    @endforeach
                                                                </table>
                                                            </div>
                                                            @else
                                                            <p class="text-muted small mb-0">No disponible</p>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex justify-content-between align-items-center w-100">
                        <small class="text-muted">
                            <i class="ri-information-line me-1"></i>
                            Esta acción no se puede deshacer. Asegúrese de tener un respaldo.
                        </small>
                        <div>
                            <button type="button" class="btn btn-outline-secondary me-2" wire:click="cancelPreview">
                                <i class="ri-close-line me-1"></i>
                                Cancelar
                            </button>
                            <button type="button" 
                                    class="btn btn-success" 
                                    wire:click="confirmImport"
                                    wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="confirmImport">
                                    <i class="ri-check-line me-1"></i>
                                    Confirmar Importación
                                </span>
                                <span wire:loading wire:target="confirmImport">
                                    <span class="spinner-border spinner-border-sm me-2"></span>
                                    Importando...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

<style>
.cursor-pointer {
    cursor: pointer;
}
.cursor-pointer:hover {
    background-color: rgba(var(--bs-success-rgb), 0.05);
}

.hover-shadow-lg:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    transform: translateY(-2px);
}

.transition-all {
    transition: all 0.2s ease-in-out;
}

.avatar {
    width: 2.5rem;
    height: 2.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.avatar-sm {
    width: 2rem;
    height: 2rem;
}

.avatar {
    position: relative;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    vertical-align: middle;
    border-radius: 50%;
}

.avatar-xs {
    width: 1.5rem;
    height: 1.5rem;
}

.avatar-md {
    width: 3rem;
    height: 3rem;
}

.avatar-initial {
    color: #fff;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    height: 100%;
}

.table td {
    vertical-align: middle;
}

.text-truncate {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
</style>
</div>
