<div>
    <div class="card">
        <div class="card-header border-bottom">
            <h5 class="card-title">Editar Marca</h5>
            <p class="card-subtitle mb-0">Actualiza la información de la marca</p>
        </div>
        <div class="card-body">
            <form wire:submit="save">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nombre" class="form-label">Nombre de la Marca *</label>
                                    <input type="text"
                                           class="form-control @error('nombre') is-invalid @enderror"
                                           id="nombre"
                                           wire:model="nombre"
                                           placeholder="Ingrese el nombre de la marca">
                                    @error('nombre')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Estado</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="activo" wire:model="activo">
                                        <label class="form-check-label" for="activo">
                                            {{ $activo ? 'Activo' : 'Inactivo' }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="descripcion" class="form-label">Descripción</label>
                                    <textarea class="form-control @error('descripcion') is-invalid @enderror"
                                              id="descripcion"
                                              wire:model="descripcion"
                                              rows="3"
                                              placeholder="Ingrese una descripción de la marca (opcional)"></textarea>
                                    @error('descripcion')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.marcas.index') }}" class="btn btn-label-secondary">
                        <i class=" ri-circle-line  me-1"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class=" ri-circle-line  me-1"></i> Guardar Cambios
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
