<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="mb-0">Detalle del Empleado</h4>
                <a href="{{ route('admin.empleados.edit', $empleado) }}" class="btn btn-primary">
                    <i class=" ri-circle-line  me-1"></i> Editar
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Perfil del Empleado -->
        <div class="col-xl-4 col-lg-5 col-md-5">
            <div class="card mb-6">
                <div class="card-body">
                    <div class="user-avatar-section">
                        <div class="d-flex align-items-center flex-column">
                            <div class="avatar avatar-xl mb-4">
                                <span class="avatar-initial rounded-circle bg-label-primary" style="font-size: 2rem;">
                                    {{ substr($empleado->nombres, 0, 1) }}{{ substr($empleado->apellidos, 0, 1) }}
                                </span>
                            </div>
                            <div class="user-info text-center">
                                <h5 class="mb-0">{{ $empleado->nombre_completo }}</h5>
                                <span class="badge bg-label-secondary mt-1">{{ $empleado->cargo }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
                        <div class="d-flex align-items-center me-5 gap-4">
                            <div class="avatar">
                                <div class="avatar-initial bg-label-primary rounded">
                                    <i class=" ri-circle-line "></i>
                                </div>
                            </div>
                            <div>
                                <h5 class="mb-0">{{ $empleado->antiguedad }}</h5>
                                <span>Años</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-4">
                            <div class="avatar">
                                <div class="avatar-initial bg-label-primary rounded">
                                    <i class=" ri-circle-line "></i>
                                </div>
                            </div>
                            <div>
                                <h5 class="mb-0">{{ $empleado->status ? 'Activo' : 'Inactivo' }}</h5>
                                <span>Estado</span>
                            </div>
                        </div>
                    </div>
                    <h5 class="pb-4 border-bottom mb-4">Detalles</h5>
                    <div class="info-container">
                        <ul class="list-unstyled mb-6">
                            <li class="mb-2">
                                <span class="h6">Código:</span>
                                <span>{{ $empleado->codigo }}</span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">Email:</span>
                                <span>{{ $empleado->email ?: 'No registrado' }}</span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">Teléfono:</span>
                                <span>{{ $empleado->telefono ?: 'No registrado' }}</span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">Empresa:</span>
                                <span>{{ $empleado->empresa->nombre }}</span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">Sucursal:</span>
                                <span>{{ $empleado->sucursal->nombre }}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Información Detallada -->
        <div class="col-xl-8 col-lg-7 col-md-7">
            <div class="nav-align-top">
                <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#personal">
                            <i class=" ri-circle-line  me-2"></i>Personal
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#laboral">
                            <i class=" ri-circle-line  me-2"></i>Laboral
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#pedidos">
                            <i class=" ri-circle-line  me-2"></i>Pedidos
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <!-- Información Personal -->
                    <div class="tab-pane fade show active" id="personal">
                        <div class="card mb-6">
                            <div class="card-header">
                                <h5 class="mb-0">Información Personal</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-6">
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->tipo_documento }}: {{ $empleado->documento }}" readonly>
                                            <label>Documento</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->genero == 'M' ? 'Masculino' : 'Femenino' }}" readonly>
                                            <label>Género</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->fecha_nacimiento ? $empleado->fecha_nacimiento->format('d/m/Y') : 'No registrada' }}" readonly>
                                            <label>Fecha Nacimiento</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->edad ? $empleado->edad . ' años' : 'No calculada' }}" readonly>
                                            <label>Edad</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ ucfirst($empleado->estado_civil) }}" readonly>
                                            <label>Estado Civil</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->contacto_emergencia ?: 'No registrado' }}" readonly>
                                            <label>Contacto Emergencia</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <textarea class="form-control h-px-100" readonly>{{ $empleado->direccion ?: 'No registrada' }}</textarea>
                                            <label>Dirección</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Información Laboral -->
                    <div class="tab-pane fade" id="laboral">
                        <div class="card mb-6">
                            <div class="card-header">
                                <h5 class="mb-0">Información Laboral</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-6">
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->cargo }}" readonly>
                                            <label>Cargo</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->departamento ?: 'No asignado' }}" readonly>
                                            <label>Departamento</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->salario ? 'S/ ' . number_format($empleado->salario, 2) : 'No registrado' }}" readonly>
                                            <label>Salario</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->fecha_ingreso->format('d/m/Y') }}" readonly>
                                            <label>Fecha Ingreso</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->fecha_salida ? $empleado->fecha_salida->format('d/m/Y') : 'Activo' }}" readonly>
                                            <label>Fecha Salida</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating form-floating-outline">
                                            <input type="text" class="form-control" value="{{ $empleado->antiguedad }} años" readonly>
                                            <label>Antigüedad</label>
                                        </div>
                                    </div>
                                    @if($empleado->observaciones)
                                    <div class="col-12">
                                        <div class="form-floating form-floating-outline">
                                            <textarea class="form-control h-px-100" readonly>{{ $empleado->observaciones }}</textarea>
                                            <label>Observaciones</label>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pedidos Asignados -->
                    <div class="tab-pane fade" id="pedidos">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Pedidos Asignados</h5>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info d-flex align-items-center">
                                    <i class=" ri-circle-line  me-3"></i>
                                    <div>
                                        Esta sección mostrará los pedidos asignados al empleado cuando se implemente el módulo de pedidos.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
