<div>
    @section('title', 'Pedido #' . $pedido->codigo)

    <!-- Header Profesional -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-6 gap-6">
        <div class="d-flex flex-column justify-content-center">
            <div class="d-flex align-items-center mb-2">
                <button wire:click="goBack" class="btn btn-sm btn-outline-secondary me-3">
                    <i class="ri-arrow-left-line"></i>
                </button>
                <h4 class="mb-0">Pedido #{{ $pedido->codigo }}</h4>
                <span class="badge bg-label-{{
                    $pedido->estado == 'Pendiente' ? 'warning' :
                    ($pedido->estado == 'Procesando' ? 'info' :
                    ($pedido->estado == 'entregado' ? 'success' :
                    ($pedido->estado == 'cancelado' ? 'danger' : 'primary')))
                }} ms-3 rounded-pill">{{ $pedido->estado }}</span>
            </div>
            <div class="d-flex align-items-center text-muted">
                <i class="ri-calendar-line me-2"></i>
                <span>{{ $pedido->created_at->format('d/m/Y H:i') }}</span>
                <span class="mx-2">•</span>
                <i class="ri-user-line me-2"></i>
                <span>{{ $pedido->user->name }}</span>
                <span class="mx-2">•</span>
                <i class="ri-money-dollar-circle-line me-2"></i>
                <span class="fw-semibold">{{ format_money($pedido->total_usd) }}</span>
            </div>
        </div>
        <div class="d-flex align-content-center flex-wrap gap-2">
            @if($pedido->estado == 'Pendiente')
                <button wire:click="updateOrderStatus('Procesando')" class="btn btn-success">
                    <i class="ri-play-line me-1"></i> Procesar Pedido
                </button>
            @elseif($pedido->estado == 'Procesando')
                <button wire:click="updateOrderStatus('entregado')" class="btn btn-primary">
                    <i class="ri-check-line me-1"></i> Marcar Entregado
                </button>
            @endif
            @if($pedido->user->telefono)
                <a href="tel:{{ $pedido->user->telefono }}" class="btn btn-outline-success">
                    <i class="ri-phone-line me-1"></i> Llamar Cliente
                </a>
            @endif
            @if($pedido->latitud && $pedido->longitud)
                <a href="https://www.google.com/maps/dir//{{ $pedido->latitud }},{{ $pedido->longitud }}" target="_blank" class="btn btn-outline-info">
                    <i class="ri-navigation-line me-1"></i> Navegar
                </a>
            @endif
        </div>
    </div>

    <!-- Contenido Principal -->
    <div class="row">
        <div class="col-12 col-lg-8">
            <!-- Productos del Pedido -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Productos del Pedido</h5>
                    <span class="badge bg-label-primary rounded-pill">{{ $pedido->detalles->count() }} {{ $pedido->detalles->count() == 1 ? 'producto' : 'productos' }}</span>
                </div>
                <div class="card-datatable table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 80px;">Imagen</th>
                                <th>Producto</th>
                                <th class="text-center" style="width: 100px;">Precio Unit.</th>
                                <th class="text-center" style="width: 80px;">Cant.</th>
                                <th class="text-end" style="width: 120px;">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pedido->detalles as $detalle)
                                <tr>
                                    <td>
                                        @if($detalle->producto && $detalle->producto->images && $detalle->producto->images->first())
                                            <img src="{{ asset('app/' . $detalle->producto->images->first()->path) }}"
                                                 alt="{{ $detalle->producto->name }}"
                                                 class="rounded shadow-sm" style="width: 50px; height: 50px; object-fit: cover;">
                                        @else
                                            <div class="bg-label-secondary rounded d-flex align-items-center justify-content-center"
                                                 style="width: 50px; height: 50px;">
                                                <i class="ri-image-line text-muted"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <h6 class="mb-1">{{ $detalle->producto->name ?? 'Producto eliminado' }}</h6>
                                            @if($detalle->producto && $detalle->producto->sku)
                                                <small class="text-muted">SKU: {{ $detalle->producto->sku }}</small>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="fw-medium">{{ format_money($detalle->price) }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-label-info rounded-pill">{{ $detalle->quantity }}</span>
                                    </td>
                                    <td class="text-end">
                                        <strong class="text-primary">{{ format_money($detalle->total_usd) }}</strong>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end fw-semibold">Total del Pedido:</td>
                                <td class="text-end">
                                    <h5 class="mb-0 text-primary">{{ format_money($pedido->total_usd) }}</h5>
                                    @if(is_venezuela_company())
                                        <small class="text-muted">{{ format_money($pedido->total_bs) }} Bs</small>
                                    @endif
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Timeline del Estado -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Estado del Pedido</h5>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="ri-edit-line me-1"></i> Cambiar Estado
                        </button>
                        <ul class="dropdown-menu">
                            @if($pedido->estado != 'Procesando')
                                <li><a class="dropdown-item" href="#" wire:click="updateOrderStatus('Procesando')">
                                    <i class="ri-play-line me-2"></i> Procesando
                                </a></li>
                            @endif
                            @if($pedido->estado != 'entregado')
                                <li><a class="dropdown-item" href="#" wire:click="updateOrderStatus('entregado')">
                                    <i class="ri-check-line me-2"></i> Entregado
                                </a></li>
                            @endif
                            @if($pedido->estado != 'cancelado')
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="#" wire:click="updateOrderStatus('cancelado')">
                                    <i class="ri-close-line me-2"></i> Cancelar
                                </a></li>
                            @endif
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="timeline timeline-advance mb-0">
                        <li class="timeline-item timeline-item-transparent">
                            <span class="timeline-point timeline-point-success"></span>
                            <div class="timeline-event">
                                <div class="timeline-header mb-2">
                                    <h6 class="mb-0">Pedido Recibido</h6>
                                    <small class="text-muted">{{ $pedido->created_at->format('d/m/Y H:i') }}</small>
                                </div>
                                <p class="mb-2">El pedido #{{ $pedido->codigo }} fue creado exitosamente</p>
                            </div>
                        </li>
                        @if(in_array($pedido->estado, ['Procesando', 'entregado']))
                            <li class="timeline-item timeline-item-transparent">
                                <span class="timeline-point {{ $pedido->estado == 'entregado' ? 'timeline-point-success' : 'timeline-point-primary' }}"></span>
                                <div class="timeline-event">
                                    <div class="timeline-header mb-2">
                                        <h6 class="mb-0">En Preparación</h6>
                                        <small class="text-muted">{{ $pedido->estado == 'entregado' ? 'Completado' : 'En proceso' }}</small>
                                    </div>
                                    <p class="mb-2">El pedido está siendo preparado por el equipo</p>
                                </div>
                            </li>
                        @endif
                        <li class="timeline-item timeline-item-transparent pb-0">
                            <span class="timeline-point {{ $pedido->estado == 'entregado' ? 'timeline-point-success' : ($pedido->estado == 'cancelado' ? 'timeline-point-danger' : 'timeline-point-secondary') }}"></span>
                            <div class="timeline-event pb-0">
                                <div class="timeline-header mb-2">
                                    <h6 class="mb-0">{{ $pedido->estado == 'cancelado' ? 'Cancelado' : 'Entregado' }}</h6>
                                    <small class="text-muted">
                                        @if($pedido->estado == 'entregado')
                                            {{ $pedido->fecha_entrega ? $pedido->fecha_entrega->format('d/m/Y H:i') : 'Completado' }}
                                        @elseif($pedido->estado == 'cancelado')
                                            Pedido cancelado
                                        @else
                                            Pendiente
                                        @endif
                                    </small>
                                </div>
                                <p class="mb-0">
                                    @if($pedido->estado == 'entregado')
                                        Pedido entregado exitosamente al cliente
                                    @elseif($pedido->estado == 'cancelado')
                                        El pedido ha sido cancelado
                                    @else
                                        El pedido será entregado pronto
                                    @endif
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-4">
            <!-- Información del Cliente -->
            <div class="card mb-6">
                <div class="card-header">
                    <h5 class="card-title m-0">Información del Cliente</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-4">
                        <div class="avatar me-3">
                            <span class="avatar-initial rounded-circle bg-label-primary">
                                {{ strtoupper(substr($pedido->user->name, 0, 2)) }}
                            </span>
                        </div>
                        <div class="d-flex flex-column">
                            <h6 class="mb-0">{{ $pedido->user->name }}</h6>
                            <small class="text-muted">Cliente ID: #{{ $pedido->user->id }}</small>
                        </div>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <i class="ri-mail-line me-3 text-muted"></i>
                        <span>{{ $pedido->user->email }}</span>
                    </div>
                    @if($pedido->user->telefono)
                        <div class="d-flex align-items-center mb-3">
                            <i class="ri-phone-line me-3 text-muted"></i>
                            <span>{{ $pedido->user->telefono }}</span>
                        </div>
                    @endif
                    <div class="d-flex align-items-center">
                        <i class="ri-calendar-line me-3 text-muted"></i>
                        <span>Cliente desde {{ $pedido->user->created_at->format('M Y') }}</span>
                    </div>
                </div>
            </div>

            <!-- Dirección de Entrega -->
            <div class="card mb-6">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title m-0">Dirección de Entrega</h5>
                    @if($pedido->latitud && $pedido->longitud)
                        <a href="https://www.google.com/maps?q={{ $pedido->latitud }},{{ $pedido->longitud }}" 
                           target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="ri-external-link-line"></i>
                        </a>
                    @endif
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-start">
                        <i class="ri-map-pin-line me-3 mt-1 text-primary"></i>
                        <div class="flex-grow-1">
                            <p class="mb-2">{{ $pedido->ubicacion }}</p>
                            @if($pedido->latitud && $pedido->longitud)
                                <small class="text-muted d-block mb-3">
                                    Coordenadas: {{ number_format($pedido->latitud, 6) }}, {{ number_format($pedido->longitud, 6) }}
                                </small>
                                <a href="https://www.google.com/maps/dir//{{ $pedido->latitud }},{{ $pedido->longitud }}" 
                                   target="_blank" class="btn btn-primary btn-sm w-100">
                                    <i class="ri-navigation-line me-1"></i> Obtener Direcciones
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Información de Pago -->
            <div class="card mb-6">
                <div class="card-header">
                    <h5 class="card-title m-0">Información de Pago</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="text-muted">Método de Pago:</span>
                        <span class="fw-semibold">{{ $pedido->metodo_pago ?? 'No especificado' }}</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="text-muted">Subtotal:</span>
                        <span>{{ format_money($pedido->total_usd) }}</span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Total:</h6>
                        <h5 class="mb-0 text-primary">{{ format_money($pedido->total_usd) }}</h5>
                    </div>
                    @if(is_venezuela_company())
                        <div class="text-end mt-1">
                            <small class="text-muted">{{ format_money($pedido->total_bs) }} Bs</small>
                        </div>
                    @endif
                    @if($pedido->pagos && $pedido->pagos->count() > 0)
                        <hr>
                        <h6 class="mb-2">Detalles de Pago:</h6>
                        @foreach($pedido->pagos as $pago)
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted">{{ $pago->metodo_pago }}</small>
                                <small class="fw-medium">{{ format_money($pago->total_usd) }}</small>
                            </div>
                            @if($pago->referencia)
                                <div class="mb-2">
                                    <small class="text-muted">Ref: {{ $pago->referencia }}</small>
                                </div>
                            @endif
                        @endforeach
                    @endif
                </div>
            </div>

            <!-- Notas del Pedido -->
            @if($pedido->nota)
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title m-0">Notas del Pedido</h5>
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $pedido->nota }}</p>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>