<div>
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Notificaciones en Tiempo Real</h5>
        </div>
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6 class="mb-0">Pedidos Pendientes</h6>
                <span class="badge bg-warning rounded-pill">{{ $pendingOrdersCount }}</span>
            </div>
            
            @if($pendingOrdersCount > 0)
                <div class="alert alert-warning">
                    <i class="ri-alert-line me-2"></i>
                    Tienes {{ $pendingOrdersCount }} pedidos pendientes por procesar
                </div>
            @else
                <div class="alert alert-success">
                    <i class="ri-checkbox-circle-line me-2"></i>
                    No tienes pedidos pendientes
                </div>
            @endif
            
            <hr>
            
            <h6 class="mb-3">Pedidos Recientes</h6>
            @if(count($recentOrders) > 0)
                @foreach($recentOrders as $order)
                    <div class="d-flex justify-content-between align-items-center mb-2 pb-2 border-bottom">
                        <div>
                            <p class="mb-0 fw-medium">#{{ $order->codigo }}</p>
                            <small class="text-muted">{{ $order->created_at->diffForHumans() }}</small>
                        </div>
                        <span class="badge bg-{{ $order->estado == 'Pendiente' ? 'warning' : ($order->estado == 'Completado' ? 'success' : 'info') }}">
                            {{ $order->estado }}
                        </span>
                    </div>
                @endforeach
            @else
                <p class="text-muted text-center my-3">No hay pedidos recientes</p>
            @endif
            
            <div class="d-grid mt-3">
                <a href="{{ route('admin.admin.pedidos.historico', Auth::id()) }}" class="btn btn-primary">
                    <i class="ri-list-check me-1"></i> Ver Todos los Pedidos
                </a>
            </div>
        </div>
    </div>
</div>