<div>
    @if (session()->has('message'))
        <script>
            window.addEventListener('DOMContentLoaded', function() {
                window.dispatchEvent(new CustomEvent('show-toast', {
                    detail: {
                        type: 'success',
                        message: '{{ session('message') }}',
                        timeout: 5000
                    }
                }));
            });
        </script>
    @endif

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1">{{ number_format($stats['total']) }}</h3>
                            <p class="mb-0">Total Empleados</p>
                            <small class="text-muted">Personal registrado</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-primary">
                                <i class="ri-team-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-success">{{ number_format($stats['activos']) }}</h3>
                            <p class="mb-0">Empleados Activos</p>
                            <small class="text-muted">{{ $stats['total'] > 0 ? round(($stats['activos'] / $stats['total']) * 100, 1) : 0 }}% del total</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-success">
                                <i class="ri-user-check-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-warning">{{ number_format($stats['nuevos_mes']) }}</h3>
                            <p class="mb-0">Nuevos este Mes</p>
                            <small class="text-muted">{{ now()->format('F Y') }}</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-warning">
                                <i class="ri-user-add-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="card-title mb-1 text-info">{{ number_format($stats['departamentos']) }}</h3>
                            <p class="mb-0">Departamentos</p>
                            <small class="text-muted">Areas de trabajo</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-info">
                                <i class="ri-building-2-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y acciones -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Empleados</h5>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.empleados.create') }}" class="btn btn-primary">
                    <i class="ri-user-add-line"></i> Nuevo Empleado
                </a>
                <button wire:click="clearFilters" class="btn btn-outline-secondary">
                    <i class="ri-filter-off-line"></i> Limpiar
                </button>
            </div>
        </div>

        <div class="card-body">
            <!-- Filtros -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text"><i class="ri-search-line"></i></span>
                        <input type="text" class="form-control" placeholder="Buscar empleados..." wire:model.live="search">
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="statusFilter">
                        <option value="">Todos los estados</option>
                        <option value="1">Activos</option>
                        <option value="0">Inactivos</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="departamentoFilter">
                        <option value="">Todos los departamentos</option>
                        @foreach($departamentos as $departamento)
                            <option value="{{ $departamento }}">{{ $departamento }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Tabla -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('codigo')" style="cursor: pointer;">
                                Código @if($sortBy === 'codigo') <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line"></i> @endif
                            </th>
                            <th wire:click="sortBy('nombres')" style="cursor: pointer;">
                                Empleado @if($sortBy === 'nombres') <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-s-line"></i> @endif
                            </th>
                            <th>Documento</th>
                            <th>Email</th>
                            <th>Cargo</th>
                            <th>Departamento</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($empleados as $empleado)
                            <tr>
                                <td><strong>{{ $empleado->codigo }}</strong></td>
                                <td>
                                    <div>
                                        <strong>{{ $empleado->nombre_completo }}</strong>
                                        @if($empleado->telefono)
                                            <br><small class="text-muted">
                                                <i class="ri-phone-line me-1"></i>{{ $empleado->telefono }}
                                            </small>
                                        @endif
                                    </div>
                                </td>
                                <td>{{ $empleado->documento }}</td>
                                <td>{{ $empleado->email }}</td>
                                <td>{{ $empleado->cargo }}</td>
                                <td>{{ $empleado->departamento }}</td>
                                <td>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox"
                                               wire:click="toggleStatus({{ $empleado->id }})"
                                               {{ $empleado->status ? 'checked' : '' }}>
                                        <label class="form-check-label">
                                        </label>
                                    </div>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                            <i class="ri-more-2-line"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="{{ route('admin.empleados.show', $empleado) }}">
                                                <i class="ri-eye-line me-1"></i> Ver
                                            </a></li>
                                            <li><a class="dropdown-item" href="{{ route('admin.empleados.edit', $empleado) }}">
                                                <i class="ri-edit-line me-1"></i> Editar
                                            </a></li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li><a class="dropdown-item text-danger" href="#"
                                                wire:click="delete({{ $empleado->id }})"
                                                wire:confirm="¿Estás seguro de eliminar este empleado?">
                                                <i class="ri-delete-bin-line me-1"></i> Eliminar
                                            </a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="ri-team-line ri-3x text-muted mb-2"></i>
                                    <p class="text-muted mb-0">No se encontraron empleados</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-between align-items-center mt-3">

                {{ $empleados->links('livewire.pagination') }}
            </div>
        </div>
    </div>
</div>
