<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Gestión de Cotizaciones</h1>
            <p class="mb-0 text-muted">Administra y controla todas las cotizaciones</p>
        </div>
        <a href="{{ route('admin.cotizaciones.create') }}" class="btn btn-primary">
            <i class="ri-add-line me-2"></i>Nueva Cotización
        </a>
    </div>

    <!-- Estadísticas Cards -->
    <div class="row g-3 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-primary bg-opacity-10 rounded-3 p-3">
                                <i class="ri-file-text-line text-primary fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Total Cotizaciones</h6>
                            <h3 class="mb-0">{{ number_format($this->totalCotizaciones) }}</h3>
                            <small class="text-success"><i class="ri-arrow-up-line"></i> Período actual</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-success bg-opacity-10 rounded-3 p-3">
                                <i class="ri-money-dollar-circle-line text-success fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Monto Total</h6>
                            <h3 class="mb-0">{{ format_money($this->totalMonto) }}</h3>
                            <small class="text-success"><i class="ri-arrow-up-line"></i> {{ $this->fechaInicio }} - {{ $this->fechaFin }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <h6 class="text-muted mb-3">Cotizaciones por Estado</h6>
                    <div class="row g-2">
                        @foreach($this->cotizacionesPorEstado as $estado)
                            <div class="col-6">
                                <div class="d-flex justify-content-between align-items-center p-2 bg-light rounded">
                                    <span class="small fw-semibold">{{ $estado['nombre'] }}</span>
                                    <div class="text-end">
                                        <div class="fw-bold">{{ $estado['cantidad'] }}</div>
                                        <small class="text-muted">{{ $estado['monto'] }}</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-0 pb-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Filtros de Búsqueda</h5>
                <button wire:click="limpiarFiltros" class="btn btn-outline-secondary btn-sm">
                    <i class="ri-refresh-line me-1"></i>Limpiar
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Buscar</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light border-end-0">
                            <i class="ri-search-line text-muted"></i>
                        </span>
                        <input type="text" wire:model.live.debounce.300ms="search"
                               class="form-control border-start-0"
                               placeholder="Número, serie o cliente...">
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Inicio</label>
                    <input type="date" wire:model.live="fechaInicio" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fecha Fin</label>
                    <input type="date" wire:model.live="fechaFin" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Estado</label>
                    <select wire:model.live="estado" class="form-select">
                        <option value="">Todos</option>
                        @foreach($estados as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Cliente</label>
                    <select wire:model.live="clienteId" class="form-select">
                        <option value="">Todos</option>
                        @foreach($clientes as $cliente)
                            <option value="{{ $cliente->id }}">{{ $cliente->nombre_completo }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Cotizaciones -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Listado de Cotizaciones</h5>
                <div class="text-muted small">
                    {{ $cotizaciones->firstItem() ?? 0 }} - {{ $cotizaciones->lastItem() ?? 0 }} de {{ $cotizaciones->total() }} cotizaciones
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($cotizaciones->isEmpty())
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="ri-file-text-line text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <h5 class="text-muted">No se encontraron cotizaciones</h5>
                    <p class="text-muted mb-0">Ajusta los filtros o crea una nueva cotización</p>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Cotización</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Cliente</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small">Fechas</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Total</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Estado</th>
                                <th class="border-0 fw-semibold text-uppercase text-muted small text-center pe-4">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($cotizaciones as $cotizacion)
                                <tr>
                                    <td class="ps-4">
                                        <div class="d-flex align-items-center">
                                            <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                <i class="ri-file-text-line text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $cotizacion->numero_completo }}</div>
                                                <small class="text-muted">{{ $cotizacion->created_at->format('d/m/Y H:i') }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="ri-user-line text-muted me-2"></i>
                                            <span>{{ $cotizacion->cliente->nombre_completo ?? 'Sin cliente' }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="small"><strong>Emisión:</strong> {{ $cotizacion->fecha_emision->format('d/m/Y') }}</span>
                                            <span class="small text-muted"><strong>Vence:</strong> {{ $cotizacion->fecha_vencimiento->format('d/m/Y') }}</span>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <span class="fw-bold text-dark">{{ format_money($cotizacion->total) }}</span>
                                    </td>
                                    <td class="text-center">
                                        @switch($cotizacion->estado)
                                            @case('pendiente')
                                                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-2 py-1">
                                                    <i class="ri-time-line me-1"></i>Pendiente
                                                </span>
                                                @break
                                            @case('aprobada')
                                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-2 py-1">
                                                    <i class="ri-check-line me-1"></i>Aprobada
                                                </span>
                                                @break
                                            @case('rechazada')
                                                <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-2 py-1">
                                                    <i class="ri-close-line me-1"></i>Rechazada
                                                </span>
                                                @break
                                            @case('vencida')
                                                <span class="badge bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25 px-2 py-1">
                                                    <i class="ri-calendar-line me-1"></i>Vencida
                                                </span>
                                                @break
                                            @case('convertida')
                                                <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25 px-2 py-1">
                                                    <i class="ri-exchange-line me-1"></i>Convertida
                                                </span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td class="text-center pe-4">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.cotizaciones.show', $cotizacion->id) }}"
                                               class="btn btn-outline-primary btn-sm"
                                               title="Ver detalle">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            @if($cotizacion->estado === 'pendiente')
                                                <a href="{{ route('admin.cotizaciones.edit', $cotizacion->id) }}"
                                                   class="btn btn-outline-secondary btn-sm"
                                                   title="Editar">
                                                    <i class="ri-edit-line"></i>
                                                </a>
                                                <button wire:click="cambiarEstado({{ $cotizacion->id }}, 'aprobada')"
                                                        class="btn btn-outline-success btn-sm"
                                                        title="Aprobar">
                                                    <i class="ri-check-line"></i>
                                                </button>
                                                <button wire:click="cambiarEstado({{ $cotizacion->id }}, 'rechazada')"
                                                        class="btn btn-outline-danger btn-sm"
                                                        title="Rechazar">
                                                    <i class="ri-close-line"></i>
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if($cotizaciones->hasPages())
                    <div class="card-footer bg-white border-0">
                        {{ $cotizaciones->links() }}
                    </div>
                @endif
            @endif
        </div>
    </div>
</div>
