<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Nueva Cotización</h1>
            <p class="mb-0 text-muted">Crear una nueva cotización de productos</p>
        </div>
        <a href="{{ route('admin.cotizaciones.index') }}" class="btn btn-outline-secondary">
            <i class="ri-arrow-left-line me-2"></i>Volver
        </a>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form wire:submit="save">
        <div class="row">
            <!-- Información de la Cotización -->
            <div class="col-lg-8">
                <!-- Datos Básicos -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Información Básica</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Serie</label>
                                    <input type="text" wire:model="serie" class="form-control" readonly>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Número</label>
                                    <input type="text" wire:model="numero" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Fecha Emisión</label>
                                    <input type="date" wire:model="fecha_emision" class="form-control" required>
                                    @error('fecha_emision') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Fecha Vencimiento</label>
                                    <input type="date" wire:model="fecha_vencimiento" class="form-control" required>
                                    @error('fecha_vencimiento') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Cliente</label>
                            <div class="input-group">
                                <select wire:model="cliente_id" class="form-select" required>
                                    <option value="">Seleccionar cliente...</option>
                                    @foreach($clientes as $cliente)
                                        <option value="{{ $cliente->id }}">{{ $cliente->nombre_completo }}</option>
                                    @endforeach
                                </select>
                                <button type="button" wire:click="abrirModalCliente" class="btn btn-outline-primary">
                                    <i class="ri-user-add-line me-1"></i>Nuevo
                                </button>
                            </div>
                            @error('cliente_id') <div class="text-danger small">{{ $message }}</div> @enderror
                        </div>
                    </div>
                </div>

                <!-- Búsqueda de Productos -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Agregar Productos</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Buscar Producto</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="ri-search-line text-muted"></i>
                                </span>
                                <input type="text" wire:model.live.debounce.300ms="search"
                                       class="form-control border-start-0"
                                       placeholder="Buscar por nombre o código...">
                            </div>
                        </div>

                        @if(count($searchResults) > 0)
                            <div class="row g-3">
                                @foreach($searchResults as $result)
                                    <div class="col-6 col-md-4 col-lg-3">
                                        <div class="product-card card h-100 border-0 shadow-sm position-relative"
                                             wire:click="addToCart({{ $result['id'] }})"
                                             style="cursor: pointer; transition: all 0.3s ease;">

                                            <!-- Badge de stock -->
                                            <div class="position-absolute top-0 end-0 m-2 z-index-1">
                                                <span class="badge {{ $result['quantity'] > 10 ? 'bg-success' : ($result['quantity'] > 0 ? 'bg-warning text-dark' : 'bg-danger') }} shadow-sm">
                                                    <i class="ri-inventory-2-line me-1"></i>{{ $result['quantity'] }}
                                                </span>
                                            </div>

                                            <!-- Imagen del producto -->
                                            <div class="product-image-container position-relative">
                                                @if ($result['image_path'])
                                                    <img src="{{ asset('app/'.$result['image_path']) }}"
                                                         alt="{{ $result['nombre'] }}"
                                                         class="card-img-top"
                                                         style="height: 160px; object-fit: cover;">
                                                @else
                                                    <div class="card-img-top bg-gradient-light d-flex align-items-center justify-content-center"
                                                         style="height: 160px;">
                                                        <i class="ri-image-line" style="font-size: 3rem; color: #6c757d;"></i>
                                                    </div>
                                                @endif

                                                <!-- Overlay con precio destacado -->
                                                <div class="position-absolute bottom-0 start-0 end-0 bg-gradient-dark text-white p-2">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <span class="fw-bold fs-5">{{ format_money($result['precio']) }}</span>
                                                        @if($result['has_variants'])
                                                            <small class="badge bg-info">
                                                                <i class="ri-list-check-2 me-1"></i>Variantes
                                                            </small>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-3">
                                                <h6 class="card-title mb-2 fw-bold text-truncate" title="{{ $result['nombre'] }}">
                                                    {{ $result['nombre'] }}
                                                </h6>
                                                <p class="card-text small text-muted mb-2 text-truncate" style="height: 2.4em; line-height: 1.2em;">
                                                    {{ $result['descripcion'] ?: 'Sin descripción disponible' }}
                                                </p>
                                                <div class="d-flex justify-content-between align-items-center mt-auto">
                                                    <small class="text-muted">
                                                        <i class="ri-barcode-line me-1"></i>{{ $result['codigo'] }}
                                                    </small>
                                                    <button class="btn btn-primary btn-sm">
                                                        <i class="ri-add-line"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="empty-state text-center py-5">
                                <div class="mb-4">
                                    <i class="ri-search-line" style="font-size: 5rem; color: #6c757d; opacity: 0.5;"></i>
                                </div>
                                <h4 class="text-muted mb-3">Buscar productos</h4>
                                <p class="text-muted mb-4">Escriba el nombre, código o escanee el código de barras para encontrar productos</p>
                                <div class="d-flex justify-content-center gap-3">
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-keyboard-line me-1"></i>Escribir nombre
                                    </span>
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-barcode-line me-1"></i>Escanear código
                                    </span>
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-hashtag me-1"></i>Código manual
                                    </span>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Carrito -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Productos Seleccionados</h5>
                    </div>
                    <div class="card-body p-0">
                        @if(empty($cart))
                            <div class="text-center py-5">
                                <i class="ri-shopping-cart-line text-muted" style="font-size: 3rem;"></i>
                                <p class="text-muted mt-2">No hay productos en el carrito</p>
                            </div>
                        @else
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Producto</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Cantidad</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Precio</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Subtotal</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-center pe-4">Acción</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($cart as $index => $item)
                                            <tr>
                                                <td class="ps-4">
                                                    <div class="d-flex align-items-center">
                                                        <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                            <i class="ri-product-hunt-line text-primary"></i>
                                                        </div>
                                                        <div>
                                                            <div class="fw-semibold">{{ $item['descripcion'] }}</div>
                                                            <small class="text-muted">{{ $item['codigo'] }}</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number"
                                                           wire:change="updateQuantity({{ $index }}, $event.target.value)"
                                                           value="{{ $item['cantidad'] }}"
                                                           min="0.01"
                                                           step="0.01"
                                                           class="form-control form-control-sm text-center"
                                                           style="width: 80px;">
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-semibold">{{ format_money($item['precio_unitario']) }}</span>
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-bold">{{ format_money($item['subtotal']) }}</span>
                                                </td>
                                                <td class="text-center pe-4">
                                                    <button type="button"
                                                            wire:click="removeFromCart({{ $index }})"
                                                            class="btn btn-outline-danger btn-sm">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot class="table-light">
                                        <tr>
                                            <td colspan="3" class="text-end fw-bold ps-4">Subtotal:</td>
                                            <td class="text-end fw-bold">{{ format_money($this->getSubtotal()) }}</td>
                                            <td class="pe-4"></td>
                                        </tr>
                                        @if($this->getImpuestos() > 0)
                                            <tr>
                                                <td colspan="3" class="text-end fw-bold ps-4">Impuestos:</td>
                                                <td class="text-end fw-bold">{{ format_money($this->getImpuestos()) }}</td>
                                                <td class="pe-4"></td>
                                            </tr>
                                        @endif
                                        <tr>
                                            <td colspan="3" class="text-end fw-bold ps-4">Total:</td>
                                            <td class="text-end fw-bold fs-5 text-success">{{ format_money($this->getTotal()) }}</td>
                                            <td class="pe-4"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Resumen y Acciones -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Resumen</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <span>Productos:</span>
                            <span class="fw-semibold">{{ count($cart) }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Subtotal:</span>
                            <span class="fw-semibold">{{ format_money($this->getSubtotal()) }}</span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tasa de Impuesto (%)</label>
                            <input type="number" wire:model.live="tasa_impuesto" class="form-control" min="0" max="100" step="0.01">
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Impuestos:</span>
                            <span class="fw-semibold">{{ format_money($this->getImpuestos()) }}</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <span class="fw-bold">Total:</span>
                            <span class="fw-bold fs-4 text-success">{{ format_money($this->getTotal()) }}</span>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Observaciones</h5>
                    </div>
                    <div class="card-body">
                        <textarea wire:model="observaciones"
                                  class="form-control"
                                  rows="3"
                                  placeholder="Observaciones adicionales..."></textarea>
                    </div>
                    <div class="card-footer bg-white border-0">
                        <button type="submit"
                                class="btn btn-success w-100"
                                {{ empty($cart) ? 'disabled' : '' }}>
                            <i class="ri-save-line me-2"></i>Crear Cotización
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal de variantes -->
    @if($showVariantsModal && $selectedProductForVariants)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.7); z-index: 9999; position: fixed; top: 0; left: 0; width: 100%; height: 100%;" wire:click.self="closeVariantsModal">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0 shadow-lg">
                    <div class="modal-header bg-gradient-primary text-white border-0">
                        <h5 class="modal-title fw-bold">
                            <i class="ri-shopping-bag-3-line me-2"></i>
                            Seleccionar Producto
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeVariantsModal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <!-- Información del producto -->
                        <div class="product-info mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="product-image-container rounded-3 overflow-hidden shadow-sm">
                                        @if ($selectedProductForVariants->featuredImage)
                                            <img src="{{ asset('app/'.$selectedProductForVariants->featuredImage->path) }}"
                                                 alt="{{ $selectedProductForVariants->nombre }}"
                                                 class="w-100" style="height: 200px; object-fit: cover;">
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                                <i class="ri-image-line" style="font-size: 4rem; color: #6c757d;"></i>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <h4 class="fw-bold mb-2 text-primary">{{ $selectedProductForVariants->name }}</h4>
                                    <p class="text-muted mb-3">{{ $selectedProductForVariants->description }}</p>
                                    <div class="d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary fs-6 px-3 py-2">
                                            <i class="ri-price-tag-3-line me-1"></i>
                                            {{ format_money($selectedProductForVariants->precio) }}
                                        </span>
                                        <span class="badge {{ $selectedProductForVariants->quantity > 10 ? 'bg-success' : ($selectedProductForVariants->quantity > 0 ? 'bg-warning' : 'bg-danger') }} fs-6 px-3 py-2">
                                            <i class="ri-inventory-2-line me-1"></i>
                                            Stock: {{ $selectedProductForVariants->quantity }}
                                        </span>
                                        @if ($selectedProductForVariants->code)
                                            <span class="badge bg-secondary fs-6 px-3 py-2">
                                                <i class="ri-barcode-line me-1"></i>
                                                {{ $selectedProductForVariants->code }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Opciones de variantes -->
                            <div class="col-md-7">
                                <h6 class="fw-bold mb-3 text-primary">
                                    <i class="ri-list-check-2 me-1"></i>Opciones Disponibles
                                </h6>

                                <!-- Producto principal -->
                                <div class="variant-option mb-3" wire:click="selectVariant('main')" style="cursor: pointer;">
                                    <div class="card {{ $selectedVariant === 'main' ? 'border-primary bg-light' : 'border' }} h-100">
                                        <div class="card-body p-3">
                                            <div class="d-flex align-items-center">
                                                <div class="form-check me-3">
                                                    <input class="form-check-input" type="radio" {{ $selectedVariant === 'main' ? 'checked' : '' }}>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-1 fw-bold">Producto Principal</h6>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <span class="text-primary fw-bold">{{ format_money($selectedProductForVariants->precio) }}</span>
                                                        <span class="badge {{ $selectedProductForVariants->quantity > 0 ? 'bg-success' : 'bg-danger' }}">
                                                            Stock: {{ $selectedProductForVariants->quantity }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Variantes -->
                                @if ($selectedProductForVariants->variants && $selectedProductForVariants->variants->count() > 0)
                                    @foreach ($selectedProductForVariants->variants as $variante)
                                        <div class="variant-option mb-3" wire:click="selectVariant({{ $variante->id }})" style="cursor: pointer;">
                                            <div class="card {{ $selectedVariant == $variante->id ? 'border-primary bg-light' : 'border' }} h-100">
                                                <div class="card-body p-3">
                                                    <div class="d-flex align-items-center">
                                                        <div class="form-check me-3">
                                                            <input class="form-check-input" type="radio" {{ $selectedVariant == $variante->id ? 'checked' : '' }}>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <h6 class="card-title mb-1 fw-bold">{{ $variante->formatted_values }}</h6>
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <span class="text-primary fw-bold">
                                                                    {{ format_money($selectedProductForVariants->precio + $variante->price_adjustment) }}
                                                                </span>
                                                                <span class="badge {{ $variante->quantity > 0 ? 'bg-success' : 'bg-danger' }}">
                                                                    Stock: {{ $variante->quantity }}
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>

                            <!-- Panel de compra -->
                            <div class="col-md-5">
                                <div class="purchase-panel bg-light rounded-3 p-3">
                                    <h6 class="fw-bold mb-3 text-primary">
                                        <i class="ri-shopping-cart-2-line me-1"></i>Detalles de Cotización
                                    </h6>

                                    <!-- Cantidad -->
                                    <div class="mb-3">
                                        <label class="form-label small text-muted">Cantidad:</label>
                                        <div class="input-group">
                                            <button class="btn btn-outline-secondary" wire:click="$set('variantQuantity', {{ max(1, $variantQuantity - 1) }})" {{ !$selectedVariant ? 'disabled' : '' }}>
                                                <i class="ri-subtract-line"></i>
                                            </button>
                                            <input type="number" class="form-control text-center fw-bold" wire:model="variantQuantity"
                                                   min="1" max="1000" {{ !$selectedVariant ? 'disabled' : '' }}>
                                            <button class="btn btn-outline-secondary" wire:click="$set('variantQuantity', {{ $variantQuantity + 1 }})" {{ !$selectedVariant ? 'disabled' : '' }}>
                                                <i class="ri-add-line"></i>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Total -->
                                    <div class="mb-4 p-3 bg-white rounded border">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span class="fw-bold">Total:</span>
                                            <span class="h4 mb-0 text-success fw-bold">
                                                @if ($selectedVariant === 'main')
                                                    {{ format_money($selectedProductForVariants->precio * $variantQuantity) }}
                                                @elseif ($selectedVariant && $selectedProductForVariants->variants)
                                                    @php
                                                        $selectedVariantData = $selectedProductForVariants->variants->firstWhere('id', $selectedVariant);
                                                    @endphp
                                                    @if ($selectedVariantData)
                                                        {{ format_money(($selectedProductForVariants->precio + $selectedVariantData->price_adjustment) * $variantQuantity) }}
                                                    @endif
                                                @else
                                                    --
                                                @endif
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Botones -->
                                    <div class="d-grid gap-2">
                                        <button type="button" class="btn btn-success" wire:click="addVariantToCart" {{ !$selectedVariant ? 'disabled' : '' }}>
                                            <i class="ri-shopping-cart-line me-2"></i>Agregar al Carrito
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary" wire:click="closeVariantsModal">
                                            <i class="ri-close-line me-2"></i>Cancelar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal de Cliente -->
    @if($showClientModal)
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Registrar Nuevo Cliente</h5>
                        <button type="button" wire:click="cerrarModalCliente" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Nombres *</label>
                                <input type="text" wire:model="clienteNombres" class="form-control" required>
                                @error('clienteNombres') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Apellidos *</label>
                                <input type="text" wire:model="clienteApellidos" class="form-control" required>
                                @error('clienteApellidos') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email</label>
                                <input type="email" wire:model="clienteEmail" class="form-control">
                                @error('clienteEmail') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Teléfono</label>
                                <input type="text" wire:model="clienteTelefono" class="form-control">
                                @error('clienteTelefono') <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-12">
                                <label class="form-label">Dirección</label>
                                <textarea wire:model="clienteDireccion" class="form-control" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" wire:click="cerrarModalCliente" class="btn btn-secondary">Cancelar</button>
                        <button type="button" wire:click="guardarCliente" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i>Guardar Cliente
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
/* Product Cards */
.product-card {
    transition: all 0.3s ease;
    border-radius: 15px;
    overflow: hidden;
    border: 2px solid transparent;
}

.product-card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 15px 35px rgba(0,0,0,0.2) !important;
    border-color: #0d6efd;
}

.product-image-container {
    position: relative;
    overflow: hidden;
}

.bg-gradient-light {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.bg-gradient-dark {
    background: linear-gradient(0deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.4) 50%, transparent 100%);
}

.z-index-1 {
    z-index: 1;
}

.product-card .card-body {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
}

.product-card:hover .card-body {
    background: linear-gradient(135deg, #f8f9fa 0%, #e3f2fd 100%);
}

/* Empty States */
.empty-state {
    padding: 3rem 1rem;
}

/* Modal Improvements */
.modal-content {
    border-radius: 15px;
    overflow: hidden;
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #0d6efd 0%, #0056b3 100%);
}

/* Variant Options */
.variant-option {
    transition: all 0.2s ease;
}

.variant-option:hover .card {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.variant-option .card.border-primary {
    border-width: 2px !important;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}

/* Purchase Panel */
.purchase-panel {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid #dee2e6;
}

/* Buttons */
.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: translateY(-1px);
}

/* Badges */
.badge {
    border-radius: 6px;
    font-weight: 500;
}

/* Cards */
.card {
    border-radius: 12px;
    border: 1px solid rgba(0,0,0,0.08);
}

.card-header {
    border-radius: 12px 12px 0 0 !important;
    background-color: #fff;
    border-bottom: 1px solid rgba(0,0,0,0.08);
}
</style>
@endpush