<div>
    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Total Categorías</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['total'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-primary">
                                <i class=" ri-folder-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Categorías Activas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['activas'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-success">
                                <i class=" ri-folder-check-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Categorías Inactivas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['inactivas'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-danger">
                                <i class=" ri-folder-forbid-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y acciones -->
    <div class="card">
        <div class="card-header border-bottom d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
            <div>
                <h5 class="card-title mb-0">Lista de Categorías</h5>
                <p class="card-subtitle mt-1 mb-0">Gestiona las categorías de tus productos</p>
            </div>
            <div class="d-flex flex-wrap gap-2">
                <div class="input-group w-px-300">
                    <span class="input-group-text"><i class=" ri-search-line"></i></span>
                    <input type="text" class="form-control" placeholder="Buscar categorías..." wire:model.live.debounce.300ms="search">
                </div>

                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class=" ri-filter-line me-1"></i>Filtros
                    </button>
                    <div class="dropdown-menu p-3" style="min-width: 280px;">
                        <div class="mb-3">
                            <label class="form-label">Estado</label>
                            <select class="form-select" wire:model.live="status">
                                <option value="">Todos los estados</option>
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Mostrar</label>
                            <select class="form-select" wire:model.live="perPage">
                                <option value="10">10 por página</option>
                                <option value="25">25 por página</option>
                                <option value="50">50 por página</option>
                                <option value="100">100 por página</option>
                            </select>
                        </div>
                    </div>
                </div>

                <a href="{{ route('admin.categorias.create') }}" class="btn btn-primary d-flex align-items-center">
                    <i class=" ri-add-line ri-20px me-1"></i>
                    <span class="d-none d-sm-inline-block">Agregar Categoría</span>
                </a>
            </div>
        </div>

        <div class="card-datatable table-responsive">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th style="width: 5%">#</th>
                        <th style="width: 35%">Nombre</th>
                        <th style="width: 40%">Descripción</th>
                        <th style="width: 10%">Estado</th>
                        <th style="width: 10%">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($categorias as $categoria)
                        <tr>
                            <td>
                                <span class="fw-medium">{{ $categoria->id }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm me-3">
                                        <span class="avatar-initial rounded bg-label-primary">
                                            <i class=" ri-price-tag-3-line"></i>
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-0">{{ $categoria->nombre }}</h6>
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($categoria->descripcion)
                                    <span class="text-muted">{{ Str::limit($categoria->descripcion, 50) }}</span>
                                @else
                                    <span class="text-muted">Sin descripción</span>
                                @endif
                            </td>
                            <td>
                                <div class="form-check form-switch mb-0">
                                    <input class="form-check-input" type="checkbox"
                                           wire:click="toggleEstado({{ $categoria->id }})"
                                           @if($categoria->activo) checked @endif
                                           style="cursor: pointer;">
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class=" ri-more-2-line"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        @can('edit categorias')
                                        <a class="dropdown-item" href="{{ route('admin.categorias.edit', $categoria) }}">
                                            <i class=" ri-edit-line me-1"></i> Editar
                                        </a>
                                        @endcan
                                        @can('delete categorias')
                                        <button type="button" class="dropdown-item text-danger"
                                                wire:click="delete({{ $categoria->id }})"
                                                wire:confirm="¿Estás seguro de que deseas eliminar esta categoría?">
                                            <i class=" ri-delete-bin-line me-1"></i> Eliminar
                                        </button>
                                        @endcan
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-4">
                                <i class=" ri-folder-line fs-1 text-muted mb-2"></i>
                                <p class="mb-0">No se encontraron categorías</p>
                                <p class="text-muted">Prueba cambiando los filtros o crea una nueva categoría</p>
                                <a href="{{ route('admin.categorias.create') }}" class="btn btn-primary mt-2">
                                    <i class=" ri-add-line me-1"></i>
                                    Crear Categoría
                                </a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="card-footer border-top">
            {{ $categorias->links('livewire.pagination') }}
        </div>
    </div>
</div>
