<div>
    <div class="card">
        <div class="card-header border-bottom">
            <h5 class="card-title">Crear Nueva Categoría</h5>
            <p class="card-subtitle mb-0">Completa el formulario para registrar una nueva categoría</p>
        </div>
        <div class="card-body">
            <form wire:submit="save">
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Nombre <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('nombre') is-invalid @enderror"
                                   wire:model="nombre" placeholder="Ej: Electrónicos">
                            @error('nombre')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Estado</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="activo" wire:model="activo">
                                <label class="form-check-label" for="activo">
                                    {{ $activo ? 'Activo' : 'Inactivo' }}
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Descripción</label>
                    <textarea class="form-control @error('descripcion') is-invalid @enderror"
                              wire:model="descripcion" rows="3" placeholder="Descripción de la categoría"></textarea>
                    @error('descripcion')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.categorias.index') }}" class="btn btn-label-secondary">
                        <i class=" ri-circle-line  me-1"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class=" ri-circle-line  me-1"></i> Guardar Categoría
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
