<div>
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">Detalle de Caja - {{ format_date($caja->fecha) }}</h5>
                            <p class="mb-0">
                                Estado:
                                @if($caja->estado === 'abierta')
                                    <span class="badge bg-success">Abierta</span>
                                @else
                                    <span class="badge bg-secondary">Cerrada</span>
                                @endif
                            </p>
                        </div>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-success" wire:click="exportarExcel">
                                <i class="ri-file-excel-line "></i> Exportar Excel
                            </button>
                            @if($caja->estado === 'abierta')
                                @can('edit cajas')
                                <button type="button" class="btn btn-warning" wire:click="abrirModalCerrar">
                                    <i class="ri-lock-line "></i> Cerrar Caja
                                </button>
                                @endcan
                            @endif
                            <a href="{{ route('admin.cajas.index') }}" class="btn btn-secondary">
                                <i class="ri-arrow-go-back-line "></i> Volver
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumen General -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Monto Inicial</h6>
                            <h3 class="mb-0">
                                <x-dual-currency :amount="$caja->monto_inicial" />
                            </h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class="ri-money-dollar-circle-line  text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Ingresos</h6>
                            <h3 class="mb-0">
                                <x-dual-currency :amount="$caja->total_ingresos" />
                            </h3>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="ri-trending-up-line  text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Monto Final</h6>
                            <h3 class="mb-0">
                                <x-dual-currency :amount="$caja->monto_final" />
                            </h3>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="ri-money-cny-box-line  text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Pagos</h6>
                            <h3 class="mb-0">{{ $caja->pedidoPagos->count() }}</h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="ri-bill-line  text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Resumen por Método de Pago -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="card-title mb-0">Resumen por Método de Pago</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Método</th>
                                    <th class="text-end">Cantidad</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($this->resumenPorMetodo as $metodo)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @php
                                                    $iconClass = match($metodo->metodo_pago) {
                                                        'efectivo' => 'ri-money-dollar-circle-line text-success',
                                                        'transferencia' => 'ri-bank-line text-info',
                                                        'tarjeta' => 'ri-bank-card-line text-primary',
                                                        'pago_movil' => 'ri-smartphone-line text-warning',
                                                        'punto_de_venta' => 'ri-calculator-line text-secondary',
                                                        default => 'ri-question-line text-muted'
                                                    };
                                                @endphp
                                                <i class="{{ $iconClass }} me-2"></i>
                                                {{ ucfirst($metodo->metodo_pago) }}
                                            </div>
                                        </td>
                                        <td class="text-end">{{ $metodo->cantidad }}</td>
                                        <td class="text-end fw-semibold">
                                            <x-dual-currency :amount="$metodo->total" class="fw-semibold" />
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center text-muted">No hay pagos registrados</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resumen por Concepto -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="card-title mb-0">Resumen por Concepto</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Concepto</th>
                                    <th class="text-end">Cantidad</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($this->resumenPorConcepto as $concepto)
                                    <tr>
                                        <td>{{ $concepto['concepto'] }}</td>
                                        <td class="text-end">{{ $concepto['cantidad'] }}</td>
                                        <td class="text-end fw-semibold"><x-dual-currency :amount="$concepto['total']" /></td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center text-muted">No hay conceptos registrados</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('styles')
<style>
    .hover-lift {
        transition: all 0.2s ease-in-out;
    }
    .hover-lift:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        background-color: #f8f9fa;
    }
    .table > tbody > tr.hover-lift > td {
        border-top: 1px solid #e9ecef;
        border-bottom: 1px solid #e9ecef;
    }
    .badge {
        font-size: 0.75em;
        padding: 0.35em 0.65em;
    }
</style>
@endpush

<!-- Detalle de Pagos -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Detalle de Pagos</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 15%"># Pedido</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 35%">Cliente</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 25%">Métodos de Pago</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small text-end" style="width: 15%">Total</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small text-center" style="width: 10%">Hora</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    // Obtener pedidos únicos que tienen pagos en esta caja
                                    // Mostrar pagos de pedidos confirmados (estado = 'pagado' o 'entregado')
                                    $pedidosPagados = $caja->pedidoPagos()
                                        ->whereHas('pedido', function($query) {
                                            $query->whereIn('estado', ['pagado', 'entregado']);
                                        })
                                        ->get()
                                        ->groupBy('pedidoId')
                                        ->map(function ($pagos) {
                                            $pedido = $pagos->first()->pedido;
                                            $primerPago = $pagos->first();
                                            return [
                                                'pedido' => $pedido,
                                                'total_pagado' => $pagos->sum('total_usd'),
                                                'fecha_pago' => $primerPago->created_at,
                                                'metodos_pago' => $pagos->pluck('metodo_pago')->unique()->values()
                                            ];
                                        })->sortByDesc('fecha_pago');
                                @endphp
                                @forelse($pedidosPagados as $data)
                                    @php
                                        $pedido = $data['pedido'];
                                        $cliente = $pedido ? $pedido->user : null;
                                    @endphp
                                    <tr class="hover-lift">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                    <i class="ri-shopping-bag-3-line text-primary fs-4"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-bold text-primary fs-6">#{{ $pedido->id ?? 'N/A' }}</div>
                                                    <small class="text-muted">{{ $data['fecha_pago']->format('d/m/y') }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-2">
                                                    <i class="ri-user-line text-secondary "></i>
                                                </div>
                                                <div>
                                                    @if($cliente)
                                                        <div class="fw-semibold">{{ $cliente->name ?? 'Cliente' }}</div>
                                                        <small class="text-muted d-block">{{ $cliente->telefono ?? $cliente->email ?? '' }}</small>
                                                    @else
                                                        <div>Cliente</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                @foreach($data['metodos_pago'] as $metodo)
                                                    @php
                                                        $iconClass = match($metodo) {
                                                            'efectivo' => 'ri-money-dollar-circle-line text-success',
                                                            'transferencia' => 'ri-bank-line text-info',
                                                            'pago_movil' => 'ri-smartphone-line text-primary',
                                                            'tarjeta' => 'ri-bank-card-line text-warning',
                                                            'punto_de_venta' => 'ri-calculator-line text-secondary',
                                                            default => 'ri-question-line text-muted'
                                                        };
                                                        $badgeClass = match($metodo) {
                                                            'efectivo' => 'bg-success bg-opacity-10 text-success border border-success border-opacity-25',
                                                            'transferencia' => 'bg-info bg-opacity-10 text-info border border-info border-opacity-25',
                                                            'pago_movil' => 'bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25',
                                                            'tarjeta' => 'bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25',
                                                            'punto_de_venta' => 'bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25',
                                                            default => 'bg-light text-dark'
                                                        };
                                                    @endphp
                                                    <span class="badge {{ $badgeClass }} d-inline-flex align-items-center px-2 py-1">
                                                        <i class="{{ $iconClass }} me-1"></i>
                                                        {{ ucfirst(str_replace('_', ' ', $metodo)) }}
                                                    </span>
                                                @endforeach
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <div class="fw-bold  text-dark">$<x-dual-currency :amount="$data['total_pagado']" /></div>
                                        </td>
                                        <td class="text-center">
                                            <div class="text-muted">
                                                <i class="ri-time-line"></i>
                                                <div class="small">{{ $data['fecha_pago']->format('H:i') }}</div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="ri-inbox-unarchive-line fs-1"></i>
                                                <p class="mt-2 mb-0">No hay pedidos pagados en esta caja</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cerrar Caja -->
    @if($showCerrarModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cerrar Caja</h5>
                    <button type="button" class="btn-close" wire:click="$set('showCerrarModal', false)"></button>
                </div>
                <form wire:submit="cerrarCaja">
                    <div class="modal-body">
                        <div class="alert alert-warning">
                            <i class="ri-alert-line  me-2"></i>
                            <strong>¿Estás seguro de cerrar la caja?</strong><br>
                            Una vez cerrada no se podrán agregar más pagos a esta caja.
                        </div>

                        <div class="row mb-3">
                            <div class="col-6">
                                <label class="form-label">Monto Final Calculado:</label>
                                <div class="fw-bold text-success"><x-dual-currency :amount="$caja->monto_final" /></div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Total Ingresos:</label>
                                <div class="fw-bold text-primary"><x-dual-currency :amount="$caja->total_ingresos" /></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Observaciones de Cierre</label>
                            <textarea class="form-control" wire:model="observaciones_cierre" rows="3"
                                      placeholder="Observaciones sobre el cierre de caja..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showCerrarModal', false)">
                            Cancelar
                        </button>
                        <button type="submit" class="btn btn-warning">
                            <i class="ri-lock-line "></i> Cerrar Caja
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>
