<div class="card shadow-sm">
    <div class="card-header bg-gradient-primary text-white">
        <div class="d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-robot me-2"></i>
                Estado de Automatización
            </h6>
            <div class="d-flex gap-2">
                <button wire:click="actualizarDatos" class="btn btn-sm btn-outline-light" 
                        wire:loading.attr="disabled">
                    <i class="fas fa-sync-alt" wire:loading.remove></i>
                    <i class="fas fa-spinner fa-spin" wire:loading></i>
                </button>
                <button class="btn btn-sm btn-outline-light" type="button" data-bs-toggle="collapse" 
                        data-bs-target="#cajatasa-collapse" aria-expanded="false">
                    <i class="fas fa-chevron-down"></i>
                </button>
            </div>
        </div>
    </div>
    
    <div class="collapse show" id="cajatasa-collapse">
        <div class="card-body">
            <!-- Estado de Tasa -->
            <div class="mb-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="text-muted">Tasa del Día:</span>
                    @if($tasaHoy)
                        <span class="badge bg-success">
                            <i class="fas fa-check me-1"></i>
                            ${{ number_format($tasaHoy->usd_rate, 2) }}
                        </span>
                    @else
                        <span class="badge bg-danger">
                            <i class="fas fa-exclamation me-1"></i>
                            Sin registrar
                        </span>
                    @endif
                </div>
                
                @if($tasaHoy)
                    <small class="text-muted">
                        <i class="fas fa-clock me-1"></i>
                        Actualizada hace {{ $tasaHoy->fetch_time->diffForHumans() }}
                    </small>
                @endif
            </div>

            <!-- Estado de Cajas -->
            <div class="mb-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="text-muted">Cajas Abiertas:</span>
                    <span class="badge {{ $cajasAbiertas > 0 ? 'bg-success' : 'bg-warning' }}">
                        {{ $cajasAbiertas }}
                    </span>
                </div>
            </div>

            <!-- Próximo Corte -->
            @if($proximoCorte)
                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span class="text-muted">Próximo Corte:</span>
                        <span class="badge bg-info">
                            {{ $proximoCorte->format('H:i') }}
                        </span>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-hourglass-half me-1"></i>
                        En {{ $tiempoProximoCorte }}
                    </small>
                </div>
            @endif

            <!-- Estado de Verificación -->
            <div class="mb-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="text-muted">Verificación Tasa:</span>
                    @if($estadoVerificacion)
                        <span class="badge bg-primary">
                            <i class="fas fa-search me-1"></i>
                            Activa
                        </span>
                    @else
                        <span class="badge bg-secondary">
                            <i class="fas fa-pause me-1"></i>
                            Inactiva
                        </span>
                    @endif
                </div>
                <small class="text-muted">00:00 - 14:00</small>
            </div>

            <!-- Estado de Actualización -->
            @if($estadoActualizacion)
                <div class="alert alert-warning alert-sm mb-3">
                    <i class="fas fa-clock me-1"></i>
                    <strong>Es hora de actualizar la tasa</strong>
                </div>
            @endif
        </div>
        
        <div class="card-footer bg-light">
            <div class="row g-2">
                <div class="col-6">
                    <button wire:click="ejecutarActualizacionTasa" 
                            class="btn btn-primary btn-sm w-100"
                            wire:loading.attr="disabled">
                        <i class="fas fa-dollar-sign me-1"></i>
                        Actualizar Tasa
                    </button>
                </div>
                <div class="col-6">
                    <button wire:click="ejecutarCorteCaja" 
                            class="btn btn-success btn-sm w-100"
                            wire:loading.attr="disabled">
                        <i class="fas fa-cut me-1"></i>
                        Corte Caja
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Mensajes de Flash -->
    @if(session()->has('message'))
        <div class="alert alert-{{ session('message-type', 'info') }} alert-sm mt-2 mb-0">
            <i class="fas fa-info-circle me-1"></i>
            {{ session('message') }}
        </div>
    @endif
</div>

<style>
.alert-sm {
    padding: 0.5rem 0.75rem;
    font-size: 0.875rem;
}
</style>