<div>
    <!-- Statistics Section -->
    @if($showStats && $stats)
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-bottom d-flex justify-content-between align-items-center">
                    <h6 class="mb-0"><i class="ri-bar-chart-line me-2"></i>Estadísticas de Actividad</h6>
                    <button class="btn btn-sm btn-outline-secondary" wire:click="toggleStats">
                        <i class="ri-eye-off-line"></i>
                    </button>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <div class="text-center p-3 border rounded">
                                <h4 class="text-primary mb-1">{{ number_format($stats['total']) }}</h4>
                                <p class="text-muted mb-0">Total Actividades</p>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="text-center p-3 border rounded">
                                <h4 class="text-success mb-1">{{ $stats['by_action']->get('created', 0) }}</h4>
                                <p class="text-muted mb-0">Creaciones</p>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="text-center p-3 border rounded">
                                <h4 class="text-warning mb-1">{{ $stats['by_action']->get('updated', 0) }}</h4>
                                <p class="text-muted mb-0">Actualizaciones</p>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="text-center p-3 border rounded">
                                <h4 class="text-danger mb-1">{{ $stats['by_action']->get('deleted', 0) }}</h4>
                                <p class="text-muted mb-0">Eliminaciones</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1"><i class="ri-history-line me-2"></i>Registro de Actividades</h5>
                            <p class="mb-0 text-muted">Seguimiento completo de acciones del sistema</p>
                        </div>
                        <div class="d-flex gap-2">
                            @if(!$showStats)
                            <button class="btn btn-outline-primary btn-sm" wire:click="toggleStats">
                                <i class="ri-bar-chart-line"></i> Estadísticas
                            </button>
                            @endif
                            <button class="btn btn-primary btn-sm" wire:click="export">
                                <i class="ri-download-line"></i> Exportar
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Enhanced Filters -->
                <div class="card-body border-bottom">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label fw-medium">Buscar</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-search-line"></i></span>
                                <input type="text" class="form-control" placeholder="Usuario, acción, elemento..."
                                       wire:model.live.debounce.300ms="search">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label fw-medium">Usuario</label>
                            <select class="form-select" wire:model.live="userFilter">
                                <option value="">Todos</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label fw-medium">Acción</label>
                            <select class="form-select" wire:model.live="actionFilter">
                                <option value="">Todas</option>
                                @foreach($actions as $action)
                                    <option value="{{ $action }}">{{ ucfirst($action) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label fw-medium">Elemento</label>
                            <select class="form-select" wire:model.live="subjectFilter">
                                <option value="">Todos</option>
                                @foreach($subjects as $subject)
                                    <option value="{{ $subject }}">{{ class_basename($subject) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label fw-medium">Período</label>
                            <select class="form-select" wire:model.live="dateRange">
                                <option value="">Todo</option>
                                <option value="today">Hoy</option>
                                <option value="yesterday">Ayer</option>
                                <option value="week">Esta semana</option>
                                <option value="last_week">Semana pasada</option>
                                <option value="month">Este mes</option>
                                <option value="last_month">Mes pasado</option>
                            </select>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="button" class="btn btn-outline-secondary w-100" wire:click="clearFilters" title="Limpiar filtros">
                                <i class="ri-filter-off-line"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Active Filters Display -->
                    @if($search || $userFilter || $actionFilter || $subjectFilter || $dateRange)
                    <div class="mt-3 d-flex flex-wrap gap-2">
                        <small class="text-muted me-2">Filtros activos:</small>
                        @if($search)
                            <span class="badge bg-light text-dark">Búsqueda: {{ $search }}</span>
                        @endif
                        @if($userFilter)
                            <span class="badge bg-light text-dark">Usuario: {{ $users->find($userFilter)?->name }}</span>
                        @endif
                        @if($actionFilter)
                            <span class="badge bg-light text-dark">Acción: {{ ucfirst($actionFilter) }}</span>
                        @endif
                        @if($subjectFilter)
                            <span class="badge bg-light text-dark">Elemento: {{ class_basename($subjectFilter) }}</span>
                        @endif
                        @if($dateRange)
                            <span class="badge bg-light text-dark">Período: {{ ucfirst(str_replace('_', ' ', $dateRange)) }}</span>
                        @endif
                    </div>
                    @endif
                </div>

                <div class="card-body p-0">
                    <!-- Results Info -->
                    <div class="px-3 py-2 bg-light border-bottom d-flex justify-content-between align-items-center">
                        <small class="text-muted">
                            Mostrando {{ $activities->count() }} de {{ number_format($activities->total()) }} registros
                        </small>
                        <div class="d-flex align-items-center gap-2">
                            <small class="text-muted">Por página:</small>
                            <select class="form-select form-select-sm" style="width: auto;" wire:model.live="perPage">
                                <option value="10">10</option>
                                <option value="15">15</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                            </select>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-0">Fecha y Hora</th>
                                    <th class="border-0">Usuario</th>
                                    <th class="border-0">Acción</th>
                                    <th class="border-0">Elemento</th>
                                    <th class="border-0 text-center">Detalles</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activities as $activity)
                                    <tr class="align-middle">
                                        <td>
                                            <div class="fw-medium">{{ $activity->created_at->format('d/m/Y') }}</div>
                                            <small class="text-muted">{{ $activity->created_at->format('H:i:s') }}</small>
                                        </td>
                                        <td>
                                            @if($activity->causer)
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <span class="avatar-initial rounded-circle bg-primary text-white">
                                                            {{ substr($activity->causer->name, 0, 1) }}
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium">{{ $activity->causer->name }}</div>
                                                        <small class="text-muted">{{ $activity->causer->email }}</small>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <span class="avatar-initial rounded-circle bg-secondary text-white">
                                                            <i class="ri-robot-line"></i>
                                                        </span>
                                                    </div>
                                                    <span class="fw-medium">Sistema</span>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $this->getActionColor($activity->description) }} d-flex align-items-center gap-1" style="width: fit-content;">
                                                <i class="{{ $this->getActionIcon($activity->description) }}"></i>
                                                {{ ucfirst($activity->description) }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($activity->subject)
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-xs me-2">
                                                        <span class="avatar-initial rounded bg-light text-dark">
                                                            <i class="ri-file-line"></i>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <div class="fw-medium">{{ class_basename($activity->subject_type) }}</div>
                                                        <small class="text-muted">
                                                            @if(isset($activity->subject->name))
                                                                {{ Str::limit($activity->subject->name, 30) }}
                                                            @elseif(isset($activity->subject->nombres))
                                                                {{ Str::limit($activity->subject->nombres, 30) }}
                                                            @elseif(isset($activity->subject->razon_social))
                                                                {{ Str::limit($activity->subject->razon_social, 30) }}
                                                            @elseif(isset($activity->subject->codigo))
                                                                #{{ $activity->subject->codigo }}
                                                            @else
                                                                ID: {{ $activity->subject_id }}
                                                            @endif
                                                        </small>
                                                    </div>
                                                </div>
                                            @else
                                                <span class="text-muted"><i class="ri-question-line me-1"></i>No especificado</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if($activity->properties->count() > 0)
                                                <button class="btn btn-sm btn-outline-primary rounded-pill"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#activityDetailsModal{{ $activity->id }}"
                                                        title="Ver detalles">
                                                    <i class="ri-eye-line"></i>
                                                </button>

                                                <!-- Modal de detalles -->
                                                <div class="modal fade" id="activityDetailsModal{{ $activity->id }}" tabindex="-1">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Detalles de Actividad</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col-12 mb-3">
                                                                        <h6>Cambios realizados:</h6>
                                                                        @if($activity->properties->has('attributes'))
                                                                            <div class="table-responsive">
                                                                                <table class="table table-bordered">
                                                                                    <thead>
                                                                                        <tr>
                                                                                            <th>Campo</th>
                                                                                            <th>Valor</th>
                                                                                            @if($activity->properties->has('old'))
                                                                                                <th>Valor anterior</th>
                                                                                            @endif
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        @foreach($activity->properties['attributes'] as $key => $value)
                                                                                            <tr>
                                                                                                <td>{{ $key }}</td>
                                                                                                <td>
                                                                                                    @if(is_array($value))
                                                                                                        <pre class="mb-0">{{ json_encode($value, JSON_PRETTY_PRINT) }}</pre>
                                                                                                    @else
                                                                                                        {{ $value }}
                                                                                                    @endif
                                                                                                </td>
                                                                                                @if($activity->properties->has('old'))
                                                                                                    <td>
                                                                                                        @if(isset($activity->properties['old'][$key]))
                                                                                                            @if(is_array($activity->properties['old'][$key]))
                                                                                                                <pre class="mb-0">{{ json_encode($activity->properties['old'][$key], JSON_PRETTY_PRINT) }}</pre>
                                                                                                            @else
                                                                                                                {{ $activity->properties['old'][$key] }}
                                                                                                            @endif
                                                                                                        @else
                                                                                                            <span class="text-muted">No existía</span>
                                                                                                        @endif
                                                                                                    </td>
                                                                                                @endif
                                                                                            </tr>
                                                                                        @endforeach
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        @else
                                                                            <p class="text-muted">No hay cambios registrados</p>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                                    Cerrar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                <span class="text-muted"><i class="ri-subtract-line"></i></span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-5">
                                            <div class="text-muted">
                                                <i class="ri-history-line ri-3x mb-3 d-block"></i>
                                                <h6>No se encontraron actividades</h6>
                                                <p class="mb-0">Intenta ajustar los filtros de búsqueda</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if($activities->hasPages())
                <div class="card-footer bg-transparent border-top">
                   {{ $activities->links('livewire.pagination') }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('livewire:init', function () {
        // Escuchar eventos de Livewire para mostrar notificaciones
        Livewire.on('activityDeleted', function () {
            toastr.success('Actividad eliminada correctamente');
        });
    });
</script>
@endpush
