<div>
    <section id="ecommerce-header">
        <div class="row">
            <div class="col-sm-12">
                <div class="ecommerce-header-items">
                    <div class="result-toggler">
                        <button class="navbar-toggler shop-sidebar-toggler" type="button" data-bs-toggle="collapse">
                            <span wire:ignore class="navbar-toggler-icon d-block d-lg-none"><i data-feather="menu"></iconify-icon></span>
                        </button>
                        <div class="search-results">{{ count($productos) }} resultados encontrados</div>
                    </div>
                    <div class="result-toggler">
                        @auth
                        <div class="btn-group">
                            <a class="btn btn-info" href="{{ route('wishlist.index') }}">Favoritos</a>
                            <a class="btn btn-primary" href="{{ route('cart.index') }}">Ver carrito</a>
                        </div>
                            @else
                            <div class="btn-group">
                                <a data-bs-toggle="modal" data-bs-target="#registerUser" class="btn btn-info btn-wishlist">

                                    <span>Registrarse</span>
                                    </a>
                                    <a  data-bs-toggle="modal" data-bs-target="#loginUser" class="btn btn-primary btn-cart">

                                        <span class="add-to-cart">Iniciar sesión</span>
                                    </a>
                            </div>
                        @endauth
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- E-commerce Content Section Starts -->

    <!-- background Overlay when sidebar is shown  starts-->
    <div class="body-content-overlay"></div>
    <!-- background Overlay when sidebar is shown  ends-->

    <!-- E-commerce Search Bar Starts -->
    <section id="ecommerce-searchbar" class="ecommerce-searchbar">
        <div class="row mt-1">
            <div class="col-sm-12">
                <div class="input-group input-group-merge">
                    <input type="text" class="form-control search-product" wire:model.live='search' id="shop-search" placeholder="Search Product" aria-label="Search..." aria-describedby="shop-search" />
                    <span wire:ignore class="input-group-text"><i data-feather="search" class="text-muted"></iconify-icon></span>
                </div>
            </div>
        </div>
    </section>
    <!-- E-commerce Search Bar Ends -->

    <!-- E-commerce Products Starts -->
    <section id="ecommerce-products" class="grid-view">
        @foreach ($productos as $item)
        <div class="card ecommerce-card">
            <div class="item-img text-center">
                <a>
                    <img class="img-fluid card-img-top" style="width: 50%" src="/media/producto/{{ $item->image->path }}" alt="img-placeholder"  /></a>
            </div>
            <div class="card-body">
                <div class="item-wrapper">
                    <div>
                        <h6 class="item-price">{{ money($item->price) }}</h6>
                        @if($item->precio_bs)
                            <small class="text-muted">{{ moneyBS($item->precio_bs) }}</small>
                        @endif
                    </div>
                </div>
                <h6 class="item-name">
                    <a class="text-body">{{ $item->name }}</a>
                    <span class="card-text item-company">By <a href="#" class="company-name">{{ $item->categoria->name }}</a></span>
                </h6>
                <p class="card-text item-description">
                   {{ $item->description }}
                </p>
            </div>
            <div class="item-options text-center">
                <div class="item-wrapper">
                    <div class="item-cost">
                        <h4 class="item-price">{{ money($item->price) }}</h4>
                        @if($item->precio_bs)
                            <p class="text-muted mb-0">{{ moneyBS($item->precio_bs) }}</p>
                        @endif
                    </div>
                </div>
               @auth
               <a wire:click='addWishlist({{ $item->id }})' class="btn btn-light btn-wishlist">
                @if (\App\Models\Wishlist::where('producto_id',$item->id)->first() != null)
                <span wire:ignore><i data-feather="heart" class="text-danger"></iconify-icon></span>
                @else
                <span wire:ignore><i data-feather="heart" ></iconify-icon></span>
                @endif
                <span>Agregar a favoritos</span>
                </a>
                <a  wire:click='addCart({{ $item->id }})' class="btn btn-primary btn-cart">
                    <span wire:ignore><i data-feather="shopping-cart" ></iconify-icon></span>
                    <span class="add-to-cart">Añadir al carrito</span>
                </a>
                @else


               @endauth
            </div>
        </div>
        @endforeach
    </section>
    <!-- / add authentication sms modal-->
    <!-- Edit User Modal -->
    @include('layouts.front.modals.data')
</div>
