<!-- Mobile Menu Offcanvas -->
<div class="offcanvas offcanvas-start" tabindex="-1" id="mobileMenuOffcanvas" aria-labelledby="mobileMenuLabel">
    <div class="offcanvas-header border-bottom">
        <div class="d-flex align-items-center">
            <img src="/materialize/assets/img/logo/logo.png" alt="logo" height="40">

        </div>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!-- User Info (if logged in) -->
        @auth
        <div class="p-3 bg-soft-primary border-bottom">
            <div class="d-flex align-items-center">
                <div class="avatar-sm me-3">
                    <span class="avatar-title bg-primary rounded-circle fs-16">
                        {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                    </span>
                </div>
                <div>
                    <h6 class="mb-0 fw-semibold">{{ Auth::user()->name }}</h6>
                    <p class="mb-0 text-muted fs-12">{{ Auth::user()->email ?? 'Cliente' }}</p>
                </div>
            </div>
        </div>
        @endauth

        <!-- Navigation Links -->
        <div class="p-3">
            <h6 class="text-uppercase text-muted fs-11 mb-3">
                <i class="ri-menu-line me-1"></i>Navegación
            </h6>
            <ul class="list-unstyled mb-0">
                <li>
                    <a href="/" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-primary text-primary rounded-circle">
                                <i class="ri-home-4-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Inicio</h6>
                            <small class="text-muted">Página principal</small>
                        </div>
                        <i class="ri-arrow-right-s-line text-muted"></i>
                    </a>
                </li>
                <li>
                    <a href="#productos" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item" data-bs-dismiss="offcanvas">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-success text-success rounded-circle">
                                <i class="ri-store-2-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Productos</h6>
                            <small class="text-muted">Ver catálogo completo</small>
                        </div>
                        <i class="ri-arrow-right-s-line text-muted"></i>
                    </a>
                </li>
            </ul>
        </div>

        @auth
        <!-- User Actions -->
        <div class="p-3 border-top">
            <h6 class="text-uppercase text-muted fs-11 mb-3">
                <i class="ri-shopping-bag-line me-1"></i>Mi Cuenta
            </h6>
            <ul class="list-unstyled mb-0">
                <li>
                    <a href="/front/cart" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-warning text-warning rounded-circle">
                                <i class="ri-shopping-cart-2-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Carrito de Compras</h6>
                            <small class="text-muted">Ver productos agregados</small>
                        </div>
                        <span class="badge bg-warning rounded-pill" id="mobile-cart-count">0</span>
                    </a>
                </li>
                <li>
                    <a href="/front/wishlist" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-danger text-danger rounded-circle">
                                <i class="ri-heart-3-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Mis Favoritos</h6>
                            <small class="text-muted">Productos guardados</small>
                        </div>
                        <span class="badge bg-danger rounded-pill" id="mobile-wishlist-count">0</span>
                    </a>
                </li>
                <li>
                    <a href="/front/pedido/historico" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-info text-info rounded-circle">
                                <i class="ri-file-list-3-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Mis Pedidos</h6>
                            <small class="text-muted">Historial de compras</small>
                        </div>
                        <i class="ri-arrow-right-s-line text-muted"></i>
                    </a>
                </li>
                <li>
                    <a href="/front/perfil" class="d-flex align-items-center p-3 rounded-2 text-body text-decoration-none mobile-menu-item">
                        <div class="avatar-xs me-3">
                            <span class="avatar-title bg-soft-secondary text-secondary rounded-circle">
                                <i class="ri-user-settings-line fs-16"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Mi Perfil</h6>
                            <small class="text-muted">Configuración de cuenta</small>
                        </div>
                        <i class="ri-arrow-right-s-line text-muted"></i>
                    </a>
                </li>
            </ul>
        </div>

        <!-- Logout -->
        <div class="p-3 border-top">
            <a href="/logout" onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();"
               class="d-flex align-items-center p-3 rounded-2 text-danger text-decoration-none mobile-menu-item bg-soft-danger">
                <div class="avatar-xs me-3">
                    <span class="avatar-title bg-danger text-white rounded-circle">
                        <i class="ri-logout-box-r-line fs-16"></i>
                    </span>
                </div>
                <div class="flex-grow-1">
                    <h6 class="mb-0 text-danger">Cerrar Sesión</h6>
                    <small class="text-danger opacity-75">Salir de mi cuenta</small>
                </div>
            </a>
        </div>
        @else
        <!-- Guest Actions -->
        <div class="p-3 border-top">
            <h6 class="text-uppercase text-muted fs-11 mb-3">
                <i class="ri-user-line me-1"></i>Cuenta
            </h6>
            <div class="d-grid gap-2">
                <button class="btn btn-primary btn-lg rounded-pill" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft" data-bs-dismiss="offcanvas">
                    <i class="ri-login-box-line me-2"></i>Iniciar Sesión
                </button>
                <button class="btn btn-outline-primary btn-lg rounded-pill" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" data-bs-dismiss="offcanvas">
                    <i class="ri-user-add-line me-2"></i>Registrarse
                </button>
            </div>
            <p class="text-center text-muted mt-3 mb-0">
                <small>¿Ya tienes cuenta? Inicia sesión para acceder a todas las funciones.</small>
            </p>
        </div>
        @endauth
    </div>
</div>

<!-- Main Navbar -->
<nav class="navbar navbar-expand-lg navbar-landing fixed-top" id="navbar">
    <div class="container">
        <!-- Mobile Menu Toggle -->
        <button class="navbar-toggler border-0 p-2 d-lg-none" type="button"
                data-bs-toggle="offcanvas" data-bs-target="#mobileMenuOffcanvas"
                aria-controls="mobileMenuOffcanvas" aria-label="Toggle navigation">
            <i class="ri-menu-line fs-22"></i>
        </button>

        <!-- Logo -->
        <a class="navbar-brand" href="/">
            <img src="/materialize/assets/img/logo/logo.png" class="card-logo card-logo-dark" alt="logo dark" height="45">

        </a>

        <!-- Mobile Quick Actions -->
        <div class="d-flex align-items-center gap-2 d-lg-none">
            @auth
            <!-- Mobile Cart Icon -->
             @livewire('front.mini-cart')
            <!-- Mobile Wishlist Icon -->
             @livewire('front.mini-wishlist')
            @else
            <button class="btn btn-primary btn-sm rounded-pill px-3" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft">
                <i class="ri-login-box-line"></i>
            </button>
            @endauth
        </div>

        <!-- Desktop Navigation -->
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Navigation Links -->
            <ul class="navbar-nav mx-auto mt-2 mt-lg-0">

            </ul>

            <!-- Search Bar with Dropdown -->


            <!-- Right Side Icons (Desktop) -->
            <div class="d-flex align-items-center gap-2">
                @if (Auth::check())
                    <!-- Mini Wishlist -->
                    <div class="topbar-head-dropdown">
                        @livewire('front.mini-wishlist')
                    </div>

                    <!-- Mini Carrito -->
                    <div class="topbar-head-dropdown">
                        @livewire('front.mini-cart')
                    </div>

                    <!-- User Dropdown - Velzon Style -->
                    <div class="dropdown ms-2">
                        <button type="button" class=" btn shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <div class="avatar-sm me-3">
                        <span class="avatar-title bg-info rounded-circle fs-16">
                            {{ Auth::user()->initials }}
                        </span>
                   </div>
                    </button>
                        <div class="dropdown-menu dropdown-menu-end shadow-lg border-0 rounded-3" style="min-width: 220px;">
                            <!-- User Info Header -->
                            <div class="p-3 border-bottom bg-soft-primary rounded-top">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm me-3">
                                         <span class="avatar-title bg-info rounded-circle fs-16">
                                            {{ Auth::user()->initials }}
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-0 fw-semibold">{{ Auth::user()->name }}</h6>
                                        <p class="mb-0 text-muted fs-12">{{ Auth::user()->email ?? 'Cliente' }}</p>
                                    </div>
                                </div>
                            </div>
                            <!-- Menu Items -->
                            <div class="p-2">
                                <a class="dropdown-item rounded-2 py-2" href="/front/wishlist">
                                    <i class="ri-heart-3-line fs-16 align-middle me-2 text-danger"></i>
                                    <span class="align-middle">Mis favoritos</span>
                                </a>
                                <a class="dropdown-item rounded-2 py-2" href="/front/pedido/historico">
                                    <i class="ri-shopping-bag-3-line fs-16 align-middle me-2 text-primary"></i>
                                    <span class="align-middle">Mis pedidos</span>
                                </a>
                                <a class="dropdown-item rounded-2 py-2" href="/front/perfil">
                                    <i class="ri-user-settings-line fs-16 align-middle me-2 text-info"></i>
                                    <span class="align-middle">Mi perfil</span>
                                </a>
                            </div>
                            <div class="p-2 border-top">
                                <a class="dropdown-item rounded-2 py-2 text-danger" href="/logout"
                                   onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();">
                                    <i class="ri-logout-box-r-line fs-16 align-middle me-2"></i>
                                    <span class="align-middle">Cerrar sesión</span>
                                </a>
                            </div>
                        </div>
                    </div>
                @else
                    <!-- Login/Register Buttons - Velzon Style -->
                    <button class="btn btn-soft-primary btn-sm rounded-pill px-3" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft">
                        <i class="ri-login-box-line me-1 align-middle"></i>
                        <span class="align-middle">Ingresar</span>
                    </button>
                    <button class="btn btn-primary btn-sm rounded-pill px-3" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight">
                        <i class="ri-user-add-line me-1 align-middle"></i>
                        <span class="align-middle">Registrarse</span>
                    </button>
                @endif
            </div>
        </div>
    </div>
</nav>

<!-- Logout Form (single instance) -->
@auth
<form id="logout-form-header" action="/logout" method="POST" style="display: none;">
    @csrf
</form>
@endauth

<!-- Navbar Styles & Scripts -->


<script>
document.addEventListener('DOMContentLoaded', function() {
    // Scroll Effect for Navbar
    const navbar = document.getElementById('navbar');

    function handleScroll() {
        if (window.scrollY > 50) {
            navbar.classList.add('nav-sticky');
            navbar.classList.add('scrolled');
        } else {
            navbar.classList.remove('nav-sticky');
            navbar.classList.remove('scrolled');
        }
    }

    window.addEventListener('scroll', handleScroll);
    handleScroll();

    // Search Functionality - Updated for Livewire
    const searchInput = document.getElementById('searchInput');

    if (searchInput) {
        // Keyboard Shortcut (Ctrl+K)
        document.addEventListener('keydown', function(e) {
            if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
                e.preventDefault();
                searchInput.focus();
            }
        });
    }

    // Update mobile badges from Livewire events
    window.addEventListener('cart-updated', function(event) {
        const count = event.detail?.count || 0;
        const badges = document.querySelectorAll('#mobile-cart-badge, #mobile-cart-count');
        badges.forEach(badge => {
            badge.textContent = count;
            badge.style.display = count > 0 ? 'inline-flex' : 'none';
        });
    });

    window.addEventListener('wishlist-updated', function(event) {
        const count = event.detail?.count || 0;
        const badges = document.querySelectorAll('#mobile-wishlist-badge, #mobile-wishlist-count');
        badges.forEach(badge => {
            badge.textContent = count;
            badge.style.display = count > 0 ? 'inline-flex' : 'none';
        });
    });
});
</script>
