<!doctype html>
<html lang="en" data-layout="horizontal" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<!-- Mirrored from themesbrand.com/velzon/html/master/layouts-horizontal.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 12 Aug 2024 07:46:57 GMT -->

<head>

    <meta charset="utf-8" />
    <title>{{ env('APP_NAME', 'Laravel') }} | @yield('title', '')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="/assets/images/favicon.ico">


    <!-- jsvectormap css -->
    <link href="https://themesbrand.com/velzon/html/material/assets/libs/jsvectormap/jsvectormap.min.css"
        rel="stylesheet" type="text/css" />

    <!--Swiper slider css-->
    <link href="https://themesbrand.com/velzon/html/material/assets/libs/swiper/swiper-bundle.min.css" rel="stylesheet"
        type="text/css" />

    <!-- Layout config Js -->
    <script src="https://themesbrand.com/velzon/html/material/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="https://themesbrand.com/velzon/html/material/assets/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <!-- Icons Css -->
    <link href="/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="https://themesbrand.com/velzon/html/material/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="https://themesbrand.com/velzon/html/material/assets/css/custom.min.css" rel="stylesheet"
        type="text/css" />

    @include('panel.front.css.styles')
    @livewireStyles
</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <header id="page-topbar">
            <div class="layout-width">
                <div class="navbar-header">
                    <div class="d-flex">
                        <!-- LOGO -->
                        <div class="navbar-brand-box horizontal-logo">
                            <a href="/front/store" class="logo logo-dark">
                                <img src="/assets/img/logo/footer.png" height="50" alt="">
                            </a>

                            <a href="/front/store" class=" logo-light">
                                <img src="/assets/img/logo/footer.png" height="50" alt="">
                            </a>
                        </div>

                        <button type="button"
                            class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger shadow-none"
                            id="topnav-hamburger-icon">
                            <span class="hamburger-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </span>
                        </button>


                    </div>

                    <div class="d-flex align-items-center">

                        <div class="dropdown d-md-none topbar-head-dropdown header-item">
                            <button type="button"
                                class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none"
                                id="page-header-search-dropdown" data-bs-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false">
                                <i class="bx bx-search fs-22"></iconify-icon>
                            </button>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                                aria-labelledby="page-header-search-dropdown">
                                <form class="p-3">
                                    <div class="form-group m-0">
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="Search ..."
                                                aria-label="Recipient's username">
                                            <button class="btn btn-primary" type="submit"><i class=" ri-circle-line "></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>




                        <div class="dropdown topbar-head-dropdown ms-1 header-item">
                            <button type="button"
                                class="btn btn-icon btn-topbar btn-ghost-secondary rounded-circle shadow-none"
                                id="page-header-cart-dropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside"
                                aria-haspopup="true" aria-expanded="false">
                                <i class='bx bx-shopping-bag fs-22'></iconify-icon>
                                <span
                                    class="position-absolute topbar-badge cartitem-badge fs-10 translate-middle badge rounded-pill bg-info">@livewire('front.cart.count')</span>
                            </button>
                            <div class="dropdown-menu dropdown-menu-xl dropdown-menu-end p-0 dropdown-menu-cart"
                                aria-labelledby="page-header-cart-dropdown">
                                <div class="p-3 border-top-0 border-start-0 border-end-0 border-dashed border">
                                    <div class="row align-items-center">
                                        <div class="col">
                                            <h6 class="m-0 fs-16 fw-semibold">Mi carrito de compras</h6>
                                        </div>
                                        <div class="col-auto">
                                            <span class="badge bg-warning-subtle text-warning fs-13"><span
                                                    class="cartitem-badge">@livewire('front.cart.count')</span>
                                                items</span>
                                        </div>
                                    </div>
                                </div>
                                <div data-simplebar style="max-height: 300px;">
                                    <div class="p-2">
                                        <div class="text-center empty-cart" id="empty-cart">



                                        </div>
                                        @foreach (\App\Models\Cart::getCart() as $cart)
                                            <div class="d-block dropdown-item dropdown-item-cart text-wrap px-3 py-2">
                                                <div class="d-flex align-items-center">
                                                    <img src="/media/producto/{{ $cart->associatedModel->image->path }}"
                                                        class="me-3 rounded-circle avatar-sm p-2 bg-light"
                                                        alt="user-pic">
                                                    <div class="flex-grow-1">
                                                        <h6 class="mt-0 mb-1 fs-14">
                                                            <a href="apps-ecommerce-product-details.html"
                                                                class="text-reset small">{{ $cart->name }}</a>
                                                        </h6>
                                                        <p class="mb-0 fs-12 text-muted">
                                                            Cantidad: <span>{{ $cart->quantity }} x
                                                                {{ money($cart->price) }}</span>
                                                        </p>
                                                    </div>
                                                    <div class="px-2">
                                                        <h5 class="m-0 fw-normal"><span
                                                                class="cart-item-price">{{ money($cart->quantity * $cart->price) }}</span>
                                                        </h5>
                                                    </div>
                                                    <div class="ps-2">
                                                        <button type="button"
                                                            class="btn btn-icon btn-sm btn-ghost-secondary remove-item-btn shadow-none"><i class=" ri-circle-line fs-16"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach





                                    </div>
                                </div>
                                <div class="p-3 border-bottom-0 border-start-0 border-end-0 border-dashed border"
                                    id="checkout-elem">
                                    <div class="d-flex justify-content-between align-items-center pb-3">
                                        <h5 class="m-0 text-muted">Total:</h5>
                                        <div class="px-2">
                                            <h5 class="m-0" id="cart-item-total">
                                                {{ money(\App\Models\Cart::getTotal()) }}</h5>
                                        </div>
                                    </div>

                                    <a href="apps-ecommerce-checkout.html" class="btn btn-success text-center w-100">
                                        Checkout
                                    </a>
                                </div>
                            </div>
                        </div>





                        <div>

                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- ========== App Menu ========== -->

        <!-- Left Sidebar End -->
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Pedidos</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="/front/store">Inicio</a></li>
                                        <li class="breadcrumb-item active">@yield('title', '')</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->


                    {{ $slot }}

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © Abastos los Trinis - Caracas.
                        </div>

                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->



    <!--start back-to-top-->

    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/node-waves/waves.min.js"></script>
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/feather-icons/feather.min.js"></script>
    <script src="https://themesbrand.com/velzon/html/material/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="https://themesbrand.com/velzon/html/material/assets/js/plugins.js"></script>

    <!-- apexcharts -->
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/apexcharts/apexcharts.min.js"></script>

    <!-- Vector map-->
    <script src="https://themesbrand.com/velzon/html/material/assets/libs/jsvectormap/js/jsvectormap.min.js"></script>


    <!-- Dashboard init -->
    <script src="https://themesbrand.com/velzon/html/material/assets/js/pages/dashboard-analytics.init.js"></script>

    <!-- App js -->
    <script src="https://themesbrand.com/velzon/html/material/assets/js/app.js"></script>
    @include('panel.front.js.scripts')

</body>


<!-- Mirrored from themesbrand.com/velzon/html/master/layouts-horizontal.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 12 Aug 2024 07:46:57 GMT -->

</html>
