<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">


<!-- Mirrored from themesbrand.com/velzon/html/materialhtml/master/nft-landing.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 12 Aug 2024 07:47:10 GMT -->

<head>

    <meta charset="utf-8" />
    <title>{{ env('APP_NAME', 'Laravel') }} | @yield('title', '')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- App favicon -->
    <link rel="shortcut icon" href="/materialize/assets/img/logo/logo.png">

    <!--Swiper slider css-->
    <link href="/velzon/html/material/assets/libs/swiper/swiper-bundle.min.css" rel="stylesheet"
        type="text/css" />

        <script src="{{ asset('velzon/html/material/assets/libs/swiper/swiper-bundle.min.js') }}"></script>

    <link href="/css/system.css" rel="stylesheet"
        type="text/css" />



    <!-- Remix Icons CDN -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.7.0/fonts/remixicon.css" rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="/velzon/html/material/assets/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <!-- Icons Css -->
    <link href="/materialize/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="/velzon/html/material/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- Custom Css -->

    <!-- Front Velzon Theme Css -->
    <link href="/css/front-velzon.css" rel="stylesheet" type="text/css" />

    <!-- Animate.css for animations -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    @include('panel.front.css.styles')

    <!-- Store Improvements CSS -->
    <link href="/materialize/assets/css/store-improvements.css" rel="stylesheet" type="text/css" />

    <!-- Livewire Styles -->
    @livewireStyles

    <!-- Essential Inline Styles -->
    <style>
      /* Estilos para notificaciones */
      #notification-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 10000;
      }
    </style>

    @stack('styles')

</head>

<body data-bs-spy="scroll" data-bs-target="#navbar-example">

    <!-- Begin page -->
    <div class="layout-wrapper landing">
        <!-- Header mejorado -->
        @include('layouts.front.header')
        <!-- Hero section mejorado -->
        <section id="hero" style="padding-top: 79px;">

        </section>


        <!-- start marketplace -->
        <div id="productos">
            {{ $slot }}
        </div>



        <!-- Start footer -->
        <footer class="custom-footer bg-dark py-5 position-relative">
            <div class="container">
                <div class="row gy-4">
                    <!-- Logo y descripción -->
                    <div class="col-lg-3 col-md-6">
                        <div>
                            <a href="{{ url('front/store') }}" class="d-inline-block mb-3">
                                <img src="/materialize/assets/img/logo/footer.png" height="80" alt="Logo">
                            </a>
                            <p class="text-white-50 mb-3">Te ofrecemos lo mejor al bajo costo. Nos encargamos de despacharte lo que quieras hasta la puerta de tu negocio.</p>
                            <div class="d-flex gap-2">
                                <a href="#" class="btn btn-soft-light btn-icon rounded-circle">
                                    <i class="text-primary ri ri-facebook-fill"></i>
                                </a>
                                <a href="#" class="btn btn-soft-light btn-icon rounded-circle">
                                    <i class="text-primary ri ri-instagram-fill"></i>
                                </a>
                                <a href="#" class="btn btn-soft-light btn-icon rounded-circle">
                                    <i class="text-primary ri ri-whatsapp-fill"></i>
                                </a>
                                <a href="#" class="btn btn-soft-light btn-icon rounded-circle">
                                    <i class="text-primary ri ri-twitter-x-fill"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Enlaces rápidos -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">
                            <i class="ri ri-links-line me-1"></i> Enlaces Rápidos
                        </h5>
                        <ul class="list-unstyled footer-link">
                            <li><a href="{{ url('front.index') }}"><i class="ri ri-arrow-right-s-line me-1"></i> Inicio</a></li>
                            <li><a href="{{ url('front.products') }}"><i class="ri ri-arrow-right-s-line me-1"></i> Productos</a></li>
                            <li><a href="#categorias"><i class="ri ri-arrow-right-s-line me-1"></i> Categorías</a></li>
                            <li><a href="#"><i class="ri ri-arrow-right-s-line me-1"></i> Ofertas</a></li>
                            <li><a href="#"><i class="ri ri-arrow-right-s-line me-1"></i> Nosotros</a></li>
                        </ul>
                    </div>

                    <!-- Mi cuenta -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">
                            <i class="ri ri-user-line me-1"></i> Mi Cuenta
                        </h5>
                        <ul class="list-unstyled footer-link">
                            <li><a href="{{ url('front.orders') }}"><i class="ri ri-arrow-right-s-line me-1"></i> Mis Pedidos</a></li>
                            <li><a href="{{ url('cart.index') }}"><i class="ri ri-arrow-right-s-line me-1"></i> Mi Carrito</a></li>
                            <li><a href="#"><i class="ri ri-arrow-right-s-line me-1"></i> Lista de Deseos</a></li>
                            <li><a href="#"><i class="ri ri-arrow-right-s-line me-1"></i> Mi Perfil</a></li>
                            <li><a href="#"><i class="ri ri-arrow-right-s-line me-1"></i> Ayuda</a></li>
                        </ul>
                    </div>

                    <!-- Contacto -->
                    <div class="col-lg-2 col-md-6">
                        <h5 class="text-white mb-3">
                            <i class="ri ri-customer-service-line me-1"></i> Contacto
                        </h5>
                        <ul class="list-unstyled footer-link">
                            <li class="d-flex align-items-start mb-2">
                                <i class="ri ri-map-pin-line me-2 mt-1 text-primary"></i>
                                <span class="text-white-50">Caracas, Venezuela</span>
                            </li>
                            <li class="d-flex align-items-center mb-2">
                                <i class="ri ri-phone-line me-2 text-primary"></i>
                                <span class="text-white-50">+58 412-1234567</span>
                            </li>
                            <li class="d-flex align-items-center mb-2">
                                <i class="ri ri-mail-line me-2 text-primary"></i>
                                <span class="text-white-50">info@lostrinis.com</span>
                            </li>
                            <li class="d-flex align-items-center">
                                <i class="ri ri-time-line me-2 text-primary"></i>
                                <span class="text-white-50">Lun - Sáb: 8am - 6pm</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Newsletter -->
                    <div class="col-lg-3 col-md-6">
                        <h5 class="text-white mb-3">
                            <i class="ri ri-mail-send-line me-1"></i> Newsletter
                        </h5>
                        <p class="text-white-50 mb-3">Suscríbete para recibir ofertas exclusivas y novedades.</p>
                        <form class="footer-subscribe">
                            <div class="input-group">
                                <input type="email" class="form-control" placeholder="Tu correo electrónico" aria-label="Email">
                                <button class="btn btn-primary" type="submit">
                                    <i class="ri ri-send-plane-fill"></i>
                                </button>
                            </div>
                        </form>
                        <div class="mt-4">
                            <p class="text-white-50 mb-2 fs-12">Métodos de pago aceptados:</p>
                            <div class="d-flex gap-2 flex-wrap">
                                <span class="badge bg-white text-dark p-2"><i class="ri ri-visa-fill fs-18"></i></span>
                                <span class="badge bg-white text-dark p-2"><i class="ri ri-mastercard-fill fs-18"></i></span>
                                <span class="badge bg-white text-dark p-2"><i class="ri ri-paypal-fill fs-18"></i></span>
                                <span class="badge bg-white text-dark p-2"><i class="ri ri-bank-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-line-card-fill fs-18"></i></span>
                                <span class="badge bg-white text-dark p-2"><i class="ri ri-money-dollar-circle-fill fs-18"></i></span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Divider -->
                <hr class="border-secondary my-4">

                <!-- Copyright y políticas -->
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6">
                        <p class="copy-rights mb-0 text-white-50">
                            <i class="ri ri-copyright-line"></i> {{ date('Y') }} <strong class="text-white">Abastos los Trinis</strong> - Caracas. Todos los derechos reservados.
                        </p>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <ul class="list-inline mb-0 text-md-end mt-3 mt-md-0">
                            <li class="list-inline-item">
                                <a href="#" class="text-white-50 text-decoration-underline">Políticas de Privacidad</a>
                            </li>
                            <li class="list-inline-item text-white-50">|</li>
                            <li class="list-inline-item">
                                <a href="#" class="text-white-50 text-decoration-underline">Términos y Condiciones</a>
                            </li>
                            <li class="list-inline-item text-white-50">|</li>
                            <li class="list-inline-item">
                                <a href="#" class="text-white-50 text-decoration-underline">Devoluciones</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <!-- end footer -->

        <!--start back-to-top-->
        <button onclick="topFunction()" class="btn btn-danger btn-icon landing-back-top" id="back-to-top">
            <i class=" ri ri-circle-line "></i>
        </button>
        <!--end back-to-top-->

    </div>
    <!-- end layout wrapper -->

    <!-- Contenedor de notificaciones -->
    <div id="notification-container"></div>

    <!-- JAVASCRIPT -->
    <script src="/velzon/html/material/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/velzon/html/material/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="/velzon/html/material/assets/libs/node-waves/waves.min.js"></script>
    <script src="/velzon/html/material/assets/libs/feather-icons/feather.min.js"></script>
    <script src="/velzon/html/material/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- SweetAlert2 for notifications -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Livewire Scripts -->
    @livewireScripts
    <!-- App js -->
    @include('panel.front.js.scripts')

    <!-- Toast notification handler
    <script>
        window.addEventListener('alert', event => {
            Swal.fire({
                title: event.detail.title || '',
                text: event.detail.text || '',
                icon: event.detail.icon || 'info',
                confirmButtonText: 'OK'
            });
        });


        // Manejar errores de validación de Livewire
        window.addEventListener('validation-error', event => {
            let errors = event.detail.errors;
            let errorMessage = '';

            for (let field in errors) {
                errorMessage += errors[field].join(', ') + '\n';
            }

            Swal.fire({
                title: 'Error de validación',
                text: errorMessage,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        });
    </script>
  -->


    <!-- Mapbox Configuration -->
    <script>
        window.MAPBOX_TOKEN = '{{ config("mapbox.token") }}';
        window.locationServiceConfig = {
            mapboxToken: '{{ config("mapbox.token") }}',
            defaultLanguage: '{{ config("mapbox.default_language", "es") }}'
        };
    </script>

    <!-- Navbar scroll effects -->
    <x-navbar-scroll />

    <script>
    // Navbar scroll effect
    document.addEventListener('DOMContentLoaded', function() {
        const navbar = document.getElementById('navbar');
        window.addEventListener('scroll', function() {
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });
    });
    </script>
    @stack('scripts')
</body>


<!-- Mirrored from themesbrand.com/velzon/html/materialhtml/master/nft-landing.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 12 Aug 2024 07:47:11 GMT -->

</html>
