<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
  <div class="app-brand demo">
    <a href="{{ url('/') }}" class="app-brand-link">
      <span class="app-brand-logo demo">
        <span class="text-primary">
          <svg width="32" height="18" viewBox="0 0 38 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
              d="M30.0944 2.22569C29.0511 0.444187 26.7508 -0.172113 24.9566 0.849138C23.1623 1.87039 22.5536 4.14247 23.5969 5.92397L30.5368 17.7743C31.5801 19.5558 33.8804 20.1721 35.6746 19.1509C37.4689 18.1296 38.0776 15.8575 37.0343 14.076L30.0944 2.22569Z"
              fill="currentColor" />
            <path
              d="M30.171 2.22569C29.1277 0.444187 26.8274 -0.172113 25.0332 0.849138C23.2389 1.87039 22.6302 4.14247 23.6735 5.92397L30.6134 17.7743C31.6567 19.5558 33.957 20.1721 35.7512 19.1509C37.5455 18.1296 38.1542 15.8575 37.1109 14.076L30.171 2.22569Z"
              fill="url(#paint0_linear_2989_100980)"
              fill-opacity="0.4" />
            <path
              d="M22.9676 2.22569C24.0109 0.444187 26.3112 -0.172113 28.1054 0.849138C29.8996 1.87039 30.5084 4.14247 29.4651 5.92397L22.5251 17.7743C21.4818 19.5558 19.1816 20.1721 17.3873 19.1509C15.5931 18.1296 14.9843 15.8575 16.0276 14.076L22.9676 2.22569Z"
              fill="currentColor" />
            <path
              d="M14.9558 2.22569C13.9125 0.444187 11.6122 -0.172113 9.818 0.849138C8.02377 1.87039 7.41502 4.14247 8.45833 5.92397L15.3983 17.7743C16.4416 19.5558 18.7418 20.1721 20.5361 19.1509C22.3303 18.1296 22.9391 15.8575 21.8958 14.076L14.9558 2.22569Z"
              fill="currentColor" />
            <path
              d="M14.9558 2.22569C13.9125 0.444187 11.6122 -0.172113 9.818 0.849138C8.02377 1.87039 7.41502 4.14247 8.45833 5.92397L15.3983 17.7743C16.4416 19.5558 18.7418 20.1721 20.5361 19.1509C22.3303 18.1296 22.9391 15.8575 21.8958 14.076L14.9558 2.22569Z"
              fill="url(#paint1_linear_2989_100980)"
              fill-opacity="0.4" />
            <path
              d="M7.82901 2.22569C8.87231 0.444187 11.1726 -0.172113 12.9668 0.849138C14.7611 1.87039 15.3698 4.14247 14.3265 5.92397L7.38656 17.7743C6.34325 19.5558 4.04298 20.1721 2.24875 19.1509C0.454514 18.1296 -0.154233 15.8575 0.88907 14.076L7.82901 2.22569Z"
              fill="currentColor" />
            <defs>
              <linearGradient
                id="paint0_linear_2989_100980"
                x1="5.36642"
                y1="0.849138"
                x2="10.532"
                y2="24.104"
                gradientUnits="userSpaceOnUse">
                <stop offset="0" stop-opacity="1" />
                <stop offset="1" stop-opacity="0" />
              </linearGradient>
              <linearGradient
                id="paint1_linear_2989_100980"
                x1="5.19475"
                y1="0.849139"
                x2="10.3357"
                y2="24.1155"
                gradientUnits="userSpaceOnUse">
                <stop offset="0" stop-opacity="1" />
                <stop offset="1" stop-opacity="0" />
              </linearGradient>
            </defs>
          </svg>
        </span>
      </span>
      <span class="app-brand-text demo menu-text fw-semibold ms-2">{{ config('app.name', 'Laravel') }}</span>
    </a>

    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
      <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M8.47365 11.7183C8.11707 12.0749 8.11707 12.6531 8.47365 13.0097L12.071 16.607C12.4615 16.9975 12.4615 17.6305 12.071 18.021C11.6805 18.4115 11.0475 18.4115 10.657 18.021L5.83009 13.1941C5.37164 12.7356 5.37164 11.9924 5.83009 11.5339L10.657 6.707C11.0475 6.31653 11.6805 6.31653 12.071 6.707C12.4615 7.09747 12.4615 7.73053 12.071 8.121L8.47365 11.7183Z"
          fill-opacity="0.9" />
        <path
          d="M14.3584 11.8336C14.0654 12.1266 14.0654 12.6014 14.3584 12.8944L18.071 16.607C18.4615 16.9975 18.4615 17.6305 18.071 18.021C17.6805 18.4115 17.0475 18.4115 16.657 18.021L11.6819 13.0459C11.3053 12.6693 11.3053 12.0587 11.6819 11.6821L16.657 6.707C17.0475 6.31653 17.6805 6.31653 18.071 6.707C18.4615 7.09747 18.4615 7.73053 18.071 8.121L14.3584 11.8336Z"
          fill-opacity="0.4" />
      </svg>
    </a>
  </div>

  <div class="menu-inner-shadow"></div>

  <ul class="menu-inner py-1">
    <!-- Dashboard -->
  <li class="menu-item {{ request()->routeIs('admin/dashboard') || request()->routeIs('superadmin/dashboard') ? 'active' : '' }}">
    <a href="{{ url('/') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-home-2-line"></i>
      <div>Dashboard</div>
    </a>
  </li>
    @can('access whatsapp dashboard')
  <!-- WhatsApp Dashboard -->
  <li class="menu-item {{ request()->is('admin/whatsapp*') ? 'active' : '' }}">
    <a href="{{ route('admin.whatsapp.dashboard') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-whatsapp-line"></i>
      <div>WhatsApp</div>
    </a>
  </li>
  @endcan

  @can('access pedidos')
  <!-- Pedidos -->
  <li class="menu-item {{ request()->routeIs('admin.pedidos.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-cart"></i>
      <div>Pedidos</div>
    </a>
    <ul class="menu-sub">
      <li class="menu-item {{ request()->routeIs('admin.pedidos.index') ? 'active' : '' }}">
        <a href="{{ route('admin.pedidos.index') }}" class="menu-link">
          <div>Gestión</div>
        </a>
      </li>
      @can('create pedidos')
      <li class="menu-item {{ request()->routeIs('admin.pedidos.create') ? 'active' : '' }}">
        <a href="{{ route('admin.pedidos.create') }}" class="menu-link">
          <div>Crear Pedido</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan



  @canany(['access categorias', 'access marcas'])
  <!-- Catálogos -->
  <li class="menu-item {{ request()->is('admin/categorias*', 'admin/marcas*', 'admin/productos*', 'admin/ofertas*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
        <i class="menu-icon tf-icons ri ri-folder-line"></i>
        <div>Catálogos</div>
    </a>
    <ul class="menu-sub">
        @can('access categorias')
        <li class="menu-item {{ request()->is('admin/categorias*') ? 'active' : '' }}">
            <a href="{{ route('admin.categorias.index') }}" class="menu-link">
                <div>Categorías</div>
            </a>
        </li>
        @endcan

        @can('access marcas')
        <li class="menu-item {{ request()->is('admin/marcas*') ? 'active' : '' }}">
            <a href="{{ route('admin.marcas.index') }}" class="menu-link">
                <div>Marcas</div>
            </a>
        </li>
        @endcan

        @can('access productos')
        <li class="menu-item {{ request()->is('admin/productos*') ? 'active' : '' }}">
            <a href="{{ route('admin.productos.index') }}" class="menu-link">
                <div>Productos</div>
            </a>
        </li>
        @endcan

        <!-- Ofertas -->
        @can('access ofertas')
        <li class="menu-item {{ request()->is('admin/ofertas*') ? 'active' : '' }}">
            <a href="{{ route('admin.ofertas.index') }}" class="menu-link">
                <div>Ofertas</div>
            </a>
        </li>
        @endcan
    </ul>
  </li>
  @endcanany

  @canany(['access pagos', 'access conceptos pago', 'access cajas'])
  <!-- Pagos y Finanzas -->
  <li class="menu-item {{ request()->routeIs('admin.pagos.*') || request()->routeIs('admin.conceptos-pago.*') || request()->routeIs('admin.cajas.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-coins-line"></i>
      <div>Pagos y Finanzas</div>
    </a>
    <ul class="menu-sub">

      @can('access cajas')
      <li class="menu-item {{ request()->routeIs('admin.cajas.index') ? 'active' : '' }}">
        <a href="{{ route('admin.cajas.index') }}" class="menu-link">
          <div>Caja Chica</div>
        </a>
      </li>
      @endcan

    </ul>
  </li>
  @endcan

  @can('access reportes')
  <!-- Reportes -->
  <li class="menu-item {{ request()->routeIs('admin.reportes.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-pie-chart-2-line"></i>
      <div>Reportes</div>
    </a>
    <ul class="menu-sub">

    </ul>
  </li>
  @endcan

  @canany(['access empresas', 'access paises', 'access sucursales', 'access school periods', 'access niveles educativos', 'access turnos'])
  <!-- Configuración Institucional -->
  <li class="menu-item {{ request()->routeIs('admin.empresas.*') || request()->routeIs('admin.paises.*') || request()->routeIs('admin.sucursales.*') || request()->routeIs('admin.school-periods.*') || request()->routeIs('admin.niveles-educativos.*') || request()->routeIs('admin.turnos.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-building-line"></i>
      <div>Configuración</div>
    </a>
    <ul class="menu-sub">
      @can('access empresas')
      <li class="menu-item {{ request()->routeIs('admin.empresas.index') ? 'active' : '' }}">
        <a href="{{ route('admin.empresas.index') }}" class="menu-link">
          <div>Empresas</div>
        </a>
      </li>
      @endcan
      @can('access paises')
      <li class="menu-item {{ request()->routeIs('admin.paises.index') ? 'active' : '' }}">
        <a href="{{ route('admin.paises.index') }}" class="menu-link">
          <div>Países</div>
        </a>
      </li>
      @endcan
      @can('access sucursales')
      <li class="menu-item {{ request()->routeIs('admin.sucursales.index') ? 'active' : '' }}">
        <a href="{{ route('admin.sucursales.index') }}" class="menu-link">
          <div>Sucursales</div>
        </a>
      </li>
      @endcan

    </ul>
  </li>
  @endcan

  @can('access series')
  <!-- Series de Documentos -->
  <li class="menu-item {{ request()->routeIs('admin.series.*') ? 'active' : '' }}">
    <a href="{{ route('admin.series.index') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-file-text-line"></i>
      <div>Series</div>
    </a>
  </li>
  @endcan

  @can('view exchange-rates')
    @php
        $regionalConfig = app(\App\Services\RegionalConfigurationService::class)->getCurrentConfiguration();
    @endphp
    {{-- Mostrar opción de tasas solo si el país es Venezuela (VES) --}}
    @if(($regionalConfig['currency'] ?? 'USD') === 'VES' || ($regionalConfig['dual_currency'] ?? false))
    <!-- Tasas de Cambio -->
    <li class="menu-item {{ request()->routeIs('admin.exchange-rates') ? 'active' : '' }}">
      <a href="{{ route('admin.exchange-rates') }}" class="menu-link">
        <i class="menu-icon tf-icons ri ri-exchange-funds-line"></i>
        <div>Tasas BCV</div>
      </a>
    </li>
    @endif
  @endcan

  <!-- Personalización de Plantilla -->
  <li class="menu-item {{ request()->routeIs('admin.template-customization') ? 'active' : '' }}">
    <a href="{{ route('admin.template-customization') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-palette"></i>
      <div>Personalización</div>
    </a>
  </li>

  @can('access empleados')
  <!-- Empleados -->
  <li class="menu-item {{ request()->routeIs('admin.empleados.*') ? 'active' : '' }}">
    <a href="{{ route('admin.empleados.index') }}" class="menu-link">
      <i class="menu-icon tf-icons ri ri-user-line"></i>
      <div>Empleados</div>
    </a>
  </li>
  @endcan


  @canany(['access users', 'access roles', 'access permissions'])
  <!-- Usuarios y Permisos -->
  <li class="menu-item {{ request()->routeIs('admin.users.*') || request()->routeIs('admin.roles.*') || request()->routeIs('admin.permissions.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-account-group"></i>
      <div>Administración</div>
    </a>
    <ul class="menu-sub">
      @can('access users')
      <li class="menu-item {{ request()->routeIs('admin.users.index') ? 'active' : '' }}">
        <a href="{{ route('admin.users.index') }}" class="menu-link">
          <div>Usuarios</div>
        </a>
      </li>
      @endcan
      @can('access roles')
      <li class="menu-item {{ request()->routeIs('admin.roles.index') ? 'active' : '' }}">
        <a href="{{ route('admin.roles.index') }}" class="menu-link">
          <div>Roles</div>
        </a>
      </li>
      @endcan
      @can('access permissions')
      <li class="menu-item {{ request()->routeIs('admin.permissions.index') ? 'active' : '' }}">
        <a href="{{ route('admin.permissions.index') }}" class="menu-link">
          <div>Permisos</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan

  @canany(['view active sessions', 'access activity log', 'access monitoreo'])
  <!-- Sistema y Monitoreo -->
  <li class="menu-item {{ request()->routeIs('admin.active-sessions*') || request()->is('admin/activity-log*') || request()->routeIs('admin.monitoreo.*') ? 'active open' : '' }}">
    <a href="javascript:void(0);" class="menu-link menu-toggle">
      <i class="menu-icon tf-icons ri ri-dashboard-3-line"></i>
      <div>Monitoreo</div>
    </a>
    <ul class="menu-sub">
      @can('view active sessions')
      <li class="menu-item {{ request()->routeIs('admin.active-sessions*') ? 'active' : '' }}">
        <a href="{{ route('admin.active-sessions.index') }}" class="menu-link">
          <div>Sesiones</div>
        </a>
      </li>
      @endcan
      @can('access activity log')
      <li class="menu-item {{ request()->is('admin/activity-log*') ? 'active' : '' }}">
        <a href="{{ route('admin.activity-log') }}" class="menu-link">
          <div>Actividad</div>
        </a>
      </li>
      @endcan
      @can('access database backup')
      <li class="menu-item {{ request()->routeIs('admin.monitoreo.database-backup') ? 'active' : '' }}">
        <a href="{{ route('admin.monitoreo.database-backup') }}" class="menu-link">
          <div>Respaldo BD</div>
        </a>
      </li>
      @endcan
      @can('access database import')
      <li class="menu-item {{ request()->routeIs('admin.monitoreo.database-import') ? 'active' : '' }}">
        <a href="{{ route('admin.monitoreo.database-import') }}" class="menu-link">
          <div>Importar BD</div>
        </a>
      </li>
      @endcan
    </ul>
  </li>
  @endcan

  </ul>
</aside>
