<!DOCTYPE html>
<html
  lang="{{ str_replace('_', '-', app()->getLocale()) }}"
  class="layout-menu-fixed layout-navbar-fixed {{ isset($templateSettings) ? ($templateSettings->content_layout === 'wide' ? 'layout-wide' : 'layout-compact') : 'layout-compact' }}{{ isset($templateSettings) && $templateSettings->footer_fixed ? ' layout-footer-fixed' : '' }}"
  dir="{{ isset($templateSettings) ? $templateSettings->text_direction : 'ltr' }}"
  data-skin="{{ isset($templateSettings) ? ($templateSettings->skin == 1 ? 'bordered' : 'default') : 'default' }}"
  data-bs-theme="{{ isset($templateSettings) ? $templateSettings->theme : 'light' }}"
  data-assets-path="{{ asset('materialize/assets/') }}/"
  data-template="horizontal-menu-template">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ $title ?? config('app.name') }}</title>
    <meta name="description" content="{{ config('app.name') }} - {{ config('app.description') }}" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('materialize/assets/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="/materialize/assets/vendor/fonts/iconify-icons.css" />
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.7.0/fonts/remixicon.css" rel="stylesheet">


    <!-- Core CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/node-waves/node-waves.css" />
    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/pickr/pickr-themes.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/css/core.css" />
    <link rel="stylesheet" href="/materialize/assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/swiper/swiper.css" />

    <!-- Page CSS -->
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/animate-css/animate.css" />
    <link rel="stylesheet" href="/materialize/assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Helpers -->
    <script src="/materialize/assets/vendor/js/helpers.js"></script>
    <script src="/materialize/assets/vendor/js/template-customizer.js"></script>
    <script src="/materialize/assets/js/config.js"></script>


    @include('components.template-config')

    <!-- Cropper.js CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">

    <!-- Chat y Biblioteca CSS -->
    <link rel="stylesheet" href="{{ asset('css/chat-biblioteca.css') }}">

    @if(isset($templateSettings) && $templateSettings->primary_color)
    <style>
      :root {
        --bs-primary: {{ $templateSettings->primary_color }};
        --bs-primary-rgb: {{ implode(',', sscanf($templateSettings->primary_color, '#%02x%02x%02x')) }};
      }
    </style>
    @endif

    <style>
      .avatar-initial {
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 1rem;
        color: white;
      }

      /* Eliminar overlays problemáticos */
      .modal-backdrop,
      .offcanvas-backdrop,
      .tooltip,
      .popover,
      .dropdown-backdrop {
        display: none !important;
        opacity: 0 !important;
        visibility: hidden !important;
      }

      /* Asegurar que no haya z-index problemáticos */
      .layout-overlay {
        z-index: -1 !important;
      }
    </style>

    <!-- Livewire Styles -->
    @livewireStyles

    @stack('styles')
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-navbar-full layout-horizontal layout-without-menu">
      <div class="layout-container">

        <!-- /Navbar -->
      @include('components.partials.navbar-horizontal')

        <!-- Layout page -->
        <div class="layout-page">
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Menu -->
            <aside id="layout-menu" class="layout-menu-horizontal menu-horizontal menu flex-grow-0">
              <div class="container-fluid d-flex h-100">
                @include('components.partials.horizontal-menu')
              </div>
            </aside>

            <!-- Content -->
            <div class="container-fluid flex-grow-1 container-p-y">

              {{ $slot }}
            </div>
            <!-- /Content -->

            <!-- Footer -->
            @include('components.partials.footer-horizontal')

            <!-- <div class="content-backdrop fade"></div> -->
          </div>
          <!-- /Content wrapper -->
        </div>
        <!-- /Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- /Layout wrapper -->

    <!-- Contenedor de notificaciones -->
    <div id="notification-container"></div>

    <!-- Core JS -->
    <script src="/materialize/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="/materialize/assets/vendor/libs/popper/popper.js"></script>
    <script src="/materialize/assets/vendor/js/bootstrap.js"></script>
    <script src="/materialize/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="/materialize/assets/vendor/libs/@algolia/autocomplete-js.js"></script>
    <script src="/materialize/assets/vendor/libs/pickr/pickr.js"></script>
    <script src="/materialize/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="/materialize/assets/vendor/libs/hammer/hammer.js"></script>
    <script src="/materialize/assets/vendor/libs/i18n/i18n.js"></script>
    <script src="/materialize/assets/vendor/js/menu.js"></script>

    <!-- Vendors JS -->
    <script src="/materialize/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="/materialize/assets/vendor/libs/swiper/swiper.js"></script>
    <script src="/materialize/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>

    <!-- Main JS -->
    <script src="/materialize/assets/js/main.js"></script>

    <!-- Livewire Scripts -->
    @livewireScripts


    <!-- Cropper.js JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

    <!-- Script para manejar notificaciones -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Función para mostrar notificaciones
            function showNotification(type, message) {
                const iconMap = {
                    'success': 'success',
                    'error': 'error',
                    'warning': 'warning',
                    'info': 'info'
                };

                Swal.fire({
                    icon: iconMap[type] || 'info',
                    text: message,
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: false
                });
            }

            // Listener para eventos show-toast de Livewire
            window.addEventListener('show-toast', event => {
                const detail = event.detail;
                showNotification(detail.type || detail[0]?.type, detail.message || detail[0]?.message);
            });

            // Procesar mensajes flash de Laravel
            @if(session('success'))
                showNotification('success', '{{ session('success') }}');
            @endif

            @if(session('error'))
                showNotification('error', '{{ session('error') }}');
            @endif

            @if(session('warning'))
                showNotification('warning', '{{ session('warning') }}');
            @endif

            @if(session('info'))
                showNotification('info', '{{ session('info') }}');
            @endif

            @if(session('message'))
                showNotification('info', '{{ session('message') }}');
            @endif

            @if(session('danger'))
                showNotification('error', '{{ session('danger') }}');
            @endif

            @if(session('alert'))
                showNotification('warning', '{{ session('alert') }}');
            @endif

            // Procesar errores de validación
            @if($errors->any())
                @foreach($errors->all() as $error)
                    showNotification('error', '{{ $error }}');
                @endforeach
            @endif
        });
    </script>

    @stack('scripts')

  </body>
</html>
