@extends('components.layouts.horizontal')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-chart-line me-2"></i>
            Dashboard de Cajas y Tasas
        </h1>
        <div class="d-flex gap-2">
            <form action="{{ route('admin.cajas.dashboard.verificar-diaria') }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-info btn-sm">
                    <i class="fas fa-sync me-1"></i>
                    Verificar Diaria
                </button>
            </form>
            <button type="button" class="btn btn-primary btn-sm" onclick="location.reload()">
                <i class="fas fa-redo me-1"></i>
                Actualizar
            </button>
        </div>
    </div>

    <!-- Alertas -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Resumen de Estado -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Tasa del Día
                            </div>
                            @if($tasas['tasa_hoy'])
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ number_format($tasas['tasa_hoy']->usd_rate, 2) }} Bs.
                                </div>
                                <div class="text-xs text-success">
                                    <i class="fas fa-check me-1"></i>
                                    Actualizada hace {{ $tasas['horas_sin_actualizar'] }}h
                                </div>
                            @else
                                <div class="h5 mb-0 font-weight-bold text-danger">
                                    Sin Registrar
                                </div>
                                <div class="text-xs text-danger">
                                    <i class="fas fa-exclamation-triangle me-1"></i>
                                    Requiere actualización
                                </div>
                            @endif
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Cajas Abiertas
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $cajas['cajas_abiertas_count'] }}
                            </div>
                            <div class="text-xs text-muted">
                                {{ $cajas['total_cajas_hoy'] }} cajas hoy
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Próximo Corte
                            </div>
                            @if($proximas_acciones['proximo_corte_caja'])
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $proximas_acciones['proximo_corte_caja']->format('H:i') }}
                                </div>
                                <div class="text-xs text-muted">
                                    En {{ $proximas_acciones['tiempo_proximo_corte'] }}
                                </div>
                            @else
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    Sin programar
                                </div>
                                <div class="text-xs text-muted">
                                    No hay más cortes hoy
                                </div>
                            @endif
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Estado Verificación
                            </div>
                            @if($proximas_acciones['en_verificacion_tasa'])
                                <div class="h5 mb-0 font-weight-bold text-warning">
                                    <i class="fas fa-search me-1"></i>
                                    En Proceso
                                </div>
                                <div class="text-xs text-muted">
                                    00:00 - 14:00
                                </div>
                            @else
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    <i class="fas fa-pause me-1"></i>
                                    Fuera de Horario
                                </div>
                                <div class="text-xs text-muted">
                                    Verificación: 00-14h
                                </div>
                            @endif
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter me-2"></i>
                Filtros
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="empresa_id" class="form-label">Empresa</label>
                    <select name="empresa_id" id="empresa_id" class="form-select" onchange="this.form.submit()">
                        <option value="">Todas las empresas</option>
                        @foreach($empresas as $empresa)
                            <option value="{{ $empresa->id }}" {{ request('empresa_id') == $empresa->id ? 'selected' : '' }}>
                                {{ $empresa->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @if(request('empresa_id') && isset($sucursales))
                    <div class="col-md-4">
                        <label for="sucursal_id" class="form-label">Sucursal</label>
                        <select name="sucursal_id" id="sucursal_id" class="form-select" onchange="this.form.submit()">
                            <option value="">Todas las sucursales</option>
                            @foreach($sucursales as $sucursal)
                                <option value="{{ $sucursal->id }}" {{ request('sucursal_id') == $sucursal->id ? 'selected' : '' }}>
                                    {{ $sucursal->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @endif
            </form>
        </div>
    </div>

    <!-- Acciones Rápidas -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-bolt me-2"></i>
                        Acciones Rápidas
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <form action="{{ route('admin.cajas.dashboard.actualizar-tasa') }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-primary w-100 mb-2" 
                                        {{ $proximas_acciones['es_hora_actualizacion_tasa'] ? '' : 'disabled' }}>
                                    <i class="fas fa-sync-alt me-2"></i>
                                    Actualizar Tasa Manualmente
                                </button>
                            </form>
                        </div>
                        <div class="col-md-4">
                            <form action="{{ route('admin.cajas.dashboard.corte-caja') }}" method="POST">
                                @csrf
                                <input type="hidden" name="empresa_id" value="{{ request('empresa_id') }}">
                                <input type="hidden" name="sucursal_id" value="{{ request('sucursal_id') }}">
                                <button type="submit" class="btn btn-success w-100 mb-2">
                                    <i class="fas fa-cut me-2"></i>
                                    Realizar Corte de Caja
                                </button>
                            </form>
                        </div>
                        <div class="col-md-4">
                            <button type="button" class="btn btn-info w-100 mb-2" onclick="verificarEstado()">
                                <i class="fas fa-search me-2"></i>
                                Verificar Estado del Sistema
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detalles de Cajas -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-list me-2"></i>
                        Cajas del Día
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Empresa</th>
                                    <th>Sucursal</th>
                                    <th>Estado</th>
                                    <th>Monto Inicial</th>
                                    <th>Monto Final</th>
                                    <th>Apertura</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($cajas['cajas_hoy'] as $caja)
                                    <tr>
                                        <td>{{ $caja->empresa->nombre }}</td>
                                        <td>{{ $caja->sucursal->nombre }}</td>
                                        <td>
                                            <span class="badge bg-{{ $caja->estado === 'abierta' ? 'success' : 'secondary' }}">
                                                {{ ucfirst($caja->estado) }}
                                            </span>
                                        </td>
                                        <td>${{ number_format($caja->monto_inicial, 2) }}</td>
                                        <td>
                                            @if($caja->estado === 'cerrada')
                                                ${{ number_format($caja->monto_final, 2) }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>{{ $caja->fecha_apertura->format('H:i') }}</td>
                                        <td>
                                            @if($caja->estado === 'abierta')
                                                <form action="{{ route('admin.cajas.dashboard.corte-caja') }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <input type="hidden" name="empresa_id" value="{{ $caja->empresa_id }}">
                                                    <input type="hidden" name="sucursal_id" value="{{ $caja->sucursal_id }}">
                                                    <button type="submit" class="btn btn-warning btn-sm">
                                                        Cerrar
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted">
                                            No hay cajas registradas para hoy
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Estadísticas -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-bar me-2"></i>
                        Estadísticas
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 mb-3">
                            <div class="text-center">
                                <div class="h4 font-weight-bold text-primary">{{ $estadisticas['cajas_hoy'] }}</div>
                                <div class="text-xs text-muted">Cajas Hoy</div>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="text-center">
                                <div class="h4 font-weight-bold text-success">{{ $estadisticas['cajas_ayer'] }}</div>
                                <div class="text-xs text-muted">Cajas Ayer</div>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="text-center">
                                <div class="h4 font-weight-bold text-info">{{ $estadisticas['tasas_hoy'] }}</div>
                                <div class="text-xs text-muted">Tasas Hoy</div>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="text-center">
                                <div class="h4 font-weight-bold text-warning">{{ $estadisticas['promedio_cajas_por_dia'] }}</div>
                                <div class="text-xs text-muted">Promedio/Día</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Historial de Tasas -->
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-history me-2"></i>
                        Últimas Tasas
                    </h6>
                </div>
                <div class="card-body">
                    @forelse($tasas['ultimas_tasas'] as $tasa)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <div class="font-weight-bold">{{ $tasa->date->format('d/m') }}</div>
                                <div class="text-xs text-muted">{{ $tasa->source }}</div>
                            </div>
                            <div class="text-end">
                                <div class="font-weight-bold">{{ number_format($tasa->usd_rate, 2) }} Bs.</div>
                                <div class="text-xs text-muted">USD</div>
                            </div>
                        </div>
                        @if(!$loop->last)
                            <hr class="my-2">
                        @endif
                    @empty
                        <div class="text-center text-muted">
                            No hay tasas registradas
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function verificarEstado() {
    // Aquí puedes agregar lógica para verificar el estado del sistema
    // Por ejemplo, hacer una petición AJAX o ejecutar un comando
    alert('Verificando estado del sistema...');
}

// Auto-refresh cada 5 minutos
setTimeout(function() {
    location.reload();
}, 300000);
</script>
@endpush
@endsection