/**
 * Demo de Sistema de Notificaciones
 * Ejemplos de uso y funcionalidades
 */

document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Demo de notificaciones cargado');

    // Crear botones de demo si no existen
    if (!document.getElementById('notification-demo')) {
        createDemoButtons();
    }
});

function createDemoButtons() {
    const demoContainer = document.createElement('div');
    demoContainer.id = 'notification-demo';
    demoContainer.style.cssText = `
        position: fixed;
        top: 20px;
        left: 20px;
        z-index: 1000;
        background: white;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        font-family: Arial, sans-serif;
        min-width: 300px;
    `;

    demoContainer.innerHTML = `
        <h4 style="margin-top: 0; margin-bottom: 15px; color: #333;">🎯 Demo Notificaciones</h4>
        <div style="display: flex; flex-direction: column; gap: 10px;">
            <button onclick="demoBasicNotifications()" class="demo-btn">Notificaciones Básicas</button>
            <button onclick="demoAdvancedNotifications()" class="demo-btn">Notificaciones Avanzadas</button>
            <button onclick="demoLivewireIntegration()" class="demo-btn">Integración Livewire</button>
            <button onclick="demoCustomOptions()" class="demo-btn">Opciones Personalizadas</button>
            <button onclick="clearNotifications()" class="demo-btn" style="background: #dc3545;">Limpiar Todas</button>
        </div>
        <button onclick="this.parentElement.remove()" style="position: absolute; top: 10px; right: 10px; background: none; border: none; font-size: 20px; cursor: pointer;">&times;</button>
    `;

    // Agregar estilos para los botones
    const styles = `
        .demo-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.2s;
        }
        .demo-btn:hover {
            background: #0056b3;
        }
    `;

    const styleSheet = document.createElement('style');
    styleSheet.textContent = styles;
    document.head.appendChild(styleSheet);

    document.body.appendChild(demoContainer);
}

// Funciones de demo
function demoBasicNotifications() {
    notify('success', '✅ ¡Operación exitosa! Los datos se han guardado correctamente.');

    setTimeout(() => {
        notify('error', '❌ Error al procesar la solicitud. Por favor, intenta nuevamente.');
    }, 1000);

    setTimeout(() => {
        notify('warning', '⚠️ Advertencia: El archivo es muy grande y puede tardar en cargar.');
    }, 2000);

    setTimeout(() => {
        notify('info', 'ℹ️ Información: El proceso puede tardar unos minutos en completarse.');
    }, 3000);
}

function demoAdvancedNotifications() {
    // Notificación con duración personalizada
    notify('success', '✅ ¡Guardado exitoso! Esta notificación durará 5 segundos.', {
        duration: 5000,
        dismissible: true
    });

    // Notificación con HTML
    setTimeout(() => {
        notify('info', '<strong>📊 Estadísticas actualizadas:</strong><br>Se han procesado <em>1,234</em> registros.', {
            duration: 4000,
            dismissible: true
        });
    }, 1000);

    // Notificación persistente (sin auto-cierre)
    setTimeout(() => {
        notify('warning', '🔔 Notificación persistente: Haz clic en la X para cerrar.', {
            duration: 0,
            dismissible: true,
            className: 'notification-persistent'
        });
    }, 2000);
}

function demoLivewireIntegration() {
    // Simular eventos de Livewire
    if (typeof Livewire !== 'undefined') {
        // Simular notificación de éxito desde Livewire
        Livewire.dispatch('notify', {
            type: 'success',
            message: '🔄 Notificación desde Livewire: Datos sincronizados correctamente.'
        });

        setTimeout(() => {
            Livewire.dispatch('notify', {
                type: 'error',
                message: '❌ Error de Livewire: No se pudo conectar con el servidor.'
            });
        }, 1500);

        setTimeout(() => {
            Livewire.dispatch('notify', {
                type: 'info',
                message: '📡 Estado de conexión: Online',
                options: { duration: 3000 }
            });
        }, 3000);
    } else {
        notify('warning', '⚠️ Livewire no está disponible en este momento.');
    }
}

function demoCustomOptions() {
    // Cambiar posición temporalmente
    const originalPosition = { x: 'right', y: 'top' };

    setNotificationPosition('left', 'top');
    notify('info', '📍 Notificación en la esquina superior izquierda');

    setTimeout(() => {
        setNotificationPosition('right', 'bottom');
        notify('success', '📍 Notificación en la esquina inferior derecha', {
            duration: 3000,
            ripple: true
        });
    }, 1000);

    setTimeout(() => {
        setNotificationPosition('left', 'bottom');
        notify('warning', '📍 Notificación en la esquina inferior izquierda', {
            duration: 3000,
            dismissible: true
        });
    }, 2000);

    // Restaurar posición original
    setTimeout(() => {
        setNotificationPosition(originalPosition.x, originalPosition.y);
        notify('info', '✅ Posición restaurada a la configuración original');
    }, 3000);
}

// Función para crear notificaciones con diferentes duraciones
function demoDurationOptions() {
    notify('success', '⚡ Notificación rápida (1 segundo)', { duration: 1000 });

    setTimeout(() => {
        notify('info', '⏱️ Notificación estándar (3 segundos)');
    }, 500);

    setTimeout(() => {
        notify('warning', '🐌 Notificación lenta (7 segundos)', { duration: 7000 });
    }, 1000);

    setTimeout(() => {
        notify('error', '🚫 Notificación persistente (sin auto-cierre)', { duration: 0 });
    }, 1500);
}

// Función para demostrar notificaciones grandes
function demoLargeNotifications() {
    notify('success', '🎉 ¡Felicitaciones! <br><strong>Has completado todos los módulos del curso.</strong><br><small>Se ha enviado un certificado a tu correo electrónico.</small>', {
        duration: 5000,
        dismissible: true,
        className: 'notification-large'
    });
}

// Función para demostrar notificaciones con acciones
function demoActionableNotifications() {
    notify('info', '<div style="display: flex; align-items: center; gap: 10px;"><span>📢 Nueva actualización disponible</span><button onclick="window.open(\'/update\', \'_blank\')" style="background: #007bff; color: white; border: none; padding: 4px 8px; border-radius: 4px; cursor: pointer; font-size: 12px;">Actualizar</button></div>', {
        duration: 0,
        dismissible: true
    });
}

// Agregar funciones al objeto window para que estén disponibles globalmente
window.demoBasicNotifications = demoBasicNotifications;
window.demoAdvancedNotifications = demoAdvancedNotifications;
window.demoLivewireIntegration = demoLivewireIntegration;
window.demoCustomOptions = demoCustomOptions;
window.demoDurationOptions = demoDurationOptions;
window.demoLargeNotifications = demoLargeNotifications;
window.demoActionableNotifications = demoActionableNotifications;

console.log('🎯 Funciones de demo disponibles:');
console.log('- demoBasicNotifications()');
console.log('- demoAdvancedNotifications()');
console.log('- demoLivewireIntegration()');
console.log('- demoCustomOptions()');
console.log('- demoDurationOptions()');
console.log('- demoLargeNotifications()');
console.log('- demoActionableNotifications()');
console.log('');
console.log('💡 También puedes usar: clearNotifications(), setNotificationPosition(x, y), setNotificationDuration(ms)');
