<?php

require __DIR__ . '/vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as Capsule;
use App\Models\DetallePedido;

// Configurar conexión a la base de datos
$capsule = new Capsule;
$capsule->addConnection([
    'driver'    => 'mysql',
    'host'      => env('DB_HOST', '127.0.0.1'),
    'port'      => env('DB_PORT', '3306'),
    'database'  => env('DB_DATABASE', 'larapedido'),
    'username'  => env('DB_USERNAME', 'root'),
    'password'  => env('DB_PASSWORD', ''),
    'charset'   => 'utf8mb4',
    'collation' => 'utf8mb4_unicode_ci',
    'prefix'    => '',
]);

$capsule->setAsGlobal();
$capsule->bootEloquent();

echo "=== ANÁLISIS DE DETALLES DE PEDIDO CON CANTIDAD NULL ===\n\n";

// Buscar todos los detalles con cantidad NULL
$detallesConNull = DetallePedido::whereNull('cantidad')->get();

echo "Detalles de pedido con cantidad NULL encontrados: " . $detallesConNull->count() . "\n\n";

if ($detallesConNull->count() > 0) {
    echo "Detalles afectados:\n";
    echo str_pad("ID", 5) . " | " . str_pad("Pedido ID", 10) . " | " . str_pad("Producto ID", 12) . " | " . str_pad("Precio Unitario", 15) . " | " . str_pad("Subtotal", 12) . "\n";
    echo str_repeat("-", 70) . "\n";
    
    foreach ($detallesConNull as $detalle) {
        echo str_pad($detalle->id, 5) . " | ";
        echo str_pad($detalle->pedido_id, 10) . " | ";
        echo str_pad($detalle->producto_id, 12) . " | ";
        echo str_pad($detalle->precio_unitario, 15) . " | ";
        echo str_pad($detalle->subtotal, 12) . "\n";
    }
    
    echo "\n¿Desea corregir estos detalles estableciendo cantidad = 1? (s/n): ";
    $respuesta = trim(fgets(STDIN));
    
    if (strtolower($respuesta) === 's') {
        echo "\nCorrigiendo detalles...\n";
        $corregidos = 0;
        
        foreach ($detallesConNull as $detalle) {
            // Calcular la cantidad basada en el subtotal y precio unitario
            if ($detalle->precio_unitario > 0 && $detalle->subtotal > 0) {
                $cantidadCalculada = $detalle->subtotal / $detalle->precio_unitario;
                $cantidad = round($cantidadCalculada, 0); // Redondear a entero
                
                if ($cantidad <= 0) {
                    $cantidad = 1; // Valor por defecto
                }
            } else {
                $cantidad = 1; // Valor por defecto
            }
            
            $detalle->cantidad = $cantidad;
            $detalle->save();
            $corregidos++;
            
            echo "Detalle ID {$detalle->id}: cantidad establecida a {$cantidad}\n";
        }
        
        echo "\n✓ Se corrigieron {$corregidos} detalles de pedido.\n";
        
        // Verificar si aún hay detalles con cantidad NULL
        $detallesRestantes = DetallePedido::whereNull('cantidad')->count();
        if ($detallesRestantes > 0) {
            echo "⚠ Aún quedan {$detallesRestantes} detalles con cantidad NULL.\n";
        } else {
            echo "✓ Todos los detalles ahora tienen cantidad válida.\n";
        }
        
    } else {
        echo "Operación cancelada.\n";
    }
} else {
    echo "✓ No se encontraron detalles de pedido con cantidad NULL.\n";
}

echo "\n=== FIN DEL ANÁLISIS ===\n";