<?php

// Script para corregir iconos incorrectos en el frontend

$files = [
    'resources/views/livewire/front/index.blade.php',
    'resources/views/livewire/front/cart/index.blade.php', 
    'resources/views/livewire/front/checkout/index.blade.php',
    'resources/views/livewire/front/pedido/historico.blade.php',
    'resources/views/layouts/front/app.blade.php'
];

$iconReplacements = [
    'ri-shopping-cart-2-line-plus' => 'ri-shopping-cart-line',
    'ri-shopping-cart-2-line-outline' => 'ri-shopping-cart-line',
    'ri-heart-outline' => 'ri-heart-line',
    'ri-user-3-line-arrow-right' => 'ri-login-circle-line',
    'ri-user-3-line-circle' => 'ri-user-line',
    'ri-user-3-line' => 'ri-user-line',
    'ri-shopping-outline' => 'ri-shopping-bag-line',
    'ri-sale-outline' => 'ri-price-tag-3-line',
    'ri-truck-fast' => 'ri-truck-line',
    'ri-package-variant' => 'ri-box-3-line',
    'ri-package-variant-closed' => 'ri-box-3-line',
    'ri-eye-line-all-outline' => 'ri-eye-line',
    'ri-email-outline' => 'ri-mail-line',
    'ri-lock-outline' => 'ri-shield-check-line',
    'ri-headset' => 'ri-customer-service-2-line',
    'ri-money-dollar-circle-line' => 'ri-refund-2-line',
    'ri-lock' => 'ri-shield-check-line',
    'ri-sale' => 'ri-price-tag-3-line',
    'ri-shopping-cart-2-line-heart' => 'ri-shopping-bag-heart-line',
    'ri-credit-card' => 'ri-bank-card-line',
    'ri-delete-bin-line' => 'ri-delete-bin-line',
    'ri-receipt' => 'ri-file-list-3-line',
    'ri-cash' => 'ri-money-dollar-circle-line',
    'ri-bank' => 'ri-bank-line',
    'ri-cellphone' => 'ri-smartphone-line',
    'ri-check-circle' => 'ri-checkbox-circle-line',
    'ri-close-circle' => 'ri-close-circle-line',
    'ri-clock' => 'ri-time-line',
    'ri-filter-variant-remove' => 'ri-filter-off-line',
    'ri-view-grid' => 'ri-grid-line',
    'ri-view-list' => 'ri-list-check',
    'ri-note-text' => 'ri-file-text-line',
    'ri-map-marker' => 'ri-map-pin-line',
    'ri-loading' => 'ri-loader-line',
    'ri-arrow-left-line' => 'ri-arrow-left-line',
    'ri-arrow-right-line' => 'ri-arrow-right-line'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        $content = file_get_contents($file);
        
        foreach ($iconReplacements as $old => $new) {
            $content = str_replace($old, $new, $content);
        }
        
        file_put_contents($file, $content);
        echo "Corregido: $file\n";
    } else {
        echo "Archivo no encontrado: $file\n";
    }
}

echo "Corrección de iconos completada.\n";