<?php
require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=== Debug WhatsApp Connection ===\n\n";

// Verificar configuración
echo "Configuración:\n";
echo "- API URL: " . config('whatsapp.api_url') . "\n";
echo "- API Key: " . config('whatsapp.api_key') . "\n";
echo "- JWT Secret: " . (config('whatsapp.jwt_secret') ? 'Configurado' : 'No configurado') . "\n\n";

// Verificar estado de la API
try {
    echo "Estado del servicio WhatsApp:\n";
    $healthResponse = Http::timeout(5)->get(config('whatsapp.api_url') . '/health');
    if ($healthResponse->successful()) {
        $healthData = $healthResponse->json();
        echo "- Servicio: ✅ Disponible\n";
        echo "- Versión: " . ($healthData['version'] ?? 'N/A') . "\n";
        echo "- Tiempo activo: " . ($healthData['uptime'] ?? 'N/A') . " segundos\n";
    } else {
        echo "- Servicio: ❌ No disponible (HTTP " . $healthResponse->status() . ")\n";
    }
} catch (Exception $e) {
    echo "- Servicio: ❌ Error - " . $e->getMessage() . "\n";
}

echo "\n";

// Verificar estado de conexión
try {
    echo "Estado de conexión WhatsApp:\n";
    $response = Http::withHeaders([
        'X-API-Key' => config('whatsapp.api_key')
    ])->timeout(10)->get(config('whatsapp.api_url') . '/api/whatsapp/status');
    
    if ($response->successful()) {
        $data = $response->json();
        echo "- Estado: " . ($data['connectionState'] ?? 'desconocido') . "\n";
        echo "- Usuario: " . ($data['user']['name'] ?? 'No conectado') . "\n";
        echo "- Última vez visto: " . ($data['lastSeen'] ?? 'N/A') . "\n";
        echo "- Intentos de reconexión: " . ($data['reconnectAttempts'] ?? 'N/A') . "\n";
        echo "- Empresa: " . ($data['company'] ?? 'N/A') . "\n";
        
        // Verificar código QR
        if ($data['connectionState'] === 'disconnected') {
            echo "\nVerificando código QR...\n";
            $qrResponse = Http::withHeaders([
                'X-API-Key' => config('whatsapp.api_key')
            ])->timeout(10)->get(config('whatsapp.api_url') . '/api/whatsapp/qr');
            
            if ($qrResponse->successful()) {
                $qrData = $qrResponse->json();
                if (isset($qrData['qr']) && !empty($qrData['qr'])) {
                    echo "- Código QR: ✅ Disponible (imagen base64)\n";
                    echo "  URL de imagen: data:image/png;base64," . substr($qrData['qr'], 0, 50) . "...\n";
                } else {
                    echo "- Código QR: ❌ No disponible\n";
                }
            } else {
                echo "- Código QR: ❌ Error al obtener (HTTP " . $qrResponse->status() . ")\n";
            }
        }
    } else {
        echo "- Estado: ❌ Error HTTP " . $response->status() . "\n";
    }
} catch (Exception $e) {
    echo "- Estado: ❌ Error - " . $e->getMessage() . "\n";
}

echo "\n=== Fin del debug ===\n";