<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔍 Debug WhatsApp API...\n\n";

$apiUrl = config('whatsapp.api_url');
echo "API URL: {$apiUrl}\n\n";

// Prueba directa con cURL
$postData = [
    'phone' => '+584242115948',
    'message' => 'Mensaje de prueba directo'
];

echo "Datos a enviar:\n";
print_r($postData);
echo "\n";

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $apiUrl . '/api/whatsapp/send-message',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($postData),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_TIMEOUT => 10,
    CURLOPT_VERBOSE => true
]);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$error = curl_error($curl);

curl_close($curl);

echo "HTTP Code: {$httpCode}\n";
echo "Error: " . ($error ?: 'Ninguno') . "\n";
echo "Respuesta: {$response}\n";

if ($response) {
    $decoded = json_decode($response, true);
    if ($decoded) {
        echo "\nRespuesta decodificada:\n";
        print_r($decoded);
    }
}