<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\Sucursal;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SucursalSeeder extends Seeder
{
    public function run()
    {
        $empresas = Empresa::all();

        foreach ($empresas as $empresa) {
            $sucursal = Sucursal::create([
                'empresa_id' => $empresa->id,
                'nombre' => 'Sucursal ' . $empresa->razon_social,
                'direccion' => $empresa->direccion,
                'telefono' => $empresa->telefono,
            ]);

            // Crear Super Administrador
            $superAdmin = User::create([
                'name' => 'Super Admin ' . $empresa->razon_social,
                'username' => 'superadmin',
                'email' => 'superadmin@devtechvnzla.com',
                'password' => Hash::make('password'),
                'empresa_id' => $empresa->id,
                'sucursal_id' => 1,
                'status' => true,
            ]);

            $superAdmin->assignRole('Super Administrador');

            // Crear Administrador
            $admin = User::create([
                'name' => 'Admin ' . $empresa->razon_social,
                'username' => 'admin',
                'email' => 'admin@devtechvnzla.com',
                'password' => Hash::make('password'),
                'empresa_id' => $empresa->id,
                'sucursal_id' => 1,
                'status' => true,
            ]);
            $admin->assignRole('Administrador');

            // Crear Administrador
            $admin = User::create([
                'name' => 'User Cliente ' . $empresa->razon_social,
                'username' => 'usercliente',
                'email' => 'cliente@devtechvnzla.com',
                'password' => Hash::make('password'),
                'empresa_id' => $empresa->id,
                'sucursal_id' => 1,
                'status' => true,
            ]);
            $admin->assignRole('Cliente');

            // Crear Administrador
            $admin = User::create([
                'name' => 'User Empleado ' . $empresa->razon_social,
                'username' => 'userempleado',
                'email' => 'userempleado@devtechvnzla.com',
                'password' => Hash::make('password'),
                'empresa_id' => $empresa->id,
                'sucursal_id' => 1,
                'status' => true,
            ]);
            $admin->assignRole('Empleado');
        }
    }
}
