<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Definir módulos y sus permisos
        $modules = [
            'empresas' => [
                'access empresas',
                'create empresas',
                'edit empresas',
                'delete empresas',
            ],
            'paises' => [
                'access paises',
                'create paises',
                'edit paises',
                'delete paises',
            ],
            'sucursales' => [
                'access sucursales',
                'create sucursales',
                'edit sucursales',
                'delete sucursales',
            ],
            'users' => [
                'access users',
                'create users',
                'edit users',
                'delete users',
            ],
            'roles' => [
                'access roles',
                'create roles',
                'edit roles',
                'delete roles',
                'assign roles',
            ],
            'permissions' => [
                'access permissions',
                'create permissions',
                'edit permissions',
                'delete permissions',
                'assign permissions',
            ],

            'active_sessions' => [
                'view active sessions',
                'delete active sessions',
            ],
            'dashboard' => [
                'dashboard.metrics',
                'dashboard.comparison',
                'dashboard.employees',
                'dashboard.performance',
                'dashboard.inventory',
                'dashboard.customers',
            ],

            'monitoreo' => [
                'access monitoreo',
                'view monitoreo servidor',
                'view monitoreo base-datos',
                'view monitoreo estudiantes',
                'view monitoreo accesos',
                'export monitoreo accesos',
                'access database backup',
                'create database backup',
                'access database import',
                'create database import',
            ],

            // Módulo de reportes
            'reportes' => [
                'access reportes',
                'view estado cuentas',
                'view resumen pagos',
                'view morosidad',
                'view ingresos totales',
                'view historico matriculas',
                'export reportes',
            ],
            // Módulo de actividad
            'activity_log' => [
                'access activity log',
                'view activity log',
                'delete activity log',
                'export activity log',
            ],

            // Módulo de series de documentos
            'series' => [
                'access series',
                'create series',
                'edit series',
                'delete series',
            ],
            // Módulo de cajas
            'cajas' => [
                'access cajas',
                'create cajas',
                'edit cajas',
                'delete cajas',
                'view cajas',
            ],
            // Módulo de tasas de cambio
            'exchange_rates' => [
                'view exchange-rates',
                'fetch exchange-rates',
                'manage exchange-rates',
            ],

            // Módulo de pedidos
            'pedidos' => [
                'access pedidos',
                'view pedidos',
                'create pedidos',
                'edit pedidos',
                'delete pedidos',
                'confirmar pago pedidos',
                'asignar empleado pedidos',
                'cancelar pedidos',
                'finalizar entrega pedidos',
                'revertir pedidos',
                'view own pedidos',
                'edit own pedidos',
                'view own pedido',
            ],
            // Módulo de clientes
            'clientes' => [
                'view own profile',
                'edit own profile',
            ],
            // Módulo de categorías
            'categorias' => [
                'access categorias',
                'create categorias',
                'edit categorias',
                'delete categorias',
                'view categorias',
            ],
            // Módulo de marcas
            'marcas' => [
                'access marcas',
                'create marcas',
                'edit marcas',
                'delete marcas',
                'view marcas',
            ],
            // Módulo de productos
            'productos' => [
                'access productos',
                'create productos',
                'edit productos',
                'delete productos',
                'view productos',
                'view product details',
            ],
            // Módulo de ofertas
            'ofertas' => [
                'access ofertas',
                'create ofertas',
                'edit ofertas',
                'delete ofertas',
                'view ofertas',
            ],
            // Módulo de empleados
            'empleados' => [
                'access empleados',
                'create empleados',
                'edit empleados',
                'delete empleados',
                'view empleados',
            ],
            // Módulo de WhatsApp
            'whatsapp' => [
                'access whatsapp',
                'create whatsapp templates',
                'edit whatsapp templates',
                'delete whatsapp templates',
                'send whatsapp messages',
                'schedule whatsapp messages',
                'view whatsapp statistics',
                'export whatsapp reports',
                'retry failed whatsapp messages',
                'view whatsapp retry statistics',
                'manage whatsapp auto retry',
            ],
             // Módulo de ventas
            'ventas' => [
                'access ventas',
                'view ventas',
                'create ventas',
                'edit ventas',
                'delete ventas',
                'anular ventas',
                'imprimir ventas',
            ],
        ];

        // Crear permisos organizados por módulos
        foreach ($modules as $module => $permissions) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate(
                    ['name' => $permission],
                    ['module' => $module]
                );
            }
        }

        // Crear roles y asignar permisos
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Administrador']);
        $adminRole = Role::firstOrCreate(['name' => 'Administrador']);
        $recepcionistaRole = Role::firstOrCreate(['name' => 'Recepcionista']);
        $clienteRole = Role::firstOrCreate(['name' => 'Cliente']);
        $empleadoRole = Role::firstOrCreate(['name' => 'Empleado']);

        // Asignar todos los permisos al Super Administrador
        $superAdminRole->syncPermissions(Permission::all());

        // Asignar permisos al Administrador (todos menos los de super admin)
        $adminPermissions = Permission::whereNotIn('name', [
            'assign roles',
            'assign permissions'
        ])->get();
        $adminRole->syncPermissions($adminPermissions);

        // Asignar permisos al Recepcionista (solo de estudiantes, matrículas, pagos y dashboard básico)
        $recepcionistaPermissions = Permission::whereIn('module', [
            'students',
            'matriculas',
            'pagos'
        ])->orWhereIn('name', [
            'access dashboard',
            'dashboard.alerts',
            'dashboard.academic',
            'dashboard.access'
        ])->get();
        $recepcionistaRole->syncPermissions($recepcionistaPermissions);

        // Asignar permisos al Cliente (solo permisos propios)
        $clientePermissions = Permission::whereIn('module', [
            'pedidos',
            'clientes'
        ])->get();
        $clienteRole->syncPermissions($clientePermissions);

        // Asignar permisos al Cliente (solo permisos propios)
        $empleadoPermissions = Permission::whereIn('module', [
            'pedidos'
        ])->get();
        $empleadoRole->syncPermissions($empleadoPermissions);

        // Asignar permisos de mensajería, biblioteca, series, cajas, reuniones, países y WhatsApp Multi-Cliente a Administradores y Super Administradores
        $mensajeriaBibliotecaSeriesCajasPaisesWhatsAppPermissions = Permission::whereIn('module', [
            'mensajeria',
            'biblioteca',
            'series',
            'cajas',
            'reuniones',
            'paises',
            'categorias',
            'marcas',
            'empleados',
            'pedidos',
            'ofertas',

        ])->get();

        $superAdminRole->givePermissionTo($mensajeriaBibliotecaSeriesCajasPaisesWhatsAppPermissions);
        $adminRole->givePermissionTo($mensajeriaBibliotecaSeriesCajasPaisesWhatsAppPermissions);

        // Asignar permiso exclusivo de WhatsApp Dashboard solo al Super Administrador
        $whatsappDashboardPermission = Permission::where('name', 'access whatsapp dashboard')->first();
        if ($whatsappDashboardPermission) {
            $superAdminRole->givePermissionTo($whatsappDashboardPermission);
        }
    }
}
