<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PolarSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Polar', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Polar'),
                'descripcion' => 'Productos Polar',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Arroz Blanco Polar', 'descripcion' => 'Arroz blanco de alta calidad', 'precio_base' => 1.50, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'ARZ-POLAR-1KG', 'precio_ajuste' => 0, 'cantidad' => 100], ['nombre' => 'Peso: 5kg', 'values' => ['Peso' => '5kg'], 'sku' => 'ARZ-POLAR-5KG', 'precio_ajuste' => 0, 'cantidad' => 50]]],
            ['nombre' => 'Harina de Maíz Precocida Polar', 'descripcion' => 'Harina de maíz precocida para arepas', 'precio_base' => 1.20, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'HAR-POL-1KG', 'precio_ajuste' => 0, 'cantidad' => 120], ['nombre' => 'Peso: 2kg', 'values' => ['Peso' => '2kg'], 'sku' => 'HAR-POL-2KG', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Harina de Trigo Pol', 'descripcion' => 'Harina de trigo 1kg', 'precio_base' => 1.20, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'HAR-POL-TRI-1KG', 'precio_ajuste' => 0, 'cantidad' => 120], ['nombre' => 'Peso: 2kg', 'values' => ['Peso' => '2kg'], 'sku' => 'HAR-POL-TRI-2KG', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Aceite de Soja Soya', 'descripcion' => 'Aceite de soja 900ml', 'precio_base' => 2.00, 'variantes' => [['nombre' => 'Volumen: 900ml', 'values' => ['Volumen' => '900ml'], 'sku' => 'ACE-SOY-900', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Pasta Larga tipo Spaghetti Santa Rita', 'descripcion' => 'Pasta seca tipo spaghetti', 'precio_base' => 0.90, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-POL-500', 'precio_ajuste' => 0, 'cantidad' => 110]]],
            ['nombre' => 'Azúcar Morena', 'descripcion' => 'Azúcar morena Polar', 'precio_base' => 1.10, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'AZU-POL-1KG', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Sal de Mesa', 'descripcion' => 'Sal de mesa refinada', 'precio_base' => 0.50, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'SAL-POL-1KG', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Café Instantáneo', 'descripcion' => 'Café instantáneo soluble', 'precio_base' => 2.80, 'variantes' => [['nombre' => 'Peso: 200gr', 'values' => ['Peso' => '200gr'], 'sku' => 'CAF-POL-200', 'precio_ajuste' => 0, 'cantidad' => 60]]],
            ['nombre' => 'Leche en Polvo', 'descripcion' => 'Leche en polvo entera', 'precio_base' => 3.20, 'variantes' => [['nombre' => 'Peso: 400gr', 'values' => ['Peso' => '400gr'], 'sku' => 'LEC-POL-400', 'precio_ajuste' => 0, 'cantidad' => 75], ['nombre' => 'Peso: 800gr', 'values' => ['Peso' => '800gr'], 'sku' => 'LEC-POL-800', 'precio_ajuste' => 0, 'cantidad' => 50]]],
            ['nombre' => 'Galletas Saladas', 'descripcion' => 'Galletas saladas clásicas', 'precio_base' => 0.80, 'variantes' => [['nombre' => 'Peso: 250gr', 'values' => ['Peso' => '250gr'], 'sku' => 'GAL-POL-250', 'precio_ajuste' => 0, 'cantidad' => 120]]],
            ['nombre' => 'Salsa de Tomate', 'descripcion' => 'Salsa de tomate tradicional', 'precio_base' => 1.50, 'variantes' => [['nombre' => 'Peso: 340gr', 'values' => ['Peso' => '340gr'], 'sku' => 'SAL-POL-340', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Mayonesa', 'descripcion' => 'Mayonesa suave', 'precio_base' => 1.80, 'variantes' => [['nombre' => 'Peso: 350gr', 'values' => ['Peso' => '350gr'], 'sku' => 'MAY-POL-350', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Mermelada Fresa', 'descripcion' => 'Mermelada de fresa', 'precio_base' => 2.20, 'variantes' => [['nombre' => 'Peso: 454gr', 'values' => ['Peso' => '454gr'], 'sku' => 'MER-POL-454', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Atún en Agua', 'descripcion' => 'Atún en agua', 'precio_base' => 1.90, 'variantes' => [['nombre' => 'Peso: 160gr', 'values' => ['Peso' => '160gr'], 'sku' => 'ATU-POL-160', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Sardinas en Aceite', 'descripcion' => 'Sardinas en aceite vegetal', 'precio_base' => 1.60, 'variantes' => [['nombre' => 'Peso: 120gr', 'values' => ['Peso' => '120gr'], 'sku' => 'SAR-POL-120', 'precio_ajuste' => 0, 'cantidad' => 80]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Polar: 15 productos creados con 17 variantes');
    }
}