<?php

namespace Database\Seeders;

use App\Models\Pais;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class PaisSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Datos de países latinoamericanos
        $paisesLatinoamericanos = [
            [
                'nombre' => 'Argentina',
                'codigo_iso2' => 'AR',
                'codigo_iso3' => 'ARG',
                'codigo_telefonico' => '+54',
                'moneda_principal' => 'ARS',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Argentina/Buenos_Aires',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '1.234,56',
                'impuesto_predeterminado' => 21.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Bolivia',
                'codigo_iso2' => 'BO',
                'codigo_iso3' => 'BOL',
                'codigo_telefonico' => '+591',
                'moneda_principal' => 'BOB',
                'simbolo_moneda' => 'Bs.',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/La_Paz',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '1.234,56',
                'impuesto_predeterminado' => 13.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Brasil',
                'codigo_iso2' => 'BR',
                'codigo_iso3' => 'BRA',
                'codigo_telefonico' => '+55',
                'moneda_principal' => 'BRL',
                'simbolo_moneda' => 'R$',
                'idioma_principal' => 'pt',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Sao_Paulo',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '1.234,56',
                'impuesto_predeterminado' => 17.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Chile',
                'codigo_iso2' => 'CL',
                'codigo_iso3' => 'CHL',
                'codigo_telefonico' => '+56',
                'moneda_principal' => 'CLP',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Santiago',
                'formato_fecha' => 'dd-mm-yyyy',
                'formato_moneda' => '1.234.567',
                'impuesto_predeterminado' => 19.00,
                'separador_miles' => '.',
                'separador_decimales' => '',
                'decimales_moneda' => 0,
                'activo' => true
            ],
            [
                'nombre' => 'Colombia',
                'codigo_iso2' => 'CO',
                'codigo_iso3' => 'COL',
                'codigo_telefonico' => '+57',
                'moneda_principal' => 'COP',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Bogota',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$1.234,56',
                'impuesto_predeterminado' => 19.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Costa Rica',
                'codigo_iso2' => 'CR',
                'codigo_iso3' => 'CRI',
                'codigo_telefonico' => '+506',
                'moneda_principal' => 'CRC',
                'simbolo_moneda' => '₡',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/Costa_Rica',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '1.234,56',
                'impuesto_predeterminado' => 13.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Cuba',
                'codigo_iso2' => 'CU',
                'codigo_iso3' => 'CUB',
                'codigo_telefonico' => '+53',
                'moneda_principal' => 'CUP',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'El Caribe',
                'zona_horaria' => 'America/Havana',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '1.234,56',
                'impuesto_predeterminado' => 10.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Ecuador',
                'codigo_iso2' => 'EC',
                'codigo_iso3' => 'ECU',
                'codigo_telefonico' => '+593',
                'moneda_principal' => 'USD',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Guayaquil',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$1.234,56',
                'impuesto_predeterminado' => 12.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'El Salvador',
                'codigo_iso2' => 'SV',
                'codigo_iso3' => 'SLV',
                'codigo_telefonico' => '+503',
                'moneda_principal' => 'USD',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/El_Salvador',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$1.234,56',
                'impuesto_predeterminado' => 13.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Guatemala',
                'codigo_iso2' => 'GT',
                'codigo_iso3' => 'GTM',
                'codigo_telefonico' => '+502',
                'moneda_principal' => 'GTQ',
                'simbolo_moneda' => 'Q',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/Guatemala',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'Q1.234,56',
                'impuesto_predeterminado' => 12.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Honduras',
                'codigo_iso2' => 'HN',
                'codigo_iso3' => 'HND',
                'codigo_telefonico' => '+504',
                'moneda_principal' => 'HNL',
                'simbolo_moneda' => 'L',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/Tegucigalpa',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'L1.234,56',
                'impuesto_predeterminado' => 15.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'México',
                'codigo_iso2' => 'MX',
                'codigo_iso3' => 'MEX',
                'codigo_telefonico' => '+52',
                'moneda_principal' => 'MXN',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América del Norte',
                'zona_horaria' => 'America/Mexico_City',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$1.234,56',
                'impuesto_predeterminado' => 16.00,
                'separador_miles' => ',',
                'separador_decimales' => '.',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Nicaragua',
                'codigo_iso2' => 'NI',
                'codigo_iso3' => 'NIC',
                'codigo_telefonico' => '+505',
                'moneda_principal' => 'NIO',
                'simbolo_moneda' => 'C$',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/Managua',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'C$1.234,56',
                'impuesto_predeterminado' => 15.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Panamá',
                'codigo_iso2' => 'PA',
                'codigo_iso3' => 'PAN',
                'codigo_telefonico' => '+507',
                'moneda_principal' => 'USD',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'América Central',
                'zona_horaria' => 'America/Panama',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$1.234,56',
                'impuesto_predeterminado' => 7.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Paraguay',
                'codigo_iso2' => 'PY',
                'codigo_iso3' => 'PRY',
                'codigo_telefonico' => '+595',
                'moneda_principal' => 'PYG',
                'simbolo_moneda' => '₲',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Asuncion',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '₲1.234,56',
                'impuesto_predeterminado' => 10.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Perú',
                'codigo_iso2' => 'PE',
                'codigo_iso3' => 'PER',
                'codigo_telefonico' => '+51',
                'moneda_principal' => 'PEN',
                'simbolo_moneda' => 'S/.',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Lima',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'S/. 1.234,56',
                'impuesto_predeterminado' => 18.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Puerto Rico',
                'codigo_iso2' => 'PR',
                'codigo_iso3' => 'PRI',
                'codigo_telefonico' => '+1',
                'moneda_principal' => 'USD',
                'simbolo_moneda' => '$',
                'idioma_principal' => 'es',
                'continente' => 'El Caribe',
                'zona_horaria' => 'America/Puerto_Rico',
                'formato_fecha' => 'mm/dd/yyyy',
                'formato_moneda' => '$1,234.56',
                'impuesto_predeterminado' => 11.50,
                'separador_miles' => ',',
                'separador_decimales' => '.',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'República Dominicana',
                'codigo_iso2' => 'DO',
                'codigo_iso3' => 'DOM',
                'codigo_telefonico' => '+1',
                'moneda_principal' => 'DOP',
                'simbolo_moneda' => 'RD$',
                'idioma_principal' => 'es',
                'continente' => 'El Caribe',
                'zona_horaria' => 'America/Santo_Domingo',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'RD$1.234,56',
                'impuesto_predeterminado' => 18.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Uruguay',
                'codigo_iso2' => 'UY',
                'codigo_iso3' => 'URY',
                'codigo_telefonico' => '+598',
                'moneda_principal' => 'UYU',
                'simbolo_moneda' => '$U',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Montevideo',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => '$U 1.234,56',
                'impuesto_predeterminado' => 22.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ],
            [
                'nombre' => 'Venezuela',
                'codigo_iso2' => 'VE',
                'codigo_iso3' => 'VEN',
                'codigo_telefonico' => '+58',
                'moneda_principal' => 'VES',
                'simbolo_moneda' => 'Bs.',
                'idioma_principal' => 'es',
                'continente' => 'América del Sur',
                'zona_horaria' => 'America/Caracas',
                'formato_fecha' => 'dd/mm/yyyy',
                'formato_moneda' => 'Bs. 1.234,56',
                'impuesto_predeterminado' => 16.00,
                'separador_miles' => '.',
                'separador_decimales' => ',',
                'decimales_moneda' => 2,
                'activo' => true
            ]
        ];

        // Insertar o actualizar los países
        foreach ($paisesLatinoamericanos as $pais) {
            Pais::updateOrCreate(
                ['codigo_iso2' => $pais['codigo_iso2']], // Condición para buscar
                $pais // Datos a actualizar o crear
            );
        }

        $this->command->info('✅ Países latinoamericanos insertados exitosamente');
        $this->command->info('📊 Total de países: ' . count($paisesLatinoamericanos));
    }
}
