<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Producto;
use App\Models\Marca;
use App\Models\Categoria;

class OsoBlancoSeeder extends Seeder
{
    public function run(): void
    {
        $marca = Marca::where('nombre', 'Oso Blanco')->first();
        $categoria = Categoria::where('nombre', 'Papel')->first();

        $productos = [
            ['nombre' => 'Oso Blanco Papel Higiénico 4 rollos', 'precio' => 4.50],
            ['nombre' => 'Oso Blanco Papel Higiénico 8 rollos', 'precio' => 8.50],
            ['nombre' => 'Oso Blanco Papel Higiénico 12 rollos', 'precio' => 12.00],
            ['nombre' => 'Oso Blanco Toallas de Papel 2 rollos', 'precio' => 5.50],
            ['nombre' => 'Oso Blanco Toallas de Papel 4 rollos', 'precio' => 10.50],
            ['nombre' => 'Oso Blanco Servilletas 100 unidades', 'precio' => 2.25],
            ['nombre' => 'Oso Blanco Servilletas 200 unidades', 'precio' => 4.00],
            ['nombre' => 'Oso Blanco Pañuelos Faciales', 'precio' => 3.25],
        ];

        foreach ($productos as $producto) {
            Producto::create([
                'nombre' => $producto['nombre'],
                'precio' => $producto['precio'],
                'marca_id' => $marca->id,
                'categoria_id' => $categoria->id,
                'activo' => true,
            ]);
        }
    }
}