<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Empleado;
use App\Models\User;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Support\Facades\Hash;

class EmpleadosTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Datos de empleados de ejemplo
        $empleadosData = [
            [
                'nombres' => 'Carlos',
                'apellidos' => 'Rodríguez Pérez',
                'documento' => '12345678',
                'tipo_documento' => 'cedula',
                'email' => 'carlos.rodriguez@empresa.com',
                'telefono' => '0412-1234567',
                'fecha_nacimiento' => '1985-05-15',
                'genero' => 'masculino',
                'direccion' => 'Calle Los Olmos, Urbanización Los Ángeles',
                'cargo' => 'Gerente de Ventas',
                'departamento' => 'Ventas',
                'salario' => 2500.00,
                'fecha_ingreso' => '2023-01-15',
                'estado_civil' => 'casado',
                'contacto_emergencia' => 'María Rodríguez',
                'telefono_emergencia' => '0412-7654321',
                'observaciones' => 'Empleado con experiencia en ventas internacionales'
            ],
            [
                'nombres' => 'Ana',
                'apellidos' => 'González López',
                'documento' => '87654321',
                'tipo_documento' => 'cedula',
                'email' => 'ana.gonzalez@empresa.com',
                'telefono' => '0414-7654321',
                'fecha_nacimiento' => '1990-08-22',
                'genero' => 'femenino',
                'direccion' => 'Avenida Bolívar, Torre Central Piso 5',
                'cargo' => 'Supervisora de Almacén',
                'departamento' => 'Logística',
                'salario' => 1800.00,
                'fecha_ingreso' => '2023-03-10',
                'estado_civil' => 'soltero',
                'contacto_emergencia' => 'José González',
                'telefono_emergencia' => '0414-1234567',
                'observaciones' => 'Responsable de inventario y control de stock'
            ],
            [
                'nombres' => 'Luis',
                'apellidos' => 'Martínez Sánchez',
                'documento' => '11223344',
                'tipo_documento' => 'cedula',
                'email' => 'luis.martinez@empresa.com',
                'telefono' => '0426-9876543',
                'fecha_nacimiento' => '1988-12-10',
                'genero' => 'masculino',
                'direccion' => 'Calle Miranda, Quinta Los Rosales',
                'cargo' => 'Asistente Administrativo',
                'departamento' => 'Administración',
                'salario' => 1500.00,
                'fecha_ingreso' => '2023-06-01',
                'estado_civil' => 'casado',
                'contacto_emergencia' => 'Carmen Sánchez',
                'telefono_emergencia' => '0426-3216549',
                'observaciones' => 'Apoyo en tareas administrativas y atención al cliente'
            ],
            [
                'nombres' => 'María',
                'apellidos' => 'Fernández Torres',
                'documento' => '55667788',
                'tipo_documento' => 'cedula',
                'email' => 'maria.fernandez@empresa.com',
                'telefono' => '0412-5556677',
                'fecha_nacimiento' => '1992-04-18',
                'genero' => 'femenino',
                'direccion' => 'Urbanización Las Palmas, Casa 25',
                'cargo' => 'Cajera',
                'departamento' => 'Caja',
                'salario' => 1200.00,
                'fecha_ingreso' => '2024-01-15',
                'estado_civil' => 'soltero',
                'contacto_emergencia' => 'Rosa Torres',
                'telefono_emergencia' => '0412-7778899',
                'observaciones' => 'Manejo de caja y atención al público'
            ],
            [
                'nombres' => 'Jorge',
                'apellidos' => 'Pérez Ramírez',
                'documento' => '99887766',
                'tipo_documento' => 'cedula',
                'email' => 'jorge.perez@empresa.com',
                'telefono' => '0424-3332211',
                'fecha_nacimiento' => '1983-09-05',
                'genero' => 'masculino',
                'direccion' => 'Avenida Los Próceres, Edificio Los Jardines',
                'cargo' => 'Vendedor',
                'departamento' => 'Ventas',
                'salario' => 1400.00,
                'fecha_ingreso' => '2023-11-20',
                'estado_civil' => 'casado',
                'contacto_emergencia' => 'Diana Ramírez',
                'telefono_emergencia' => '0424-8889900',
                'observaciones' => 'Atención en mostrador y ventas telefónicas'
            ]
        ];

        foreach ($empleadosData as $index => $empleadoData) {
            // Crear el usuario primero

             $name_slice = explode(" ",$empleadoData['nombres'].' '.$empleadoData['apellidos']);
             $initial  = strtoupper($name_slice[0][0]);
             $initial2 = $name_slice;
             $username = strtolower($initial.$initial2[1]);

            $user = User::create([
                'name' => $empleadoData['nombres'] . ' ' . $empleadoData['apellidos'],
                'username' => $username,
                'email' => $empleadoData['email'],
                'telefono' => $empleadoData['telefono'],
                'password' => Hash::make('password123'), // Contraseña por defecto
                'email_verified_at' => now(),
                'empresa_id' => 1,
                'sucursal_id' => 1,
                'status' => true
            ]);

            // Asignar rol de empleado
            $user->assignRole('Empleado');

            // Generar código único para el empleado
            $codigo = 'EMP' . str_pad($index + 1, 4, '0', STR_PAD_LEFT);

            // Crear el empleado con el user_id relacionado
            Empleado::create([
                'codigo' => $codigo,
                'nombres' => $empleadoData['nombres'],
                'apellidos' => $empleadoData['apellidos'],
                'documento' => $empleadoData['documento'],
                'tipo_documento' => $empleadoData['tipo_documento'],
                'email' => $empleadoData['email'],
                'telefono' => $empleadoData['telefono'],
                'fecha_nacimiento' => $empleadoData['fecha_nacimiento'],
                'genero' => $empleadoData['genero'],
                'direccion' => $empleadoData['direccion'],
                'cargo' => $empleadoData['cargo'],
                'departamento' => $empleadoData['departamento'],
                'salario' => $empleadoData['salario'],
                'fecha_ingreso' => $empleadoData['fecha_ingreso'],
                'estado_civil' => $empleadoData['estado_civil'],
                'contacto_emergencia' => $empleadoData['contacto_emergencia'],
                'telefono_emergencia' => $empleadoData['telefono_emergencia'],
                'observaciones' => $empleadoData['observaciones'],
                'status' => true,
                'empresa_id' => 1,
                'sucursal_id' => 1,
                'user_id' => $user->id
            ]);
        }

        $this->command->info('✅ Seeder de Empleados ejecutado exitosamente!');
        $this->command->info('📊 Se crearon ' . count($empleadosData) . ' empleados con sus usuarios correspondientes.');
        $this->command->info('🔑 Contraseña por defecto para todos los empleados: password123');
        $this->command->info('📧 Los usuarios tienen el rol: Empleado');
    }
}
