<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Empresa;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategoriaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener la primera empresa como ejemplo
        $empresa = Empresa::first();

        if ($empresa) {
            $categorias = [
                [
                    'nombre' => 'Alimentos',
                    'descripcion' => 'Alimentos frescos y de calidad',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Bebidas',
                    'descripcion' => 'Bebidas',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Aseo persona e Higiene',
                    'descripcion' => 'Productos para el aseo personal y la higiene',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Cigarros',
                    'descripcion' => 'Artículos de cigarrillos',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Golosinas',
                    'descripcion' => 'Golosina',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ],
                [
                    'nombre' => 'Víveres',
                    'descripcion' => 'Víveres',
                    'activo' => true,
                    'empresa_id' => $empresa->id,
                    'sucursal_id' => null
                ]
            ];

            foreach ($categorias as $categoria) {
                Categoria::updateOrCreate(
                    ['nombre' => $categoria['nombre'], 'empresa_id' => $categoria['empresa_id']],
                    array_merge($categoria, ['slug' => Str::slug($categoria['nombre'])])
                );
            }
        }
    }
}
