<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CapriSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Capri', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Capri'),
                'descripcion' => 'Productos Capri',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Pasta Premium Codito 1kg Capri', 'descripcion' => 'Pasta premium codito de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-COD-1KG', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Pasta Premium Spaghetti 1kg Capri', 'descripcion' => 'Pasta premium spaghetti de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-SPA-1KG', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Premium Linguini 1kg Capri', 'descripcion' => 'Pasta premium linguini de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-LIN-1KG', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Pasta Premium Macarron 1kg Capri', 'descripcion' => 'Pasta premium macarron de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-MAC-1KG', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Pasta Premium Pluma 1kg Capri', 'descripcion' => 'Pasta premium pluma de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-PLU-1KG', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Premium Fettuccine 1kg Capri', 'descripcion' => 'Pasta premium fettuccine de 1kg', 'precio_base' => 2.35, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-FET-1KG', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Pasta Premium Caracola 1kg Capri', 'descripcion' => 'Pasta premium caracola de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-CAR-1KG', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Pasta Premium Tornillo 1kg Capri', 'descripcion' => 'Pasta premium tornillo de 1kg', 'precio_base' => 2.23, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-TOR-1KG', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Premium Angel Hair 1kg Capri', 'descripcion' => 'Pasta premium cabello de angel de 1kg', 'precio_base' => 2.30, 'variantes' => [['nombre' => 'Peso: 1kg', 'values' => ['Peso' => '1kg'], 'sku' => 'PAS-CAP-ANG-1KG', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Pasta Premium Lasagna 500gr Capri', 'descripcion' => 'Pasta premium lasagna de 500gr', 'precio_base' => 1.85, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-LAS-500', 'precio_ajuste' => 0, 'cantidad' => 60]]],
            ['nombre' => 'Pasta Premium Ravioli 500gr Capri', 'descripcion' => 'Pasta premium ravioli de 500gr', 'precio_base' => 2.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-RAV-500', 'precio_ajuste' => 0, 'cantidad' => 50]]],
            ['nombre' => 'Pasta Premium Farfalle 500gr Capri', 'descripcion' => 'Pasta premium farfalle de 500gr', 'precio_base' => 1.95, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-FAR-500', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Pasta Premium Rigatoni 500gr Capri', 'descripcion' => 'Pasta premium rigatoni de 500gr', 'precio_base' => 1.90, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-RIG-500', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Pasta Premium Pappardelle 500gr Capri', 'descripcion' => 'Pasta premium pappardelle de 500gr', 'precio_base' => 2.15, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-PAP-500', 'precio_ajuste' => 0, 'cantidad' => 65]]],
            ['nombre' => 'Pasta Premium Tagliatelle 500gr Capri', 'descripcion' => 'Pasta premium tagliatelle de 500gr', 'precio_base' => 2.10, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-TAG-500', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Pasta Premium Gnocchi 500gr Capri', 'descripcion' => 'Pasta premium gnocchi de 500gr', 'precio_base' => 2.55, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-GNO-500', 'precio_ajuste' => 0, 'cantidad' => 45]]],
            ['nombre' => 'Pasta Premium Orzo 500gr Capri', 'descripcion' => 'Pasta premium orzo de 500gr', 'precio_base' => 1.85, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-CAP-ORZ-500', 'precio_ajuste' => 0, 'cantidad' => 80]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Capri: 17 productos creados con 17 variantes');
    }
}