<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class BokaSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Boka', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Boka'),
                'descripcion' => 'Productos Boka',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Refresco Boka Sabor Fresa', 'descripcion' => 'Refresco en polvo sabor fresa 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-FRE-18', 'precio_ajuste' => 0, 'cantidad' => 100]]],
            ['nombre' => 'Refresco Boka Sabor Mango', 'descripcion' => 'Refresco en polvo sabor mango 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-MAN-18', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Refresco Boka Sabor Sandía', 'descripcion' => 'Refresco en polvo sabor sandía 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-SAN-18', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Refresco Boka Sabor Maracuyá', 'descripcion' => 'Refresco en polvo sabor maracuyá 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-MAR-18', 'precio_ajuste' => 0, 'cantidad' => 110]]],
            ['nombre' => 'Refresco Boka Sabor Guanábana', 'descripcion' => 'Refresco en polvo sabor guanábana 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-GUA-18', 'precio_ajuste' => 0, 'cantidad' => 120]]],
            ['nombre' => 'Refresco Boka Sabor Corozo', 'descripcion' => 'Refresco en polvo sabor corozo 10gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'REF-BOK-COR-10', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Refresco Boka Sabor Lichi', 'descripcion' => 'Refresco en polvo sabor lichi 10gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'REF-BOK-LIC-10', 'precio_ajuste' => 0, 'cantidad' => 95]]],
            ['nombre' => 'Refresco Boka Sabor Tamarindo', 'descripcion' => 'Refresco en polvo sabor tamarindo 10gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 10gr', 'values' => ['Peso' => '10gr'], 'sku' => 'REF-BOK-TAM-10', 'precio_ajuste' => 0, 'cantidad' => 130]]],
            ['nombre' => 'Refresco Boka Sabor Lima Limón', 'descripcion' => 'Refresco en polvo sabor lima limón 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-LIM-18', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Refresco Boka Sabor Naranja', 'descripcion' => 'Refresco en polvo sabor naranja 18gr', 'precio_base' => 0.79, 'variantes' => [['nombre' => 'Peso: 18gr', 'values' => ['Peso' => '18gr'], 'sku' => 'REF-BOK-NAR-18', 'precio_ajuste' => 0, 'cantidad' => 75]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Boka: 10 productos creados con 10 variantes');
    }
}