<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Marca;
use App\Models\Producto;
use App\Models\ProductoVariant;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class AllegriSeeder extends Seeder
{
    public function run(): void
    {
        $empresa = Empresa::first();
        $sucursal = Sucursal::where('empresa_id', $empresa->id)->first();
        
        $categoria = Categoria::firstOrCreate(
            ['nombre' => 'Víveres', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Víveres'),
                'descripcion' => 'Productos de despensa básica',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $marca = Marca::firstOrCreate(
            ['nombre' => 'Allegri', 'empresa_id' => $empresa->id],
            [
                'slug' => Str::slug('Allegri'),
                'descripcion' => 'Productos Allegri',
                'activo' => true,
                'sucursal_id' => $sucursal->id,
            ]
        );

        $productos = [
            ['nombre' => 'Pasta Larga Spaghetti 500gr Allegri', 'descripcion' => 'Pasta larga spaghetti de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-SPA-500', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Pasta Larga Linguini 500gr Allegri', 'descripcion' => 'Pasta larga linguini de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-LIN-500', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Corta Macarron 500gr Allegri', 'descripcion' => 'Pasta corta macarron de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-MAC-500', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Pasta Corta Pluma 500gr Allegri', 'descripcion' => 'Pasta corta pluma de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-PLU-500', 'precio_ajuste' => 0, 'cantidad' => 85]]],
            ['nombre' => 'Pasta Corta Codito 500gr Allegri', 'descripcion' => 'Pasta corta codito de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-COD-500', 'precio_ajuste' => 0, 'cantidad' => 90]]],
            ['nombre' => 'Pasta Larga Fettuccine 500gr Allegri', 'descripcion' => 'Pasta larga fettuccine de 500gr', 'precio_base' => 1.55, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-FET-500', 'precio_ajuste' => 0, 'cantidad' => 75]]],
            ['nombre' => 'Pasta Corta Caracola 500gr Allegri', 'descripcion' => 'Pasta corta caracola de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-CAR-500', 'precio_ajuste' => 0, 'cantidad' => 80]]],
            ['nombre' => 'Pasta Larga Angel Hair 500gr Allegri', 'descripcion' => 'Pasta larga cabello de angel de 500gr', 'precio_base' => 1.50, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-ANG-500', 'precio_ajuste' => 0, 'cantidad' => 70]]],
            ['nombre' => 'Pasta Corta Tornillo 500gr Allegri', 'descripcion' => 'Pasta corta tornillo de 500gr', 'precio_base' => 1.45, 'variantes' => [['nombre' => 'Peso: 500gr', 'values' => ['Peso' => '500gr'], 'sku' => 'PAS-ALL-TOR-500', 'precio_ajuste' => 0, 'cantidad' => 85]]],
        ];

        foreach ($productos as $productoData) {
            $producto = Producto::create([
                'code' => strtoupper(substr(Str::slug($productoData['nombre']), 0, 3)) . '-' . rand(10000, 99999),
                'name' => $productoData['nombre'],
                'price' => $productoData['precio_base'],
                'precio_bs' => $productoData['precio_base'] * 35,
                'description' => $productoData['descripcion'],
                'quantity' => array_sum(array_column($productoData['variantes'], 'cantidad')),
                'quantity_alert' => 10,
                'status' => true,
                'empresa_id' => $empresa->id,
                'categoria_id' => $categoria->id,
                'marca_id' => $marca->id,
            ]);

            foreach ($productoData['variantes'] as $varianteData) {
                ProductoVariant::create([
                    'producto_id' => $producto->id,
                    'name' => $varianteData['nombre'],
                    'values' => $varianteData['values'],
                    'sku' => $varianteData['sku'],
                    'price_adjustment' => $varianteData['precio_ajuste'],
                    'quantity' => $varianteData['cantidad'],
                    'image_path' => null,
                    'image_thumbnail_path' => null,
                    'alt_text' => $varianteData['nombre'] . ' - ' . $productoData['nombre'],
                    'empresa_id' => $empresa->id,
                ]);
            }
        }

        $this->command->info('Allegri: 9 productos creados con 9 variantes');
    }
}