<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notas_venta', function (Blueprint $table) {
            if (!Schema::hasColumn('notas_venta', 'venta_id')) {
                $table->foreignId('venta_id')->nullable()->after('estado')->constrained('ventas')->onDelete('set null');
            }
            if (!Schema::hasColumn('notas_venta', 'metodo_pago')) {
                $table->string('metodo_pago')->nullable()->after('observaciones');
            }
            if (!Schema::hasColumn('notas_venta', 'serie_id')) {
                $table->foreignId('serie_id')->nullable()->after('metodo_pago')->constrained('series')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notas_venta', function (Blueprint $table) {
            $table->dropForeign(['venta_id']);
            $table->dropForeign(['serie_id']);
            $table->dropColumn(['venta_id', 'metodo_pago', 'serie_id']);
        });
    }
};