<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('venta_pagos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('venta_id')->constrained('ventas')->onDelete('cascade');
            $table->enum('metodo_pago', ['efectivo', 'transferencia', 'tarjeta', 'pago_movil', 'punto_de_venta']);
            $table->decimal('monto', 10, 2);
            $table->decimal('monto_recibido', 10, 2);
            $table->decimal('cambio', 10, 2)->default(0);
            $table->string('referencia')->nullable();
            $table->foreignId('caja_id')->constrained('cajas');
            $table->boolean('confirmado')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('venta_pagos');
    }
};