<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('ventas', function (Blueprint $table) {
            $table->id();
            $table->string('codigo')->unique();
            $table->decimal('total', 10, 2);
            $table->decimal('total_usd', 10, 2);
            $table->decimal('total_bs', 15, 2);
            $table->enum('metodo_pago', ['efectivo', 'transferencia', 'tarjeta', 'pago_movil', 'punto_de_venta']);
            $table->enum('estado', ['pendiente', 'pagado', 'cancelado'])->default('pagado');
            $table->enum('tipo_documento', ['boleta', 'factura', 'nota_credito', 'recibo']);
            $table->string('numero_documento');
            $table->foreignId('serie_id')->constrained('series');
            $table->foreignId('caja_id')->constrained('cajas');
            $table->foreignId('empresa_id')->constrained('empresas');
            $table->foreignId('sucursal_id')->nullable()->constrained('sucursales');
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('empleado_id')->constrained('users');
            $table->foreignId('cliente_id')->nullable()->constrained('users');
            $table->decimal('descuento', 10, 2)->default(0);
            $table->decimal('impuesto', 10, 2)->default(0);
            $table->text('observaciones')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ventas');
    }
};
