<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('empleado_pedido', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empleadoId');
            $table->unsignedBigInteger('pedidoId');
            $table->timestamps();

            $table->foreign('empleadoId')->references('id')->on('empleados')->onDelete('cascade');
            $table->foreign('pedidoId')->references('id')->on('pedidos')->onDelete('cascade');
            
            $table->unique(['empleadoId', 'pedidoId']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('empleado_pedido');
    }
};